/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModelRoleSupport;
import biouml.model.dynamics.ExpressionOwner;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;

@PropertyName(value="Event")
@PropertyDescription(value="Event describe the time and form of explicit instantaneous <br>discontinuous state changes in the model. For example, <br>an event may describe that one species concentration <br>is halved when another species concentration exceeds a given threshold value.")
public class Event
extends EModelRoleSupport
implements ExpressionOwner {
    protected String delay = "0";
    protected String trigger = "false";
    protected String timeUnits = "time";
    protected boolean useValuesFromTriggerTime = true;
    private String triggerMessage = "";
    protected String priority = "";
    protected boolean triggerInitialValue = true;
    protected boolean triggerPersistent = true;
    protected Assignment[] eventAssignment = new Assignment[0];

    public Event(DiagramElement de) {
        super(de);
        this.addEventAssignment(new Assignment("unknown", "0"), false);
    }

    public Event(DiagramElement de, String trigger, String delay, Assignment[] actions) {
        super(de);
        this.trigger = this.transformSingleEquals(trigger);
        if (delay != null && !delay.isEmpty()) {
            this.delay = delay;
        }
        if (actions != null) {
            for (Assignment element : this.eventAssignment = actions) {
                element.setParent(this);
            }
        }
    }

    @PropertyName(value="Trigger")
    @PropertyDescription(value="Trigger defines condition for event occuring.")
    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        trigger = this.transformSingleEquals(trigger);
        String oldValue = this.trigger;
        this.trigger = trigger;
        this.firePropertyChange("trigger", oldValue, trigger);
    }

    @PropertyName(value="Trigger message")
    @PropertyDescription(value="Message displaying when event is triggered.")
    public String getTriggerMessage() {
        return this.triggerMessage;
    }

    public void setTriggerMessage(String message) {
        this.triggerMessage = message;
    }

    private String transformSingleEquals(String trigger) {
        return trigger == null ? "false" : trigger.replaceAll("(?<![!<>=])=(?!=|>)", "==");
    }

    @PropertyName(value="Delay")
    @PropertyDescription(value="Delay is optional field defining time delay after <br>which event action (assignments) will be executed if event has occurred.")
    public String getDelay() {
        return this.delay;
    }

    public void setDelay(String delay) {
        if (delay == null || delay.isEmpty()) {
            delay = "0";
        }
        String oldValue = this.delay;
        this.delay = delay;
        this.firePropertyChange("delay", oldValue, delay);
    }

    @PropertyName(value="Delay time units")
    @PropertyDescription(value="Delay time units is optional field that defines <br>the units of time that apply to the delay field.")
    public String getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(String units) {
        String oldValue = this.timeUnits;
        this.timeUnits = units;
        this.firePropertyChange("timeUnits", oldValue, this.timeUnits);
    }

    @PropertyName(value="Use trigger time values")
    @PropertyDescription(value="Defines what values should be used during event assignments execution: <br>If true then trigger time values <br>If false then assignment execution time values.")
    public boolean isUseValuesFromTriggerTime() {
        return this.useValuesFromTriggerTime;
    }

    public void setUseValuesFromTriggerTime(boolean useValuesFromTriggerTime) {
        boolean oldValue = this.useValuesFromTriggerTime;
        this.useValuesFromTriggerTime = useValuesFromTriggerTime;
        this.firePropertyChange("useValuesFromTriggerTime", oldValue, useValuesFromTriggerTime);
    }

    @PropertyName(value="Priority")
    @PropertyDescription(value="Optional field, defines events execution order.")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        String oldValue = this.priority;
        this.priority = priority;
        this.firePropertyChange("priority", oldValue, priority);
    }

    @PropertyName(value="Trigger initial value")
    @PropertyDescription(value="Defines event condition before model initial time, if false then event may occur at the initial time point.")
    public boolean isTriggerInitialValue() {
        return this.triggerInitialValue;
    }

    public void setTriggerInitialValue(boolean triggerInitialValue) {
        boolean oldValue = this.triggerInitialValue;
        this.triggerInitialValue = triggerInitialValue;
        this.firePropertyChange("triggerInitialValue", oldValue, triggerInitialValue);
    }

    @PropertyName(value="Persistent trigger")
    @PropertyDescription(value="If true then event trigger should not be rechecked after it triggers and before assignments are executed.")
    public boolean isTriggerPersistent() {
        return this.triggerPersistent;
    }

    public void setTriggerPersistent(boolean triggerPersistent) {
        boolean oldValue = this.triggerPersistent;
        this.triggerPersistent = triggerPersistent;
        this.firePropertyChange("triggerPersistent", oldValue, triggerPersistent);
    }

    @PropertyName(value="Assignments")
    @PropertyDescription(value="Event action is specified as a set of assignemnts for model variables or parameters.")
    public Assignment[] getEventAssignment() {
        return this.eventAssignment;
    }

    public Assignment getEventAssignment(int i) {
        return this.eventAssignment[i];
    }

    public void setEventAssignment(Assignment[] eventAssignment) {
        Assignment[] oldValue = this.eventAssignment;
        if (oldValue != null) {
            for (Assignment element : oldValue) {
                element.setParent(null);
            }
        }
        this.eventAssignment = eventAssignment;
        if (eventAssignment == null) {
            eventAssignment = new Assignment[]{};
        } else {
            for (Assignment element : eventAssignment) {
                element.setParent(this);
            }
        }
        this.firePropertyChange("eventAssignment", oldValue, eventAssignment);
    }

    public void setEventAssignment(int i, Assignment eventAssignment) {
        Assignment oldValue = this.eventAssignment[i];
        oldValue.setParent(null);
        this.eventAssignment[i] = eventAssignment;
        eventAssignment.setParent(this);
        this.firePropertyChange("eventAssignment", oldValue, eventAssignment);
    }

    public void addEventAssignment(Assignment ea, boolean fireEvent) {
        Assignment[] oldValue = this.eventAssignment;
        this.eventAssignment = new Assignment[oldValue.length + 1];
        if (oldValue.length > 0) {
            System.arraycopy(oldValue, 0, this.eventAssignment, 0, oldValue.length);
        }
        this.eventAssignment[oldValue.length] = ea;
        ea.setParent(this);
        if (fireEvent) {
            this.firePropertyChange("eventAssignment", oldValue, this.eventAssignment);
        }
    }

    public void clearAssignments(boolean fireEvent) {
        Assignment[] oldValue = this.eventAssignment;
        this.eventAssignment = new Assignment[0];
        if (fireEvent) {
            this.firePropertyChange("eventAssignment", oldValue, this.eventAssignment);
        }
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("Event " + endl);
        buf.append("  trigger: " + this.trigger + endl);
        buf.append("  delay  : " + this.delay + endl);
        buf.append("  assignments: " + endl);
        for (Assignment element : this.eventAssignment) {
            buf.append("    " + element.variable + " = " + element.math);
        }
        return buf.toString();
    }

    @Override
    public Role clone(DiagramElement de) {
        Event event = new Event(de, this.trigger, this.delay, null);
        event.comment = this.comment;
        event.triggerInitialValue = this.triggerInitialValue;
        event.triggerPersistent = this.triggerPersistent;
        event.useValuesFromTriggerTime = this.useValuesFromTriggerTime;
        event.timeUnits = this.timeUnits;
        event.priority = this.priority;
        event.eventAssignment = Assignment.clone(this.eventAssignment, event);
        event.triggerMessage = this.triggerMessage;
        return event;
    }

    @Override
    public boolean isExpression(String propertyName) {
        return "trigger".equals(propertyName) || "delay".equals(propertyName) || "eventAssignment".equals(propertyName);
    }

    @Override
    public String[] getExpressions() {
        return (String[])StreamEx.of((Object[])this.eventAssignment).map(assignment -> assignment.variable + '=' + assignment.math).prepend((Object[])new String[]{this.trigger, this.delay, this.priority}).toArray(String[]::new);
    }

    @Override
    public void setExpressions(String[] exps) {
        int len = this.eventAssignment.length;
        this.setTrigger(exps[0]);
        this.setDelay(exps[1]);
        this.setPriority(exps[2]);
        for (int i = 0; i < len; ++i) {
            String exp = exps[3 + i];
            int index = exp.indexOf("=");
            String leftHandSide = exp.substring(0, index);
            String rightHandSide = exp.substring(index + 1, exp.length());
            this.eventAssignment[i].setVariable(leftHandSide.trim());
            this.eventAssignment[i].setMath(rightHandSide.trim());
        }
    }

    @Override
    public Role getRole() {
        return this;
    }
}

