/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.EModelRoleSupport;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.FormulaDelegate;
import biouml.model.dynamics.Variable;
import com.developmentontheedge.beans.PropertyChangeObservable;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.beans.PropertyChangeListener;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.util.WeakPropertyChangeForwarder;

@PropertyName(value="Equation")
@PropertyDescription(value="Mathematical equation.")
public class Equation
extends EModelRoleSupport
implements ExpressionOwner {
    public static final String TYPE_ALGEBRAIC = "algebraic";
    public static final String TYPE_RATE = "rate";
    public static final String TYPE_SCALAR = "scalar";
    public static final String TYPE_INITIAL_ASSIGNMENT = "initial assignment";
    public static final String TYPE_INITIAL_VALUE = "initial value assignment";
    public static final String TYPE_CONST = "const";
    public static final String TYPE_SCALAR_CONDITIONAL = "conditional_scalar";
    public static final String TYPE_SCALAR_INTERNAL = "scalar_internal";
    public static final String TYPE_SCALAR_DELAYED = "scalar_delayed";
    public static final String TYPE_RATE_BY_RULE = "rate_by_rule";
    private Variable var = null;
    protected boolean linkedToKernel = true;
    protected String type = "rate";
    protected String variable;
    private String formula = "0";
    protected String units;
    private AstStart math;
    protected boolean fast = false;
    private PropertyChangeListener listener;

    public Equation(DiagramElement de) {
        this(de, TYPE_SCALAR, "unknown", "0");
    }

    public Equation(DiagramElement de, String type, String variable) {
        this(de, type, variable, "0");
    }

    public Equation(DiagramElement de, String type, String variable, String formula) {
        super(de);
        this.type = type;
        this.variable = variable;
        this.formula = formula;
        this.initListener(de);
    }

    public String toString() {
        if (this.isAlgebraic()) {
            return "Equation: 0  = " + this.getFormula() + ", type=" + this.type + ".\n";
        }
        if (this.isInitial()) {
            return "Equation: " + this.variable + "(0) = " + this.getFormula() + ", type=" + this.type + ".\n";
        }
        return "Equation: " + this.variable + " = " + this.getFormula() + ", type=" + this.type + ".\n";
    }

    @Override
    public Role clone(DiagramElement de) {
        Equation eq = new Equation(de, this.getType(), this.getVariable(), this.getFormula());
        eq.fast = this.fast;
        eq.units = this.units;
        eq.comment = this.comment;
        return eq;
    }

    @Override
    public boolean isExpression(String propertyName) {
        return "formula".equals(propertyName) || !this.isAlgebraic() && "variable".equals(propertyName);
    }

    @Override
    public String[] getExpressions() {
        String[] stringArray;
        if (this.isAlgebraic()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getFormula();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.variable;
            stringArray = stringArray3;
            stringArray3[1] = this.getFormula();
        }
        return stringArray;
    }

    @Override
    public void setExpressions(String[] exps) {
        if (this.isAlgebraic()) {
            this.setFormula(exps[0]);
        } else {
            String oldVal = this.variable;
            this.variable = exps[0];
            this.firePropertyChange("variable", oldVal, this.variable);
            this.setFormula(exps[1]);
        }
    }

    @Override
    public Role getRole() {
        return this;
    }

    public void unlinkKernel() {
        String formula = this.getFormula();
        this.linkedToKernel = false;
        this.setFormula(formula);
    }

    public boolean isFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        boolean oldValue = this.fast;
        this.fast = fast;
        this.firePropertyChange("fast", oldValue, fast);
    }

    @PropertyName(value="Type")
    @PropertyDescription(value="Equation type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        String oldValue = this.type;
        this.type = type;
        this.firePropertyChange("type", oldValue, type);
    }

    @PropertyName(value="Variable")
    @PropertyDescription(value="Variable to be assigned (left-hand side).")
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        if ((variable = this.validateVariableName(variable)) == null) {
            return;
        }
        String oldValue = this.variable;
        this.variable = variable;
        this.firePropertyChange("variable", oldValue, variable);
    }

    public boolean hasDelegate() {
        return this.linkedToKernel && this.getDiagramElement() != null && this.getDiagramElement().getKernel() instanceof FormulaDelegate;
    }

    @PropertyName(value="Equation")
    @PropertyDescription(value="Equation formula.")
    public String getFormula() {
        if (this.hasDelegate()) {
            return ((FormulaDelegate)((Object)this.getDiagramElement().getKernel())).getFormula();
        }
        return this.formula;
    }

    public void setFormula(String formula) {
        String oldValue = this.getFormula();
        if (oldValue != null && oldValue.equals(formula)) {
            return;
        }
        if (this.hasDelegate()) {
            ((FormulaDelegate)((Object)this.getDiagramElement().getKernel())).setFormula(formula);
        }
        this.formula = formula;
        this.math = null;
        this.firePropertyChange("formula", oldValue, formula);
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        String oldValue = this.units;
        this.units = units;
        this.firePropertyChange("units", oldValue, units);
    }

    private String validateVariableName(String var) {
        return Assignment.validateVariableName(var, this.getDiagramElement());
    }

    public AstStart getMath() {
        if (this.math == null) {
            this.math = this.initMath();
        }
        return this.math;
    }

    protected AstStart initMath() {
        Role role = Diagram.getDiagram(this.getDiagramElement()).getRole();
        if (role instanceof EModel) {
            return ((EModel)role).readMath(this.getFormula(), (Role)this, 0);
        }
        return null;
    }

    public boolean isODE() {
        return TYPE_RATE.equals(this.type);
    }

    public boolean isAlgebraic() {
        return TYPE_ALGEBRAIC.equals(this.type);
    }

    public boolean isAssignment() {
        return TYPE_SCALAR.equals(this.type);
    }

    public final boolean isInitial() {
        return TYPE_INITIAL_ASSIGNMENT.equals(this.type);
    }

    private void initListener(DiagramElement de) {
        if (de != null && de.getKernel() instanceof FormulaDelegate) {
            FormulaDelegate delegate = (FormulaDelegate)((Object)de.getKernel());
            this.listener = pce -> {
                if (pce.getPropertyName().equals("fast")) {
                    boolean isFast = (Boolean)pce.getNewValue();
                    this.setFast(isFast);
                    if (this.getParent() instanceof Node) {
                        Node node = (Node)this.getParent();
                        node.edges().map(DiagramElement::getRole).select(Equation.class).forEach(eq -> eq.setFast(isFast));
                    }
                } else if (pce.getPropertyName().equals("formula")) {
                    this.math = null;
                }
            };
            new WeakPropertyChangeForwarder(this.listener, (PropertyChangeObservable)delegate);
        }
    }

    public static final boolean isScalar(String type) {
        return TYPE_SCALAR.equals(type) || TYPE_SCALAR_CONDITIONAL.equals(type) || TYPE_SCALAR_INTERNAL.equals(type) || TYPE_SCALAR_DELAYED.equals(type) || TYPE_INITIAL_ASSIGNMENT.equals(type);
    }

    public static final boolean isInternal(String type) {
        return TYPE_SCALAR_INTERNAL.equals(type);
    }

    public static final boolean isRate(String type) {
        return TYPE_RATE.equals(type) || TYPE_RATE_BY_RULE.equals(type);
    }
}

