/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.DAEModelUtilities;
import biouml.model.dynamics.EModelRoleSupport;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.State;
import biouml.model.dynamics.Transition;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.dynamics.VariablesDataCollection;
import biouml.model.dynamics.resources.MessageBundle;
import biouml.standard.diagram.Bus;
import biouml.standard.diagram.CompositeDiagramType;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.Util;
import biouml.standard.type.Unit;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.DataCollectionListenerSupport;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataCollectionVetoException;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.filter.Filter;
import ru.biosoft.access.core.filter.FilteredDataCollection;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.DefaultParserContext;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.PredefinedFunction;
import ru.biosoft.math.model.Utils;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.math.parser.Parser;
import ru.biosoft.util.DataCollectionDynamicPropertySet;
import ru.biosoft.util.HtmlUtil;
import ru.biosoft.util.LazyValue;

@PropertyName(value="Executable model")
@PropertyDescription(value="Executable model (system of ordinary differential equations)")
public class EModel
extends EModelRoleSupport
implements DataCollectionListener,
PropertyChangeListener,
ParserContext {
    private static final Logger log = Logger.getLogger(EModel.class.getName());
    public static final int VARIABLE_NAME_BY_ID = 0;
    public static final int VARIABLE_NAME_BY_TITLE = 1;
    public static final int VARIABLE_NAME_BY_TITLE_BRIEF = 2;
    public static final int VARIABLE_NAME_BY_ID_BRIEF = 3;
    public static final int STATIC_TYPE = 0;
    public static final int STATIC_EQUATIONS_TYPE = 1;
    public static final int ODE_TYPE = 2;
    public static final int ODE_DELAY_TYPE = 4;
    public static final int ALGEBRAIC_TYPE = 8;
    public static final int EVENT_TYPE = 16;
    public static final int STATE_TRANSITION_TYPE = 32;
    public static final String CONVERSION_FACTOR_UNDEFINED = "";
    protected DataCollection<Variable> variables;
    DiagramVariableResolver resolver;
    private Variable conversionFactor = null;
    protected DataCollectionDynamicPropertySet varsSet;
    protected HashMap<String, Object> constantsMap = new HashMap();
    protected HashMap<String, ru.biosoft.math.model.Function> functionsMap = new HashMap();
    private Map<String, Unit> units;
    protected Role parsedRole;
    protected Parser parser;
    private State initialState;
    protected DataElement elementToRemove = null;
    private boolean autodetectTypes = true;
    protected final LazyValue<DataCollection<VariableRole>> variableRoles = new LazyValue<DataCollection<VariableRole>>("variableRoles"){

        protected DataCollection<VariableRole> doGet() throws Exception {
            Properties props = new Properties();
            props.put("primaryCollection", EModel.this.variables);
            props.put("name", EModel.this.variables.getName() + ": roles");
            props.put("filter", new VariableFilter(true));
            return new FilteredDataCollection(null, props);
        }
    };
    protected final LazyValue<DataCollection<VariableRole>> entityRoles = new LazyValue<DataCollection<VariableRole>>("entityRoles"){

        protected DataCollection<VariableRole> doGet() throws Exception {
            Properties props = new Properties();
            props.put("primaryCollection", EModel.this.variables);
            props.put("name", EModel.this.variables.getName() + ": roles");
            props.put("filter", new CompartmentFilter(false));
            return new FilteredDataCollection(null, props);
        }
    };
    protected final LazyValue<DataCollection<VariableRole>> compartmentRoles = new LazyValue<DataCollection<VariableRole>>("compartmentRoles"){

        protected DataCollection<VariableRole> doGet() throws Exception {
            Properties props = new Properties();
            props.put("primaryCollection", EModel.this.variables);
            props.put("name", EModel.this.variables.getName() + ": roles");
            props.put("filter", new CompartmentFilter(true));
            return new FilteredDataCollection(null, props);
        }
    };
    protected final LazyValue<DataCollection<Variable>> parameters = new LazyValue<DataCollection<Variable>>("parameters"){

        protected DataCollection<Variable> doGet() throws Exception {
            Properties props = new Properties();
            props.put("primaryCollection", EModel.this.variables);
            props.put("name", EModel.this.variables.getName() + ": parameters");
            props.put("filter", new VariableFilter(false));
            return new FilteredDataCollection(null, props);
        }
    };
    protected List<Equation> orderedScalarEquations;
    protected List<Equation> orderedInitialAssignments;
    public static final String ODE_EMODEL_TYPE_STRING = "ODE EModel";
    private static final int MAX_CHAR = 128;
    private static final boolean[] firstVariableChar = new boolean[128];
    private static final boolean[] followingVariableChars = new boolean[128];

    public EModel(DiagramElement diagramElement) {
        super(diagramElement);
        DefaultParserContext.declareStandardConstants((ParserContext)this);
        DefaultParserContext.declareStandardOperators((ParserContext)this);
        Diagram diagram = (Diagram)diagramElement;
        diagram.addPropertyChangeListener(this);
        diagram.addDataCollectionListener(this);
        try {
            this.variables = new VariablesDataCollection(null, diagram);
            this.varsSet = new DataCollectionDynamicPropertySet(this.variables);
            this.varsSet.setParent((Option)this);
            this.units = new HashMap<String, Unit>();
            this.variables.addDataCollectionListener((DataCollectionListener)new DataCollectionListenerSupport(){

                public void elementAdded(DataCollectionEvent e) throws Exception {
                    if (EModel.this.resolver != null && e.getDataElement() instanceof Variable) {
                        EModel.this.resolver.addVariable((Variable)e.getDataElement());
                    }
                }

                public void elementChanged(DataCollectionEvent e) throws Exception {
                    EModel.this.resolver = null;
                }

                public void elementRemoved(DataCollectionEvent e) throws Exception {
                    EModel.this.resolver = null;
                }
            });
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error during variables parsing: " + t.getMessage(), t);
        }
        this.declareFunction((ru.biosoft.math.model.Function)new PredefinedFunction("noise", 7, 1));
        this.declareFunction((ru.biosoft.math.model.Function)new PredefinedFunction("delay", 7, 2));
        this.declareFunction((ru.biosoft.math.model.Function)new PredefinedFunction("rateOf", 7, 1));
        this.declareFunction((ru.biosoft.math.model.Function)new PredefinedFunction("random", 7, 0));
        this.declareFunction((ru.biosoft.math.model.Function)new PredefinedFunction("binomial", 7, 2));
        this.declareFunction((ru.biosoft.math.model.Function)new PredefinedFunction("uniform", 7, 2));
        this.declareFunction((ru.biosoft.math.model.Function)new PredefinedFunction("normal", 7, 2));
        this.declareFunction((ru.biosoft.math.model.Function)new PredefinedFunction("logNormal", 7, 2));
        this.declareVariable("time", 0.0);
        this.resolver = new DiagramVariableResolver(0);
    }

    public String toString() {
        return "Executable model";
    }

    @Override
    public Role clone(DiagramElement de) {
        EModel emodel = new EModel(de);
        this.doClone(emodel);
        return emodel;
    }

    protected void doClone(EModel emodel) {
        emodel.comment = this.comment;
        emodel.conversionFactor = this.conversionFactor;
        Diagram diagram = emodel.getDiagramElement();
        this.adjustBuses(diagram);
        DataCollection<Variable> destVariables = emodel.getVariables();
        for (Variable var : this.getVariables()) {
            try {
                if (var instanceof VariableRole && diagram != null) {
                    VariableRole oldVar = (VariableRole)var;
                    DiagramElement mainDe = oldVar.getDiagramElement();
                    Node newMainDe = diagram.findNode(mainDe.getCompleteNameInDiagram());
                    VariableRole mainVariable = newMainDe.getRole(VariableRole.class);
                    ((StreamEx)StreamEx.of((Object[])oldVar.getAssociatedElements()).map(de -> diagram.findNode(de.getCompleteNameInDiagram())).nonNull()).forEach(de -> {
                        de.setRole(mainVariable);
                        mainVariable.addAssociatedElement((DiagramElement)((Object)de));
                    });
                    newMainDe.setRole(mainVariable);
                    emodel.put(mainVariable);
                    continue;
                }
                Variable cloned = (Variable)((Object)var.clone());
                cloned.setParent(emodel);
                destVariables.put((DataElement)cloned);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not clone variable " + var.getName() + ", model=" + this.getDiagramElement().getName() + ", error: " + e, e);
            }
        }
        for (Unit unit : this.units.values()) {
            emodel.addUnit(unit.clone(unit.getOrigin(), unit.getName()));
        }
        EntryStream.of(this.functionsMap).forEach(entry -> emodel.functionsMap.putIfAbsent((String)entry.getKey(), (ru.biosoft.math.model.Function)entry.getValue()));
    }

    private void adjustBuses(Diagram diagram) {
        Map.Entry cluster;
        Node selected;
        Node selectedCopy;
        Map clusters = ((StreamEx)DiagramUtility.getBuses(this.getDiagramElement()).filter(n -> n.getRole() instanceof Bus)).groupingBy(n -> (Bus)n.getRole());
        Iterator iterator = clusters.entrySet().iterator();
        while (iterator.hasNext() && (selectedCopy = diagram.findNode((selected = (Node)((Object)((List)(cluster = iterator.next()).getValue()).get(0))).getCompleteNameInDiagram())) != null) {
            Bus newBus = (Bus)((Bus)cluster.getKey()).clone(selectedCopy);
            for (Node node : (List)cluster.getValue()) {
                Node copy = diagram.findNode(node.getCompleteNameInDiagram());
                copy.setRole(newBus);
                newBus.addNode(copy);
            }
        }
    }

    public boolean containsConstant(String name) {
        return this.constantsMap.containsKey(name);
    }

    public Object getConstantValue(String name) {
        return this.constantsMap.get(name);
    }

    public void declareConstant(String name, Object value) {
        this.constantsMap.put(name, value);
    }

    public void removeConstant(String name) {
        this.constantsMap.remove(name);
    }

    public ru.biosoft.math.model.Function getFunction(String name) {
        if (name.startsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        return this.functionsMap.get(name);
    }

    public void removeFunction(String name) {
        this.functionsMap.remove(name);
    }

    public void declareFunction(ru.biosoft.math.model.Function function) {
        this.functionsMap.put(function.getName(), function);
    }

    public DataCollection<Variable> getVariables() {
        return this.variables;
    }

    public DynamicPropertySet getVars() {
        return this.varsSet;
    }

    public boolean containsVariable(String name) {
        return this.getVariable(name) != null;
    }

    public Object getVariableValue(String name) {
        try {
            Variable variable = this.getVariable(name);
            if (variable != null) {
                return variable.getInitialValue();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return null;
    }

    public void declareVariable(String name, Object value) {
        try {
            if (name.startsWith("$")) {
                return;
            }
            Variable variable = new Variable(name, this, this.variables);
            if ("time".equals(name)) {
                variable.setType("Time");
            }
            variable.setInitialValue((Double)value);
            this.variables.put((DataElement)variable);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public boolean canDeclare(String name) {
        return !name.startsWith("$");
    }

    public void put(Variable variable) {
        try {
            this.variables.put((DataElement)variable);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public Variable getVariable(String name) {
        try {
            Variable result = (Variable)this.variables.get(name);
            if (result == null) {
                result = (Variable)this.variables.get("$" + name);
            }
            if (result == null) {
                result = (Variable)this.variables.get("$\"" + name + "\"");
            }
            if (result == null && name.length() > 2) {
                result = (Variable)this.variables.get("$" + name.substring(2, name.length() - 1));
            }
            if (result == null) {
                result = (Variable)this.variables.get("$\"" + name.substring(1) + "\"");
            }
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public DataCollection<VariableRole> getVariableRoles() {
        return (DataCollection)this.variableRoles.get();
    }

    public DataCollection<VariableRole> getCompartmentRoles() {
        return (DataCollection)this.compartmentRoles.get();
    }

    public DataCollection<VariableRole> getEntityRoles() {
        return (DataCollection)this.entityRoles.get();
    }

    public DataCollection<Variable> getParameters() {
        return (DataCollection)this.parameters.get();
    }

    public void addUnit(Unit unit) {
        HashMap<String, Unit> oldValue = new HashMap<String, Unit>(this.units);
        this.units.put(unit.getName(), unit);
        unit.setParent(this);
        this.firePropertyChange("units", oldValue, this.units);
    }

    public void removeUnit(String name) {
        HashMap<String, Unit> oldValue = new HashMap<String, Unit>(this.units);
        this.units.remove(name);
        this.firePropertyChange("units", oldValue, this.units);
        for (Variable var : this.variables) {
            if (!name.equals(var.getUnits())) continue;
            var.setUnits(CONVERSION_FACTOR_UNDEFINED);
        }
    }

    public Map<String, Unit> getUnits() {
        return this.units;
    }

    @Nonnull
    public StreamEx<Equation> getEquations(Filter<DiagramElement> filter) {
        return this.getChildrenRoles(this.getDiagramElement(), Equation.class, filter);
    }

    @Nonnull
    public StreamEx<Equation> getEquations() {
        return this.getChildrenRoles(this.getDiagramElement(), Equation.class);
    }

    @Nonnull
    public StreamEx<Equation> getODE() {
        return this.getEquations(new ODEFilter());
    }

    @Nonnull
    public StreamEx<Equation> getInitialAssignments() {
        return this.getEquations(new InitialAssignmentsFilter());
    }

    @Nonnull
    public StreamEx<Equation> getAlgebraic() {
        return this.getEquations(new AlgebraicFilter());
    }

    @Nonnull
    public StreamEx<Equation> getAssignments() {
        return this.getEquations(new AssignmentsFilter());
    }

    @Nonnull
    public List<Equation> getOrderedInitialEquations() throws Exception {
        if (this.orderedInitialAssignments == null) {
            ArrayList<Equation> cycled = new ArrayList<Equation>();
            this.orderInitialAssignments(cycled);
            if (!cycled.isEmpty()) {
                log.info("There is cyclic dependency between initial assignments for variables:");
                log.info(StreamEx.of(cycled).map(e -> e.getVariable()).joining((CharSequence)", "));
                log.info("Initial values may be calculated incorrectly!");
            }
        }
        return this.orderedInitialAssignments;
    }

    public void orderInitialAssignments(List<Equation> cycledEquations) throws Exception {
        this.orderedInitialAssignments = new ArrayList<Equation>();
        DAEModelUtilities.reorderAssignmentRules(this.getEquations(new InitialEquationsFilter(this)).toSet(), this.orderedInitialAssignments, cycledEquations);
    }

    public void orderScalarEquations(List<Equation> cycledEquations) throws Exception {
        this.orderedScalarEquations = new ArrayList<Equation>();
        DAEModelUtilities.reorderAssignmentRules(this.getEquations(new ExtendedAssignmentsFilter(this)).toSet(), this.orderedScalarEquations, cycledEquations);
    }

    public List<Equation> getOrderedScalarEquations() throws Exception {
        if (this.orderedScalarEquations == null) {
            this.orderScalarEquations(null);
        }
        return this.orderedScalarEquations;
    }

    public Event[] getEvents() {
        return (Event[])this.getChildrenRoles(this.getDiagramElement(), Event.class).toArray(Event[]::new);
    }

    public Constraint[] getConstraints() {
        return (Constraint[])this.getChildrenRoles(this.getDiagramElement(), Constraint.class).toArray(Constraint[]::new);
    }

    public State[] getStates() {
        return (State[])this.getChildrenRoles(this.getDiagramElement(), State.class).toArray(State[]::new);
    }

    public Transition[] getTransitions() {
        return (Transition[])this.getChildrenRoles(this.getDiagramElement(), Transition.class).toArray(Transition[]::new);
    }

    public Function[] getFunctions() {
        return (Function[])this.getChildrenRoles(this.getDiagramElement(), Function.class).toArray(Function[]::new);
    }

    public <T extends Role> StreamEx<T> getChildrenRoles(Compartment compartment, Class<T> role) {
        return compartment.recursiveStream().map(DiagramElement::getRole).select(role);
    }

    public <T extends Role> StreamEx<T> getChildrenRoles(Compartment compartment, Class<T> role, Filter<DiagramElement> filter) {
        return ((StreamEx)((StreamEx)compartment.recursiveStream().filter(de -> role.isInstance(de.getRole()))).filter(arg_0 -> filter.isAcceptable(arg_0))).map(DiagramElement::getRole).select(role);
    }

    public static boolean isSubdiagram(DiagramElement de) {
        return de.getRole() != null && de.getRole() instanceof EModel;
    }

    public String getType() {
        return ODE_EMODEL_TYPE_STRING;
    }

    public int getModelType() {
        Diagram parentDiag;
        int compoundType = 0;
        for (Equation eq2 : (StreamEx)this.getEquations().filter(eq -> !"initial assignment".equals(eq.getType()))) {
            Variable variable;
            if (eq2.getType().equals("rate") && !eq2.isFast()) {
                variable = this.getVariable(eq2.getVariable());
                if (variable == null || variable.isConstant() || variable instanceof VariableRole && ((VariableRole)variable).isBoundaryCondition()) continue;
                compoundType |= 2;
                continue;
            }
            if (!eq2.isAlgebraic() && !eq2.isFast()) {
                String varName;
                variable = this.getVariable(eq2.getVariable());
                if (variable == null || (varName = variable.getName()).length() > 2 && varName.charAt(0) == '$' && varName.charAt(1) == '$') continue;
                compoundType |= 1;
                continue;
            }
            compoundType |= 8;
        }
        Event[] events = this.getEvents();
        if (events != null && events.length > 0) {
            compoundType |= 0x10;
        }
        if (this.hasDelayedVariables(this.getDiagramElement())) {
            compoundType |= 4;
        }
        State[] states = this.getStates();
        Transition[] transitions = this.getTransitions();
        if (states != null && states.length > 0 && transitions != null && transitions.length > 0) {
            compoundType |= 0x20;
        }
        if ((parentDiag = this.getParent()).getType() instanceof CompositeDiagramType) {
            Iterator<DiagramElement> iterator = parentDiag.iterator();
            while (iterator.hasNext()) {
                DiagramElement de = iterator.next();
                if (!(de instanceof SubDiagram)) continue;
                compoundType |= ((SubDiagram)de).getDiagram().getRole(EModel.class).getModelType();
            }
        }
        return compoundType;
    }

    public String getModelTypeName() {
        int modelType = this.getModelType();
        if (modelType == 0) {
            return "Static model";
        }
        String str = CONVERSION_FACTOR_UNDEFINED;
        if (EModel.isOfType(modelType, 2)) {
            str = EModel.isOfType(modelType, 1) ? "ODE model with static equations" : "ODE model";
        } else if (EModel.isOfType(modelType, 1)) {
            str = "Model with static equations";
        }
        if ((modelType & 4) != 0) {
            str = str + " with delays";
        }
        if ((modelType & 8) != 0) {
            str = str + ", with algebraic rules";
        }
        if ((modelType & 0x10) != 0) {
            str = str + ", with events";
        }
        if ((modelType & 0x20) != 0) {
            str = str + ", with states and transitions";
        }
        return str;
    }

    public static boolean isOfType(int type, int suggestedType) {
        return (type & suggestedType) != 0;
    }

    public boolean hasDelayedVariables(DiagramElement de) {
        if (de instanceof Node || de instanceof Edge) {
            Role role = de.getRole();
            if (role instanceof ExpressionOwner) {
                for (String expression : ((ExpressionOwner)((Object)role)).getExpressions()) {
                    if (expression == null || expression.indexOf("delay") == -1) continue;
                    return true;
                }
            }
            if (de instanceof Compartment) {
                Iterator<DiagramElement> iterator = ((Compartment)de).iterator();
                while (iterator.hasNext()) {
                    DiagramElement next = (DiagramElement)((Object)iterator.next());
                    if (next instanceof Diagram || !this.hasDelayedVariables(next)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<DelayedExpression> getDelayedExpressionsList() {
        ArrayList<DelayedExpression> varList = new ArrayList<DelayedExpression>();
        this.fillDelayedVariablesList(this.getDiagramElement(), varList);
        return varList;
    }

    public void fillDelayedVariablesList(DiagramElement de, List<DelayedExpression> list) {
        if (de instanceof Node || de instanceof Edge) {
            Role role = de.getRole();
            if (role instanceof ExpressionOwner) {
                for (String expression : ((ExpressionOwner)((Object)role)).getExpressions()) {
                    if (expression == null || expression.indexOf("delay") == -1) continue;
                    this.fillAllDelayedVariablesForTree((ru.biosoft.math.model.Node)this.readMath(expression, role), list, role);
                }
            }
            if (de instanceof Compartment) {
                Iterator<DiagramElement> iterator = ((Compartment)de).iterator();
                while (iterator.hasNext()) {
                    DiagramElement innerDe = (DiagramElement)((Object)iterator.next());
                    this.fillDelayedVariablesList(innerDe, list);
                }
            }
        }
    }

    private void fillAllDelayedVariablesForTree(ru.biosoft.math.model.Node node, List<DelayedExpression> list, Role role) {
        AstFunNode funcNode;
        if (node instanceof AstFunNode && "delay".equals((funcNode = (AstFunNode)node).getFunction().getName())) {
            list.add(new DelayedExpression((AstVarNode)funcNode.jjtGetChild(0), role));
        }
        Utils.children((ru.biosoft.math.model.Node)node).forEach(child -> this.fillAllDelayedVariablesForTree((ru.biosoft.math.model.Node)child, list, role));
    }

    public DiagramVariableResolver getVariableResolver(int varNameMode) {
        if (this.resolver == null || this.resolver.varNameMode != varNameMode) {
            this.resolver = new DiagramVariableResolver(varNameMode);
        }
        return this.resolver;
    }

    public String getQualifiedName(String name, DiagramElement de) throws IllegalArgumentException {
        return this.getQualifiedName(name, de, 0);
    }

    public String getQualifiedName(String name, DiagramElement de, int varNameMode) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && name.charAt(1) == '$') {
            return name;
        }
        String varName = name;
        Variable variable = this.getVariable(varName);
        if (de != null) {
            if (variable == null) {
                StreamEx<Edge> edges = de instanceof Edge ? StreamEx.of((Object)((Object)((Edge)de))) : ((Node)de).edges();
                variable = ((StreamEx)edges.map(edge -> this.getEdgeQualifiedVariable(varName, (Edge)((Object)edge))).nonNull()).findFirst().orElse(null);
            }
            if (variable == null && de.getOrigin() instanceof Compartment) {
                variable = ((StreamEx)((StreamEx)de.getCompartment().stream().map(DiagramElement::getRole).filter(role -> role instanceof VariableRole)).filter(role -> this.isVariableName(varName, (VariableRole)role))).findFirst().orElse(null);
            }
        }
        if (variable == null) {
            List varList = this.getVariables().stream().filter(var -> this.isVariableName(varName, (Variable)((Object)var))).collect(Collectors.toList());
            if (varList.size() == 1) {
                variable = (Variable)((Object)varList.get(0));
            } else if (varList.size() > 1) {
                throw new IllegalArgumentException("Ambiguous variable name, name=$" + varName + ", suitable variables: " + StreamEx.of(varList).map(Variable::getName).joining((CharSequence)", "));
            }
        }
        if (variable != null) {
            if (varNameMode == 0) {
                return variable.getName();
            }
            if (variable instanceof VariableRole) {
                DiagramElement varDe = ((VariableRole)variable).getDiagramElement();
                return varNameMode == 3 ? VariableRole.createName(varDe, true) : EModel.getTitle(varDe, varNameMode == 1);
            }
            return variable.getTitle();
        }
        return null;
    }

    private static String getTitle(DiagramElement de, boolean complete) {
        String title = HtmlUtil.stripHtml((String)de.getTitle());
        if (complete) {
            DataCollection origin = de.getOrigin();
            while (origin instanceof DiagramElement && !(origin instanceof Diagram)) {
                title = ((DiagramElement)origin).getTitle() + "." + title;
                origin = origin.getOrigin();
            }
        }
        if (!EModel.checkVariableName(title)) {
            title = "\"" + title + "\"";
        }
        return "$" + title;
    }

    protected Variable getEdgeQualifiedVariable(String name, Edge edge) {
        String str = name.startsWith("$") ? name.substring(1) : name;
        return edge.nodes().map(DiagramElement::getRole).select(VariableRole.class).findFirst(role -> this.isVariableName(str, (Variable)((Object)role))).orElse(null);
    }

    private boolean isVariableName(String name, Variable variable) {
        String str;
        String string = str = variable.getName().startsWith("$") ? variable.getName().substring(1) : variable.getName();
        if (str.length() > 1 && str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str.endsWith("." + name) || str.equals(name) || str.endsWith("." + name.substring(1));
    }

    public static boolean checkVariableName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (chars[0] > '\u0080' || !firstVariableChar[chars[0]]) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] <= '\u0080' && followingVariableChars[chars[i]]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getSource() instanceof ExpressionOwner) {
            ExpressionOwner owner = (ExpressionOwner)pce.getSource();
            if (owner.isExpression(pce.getPropertyName()) || pce.getPropertyName().equals("type")) {
                this.readMath(owner.getExpressions(), owner.getRole());
                if (this.isAutodetectTypes()) {
                    this.detectVariableTypes();
                }
            }
        } else if (pce.getPropertyName().equals("role")) {
            if (pce.getNewValue() instanceof Role && pce.getNewValue() instanceof ExpressionOwner) {
                this.readMath(((ExpressionOwner)((Object)((Role)pce.getNewValue()))).getExpressions(), (Role)pce.getNewValue());
            }
            if ((pce.getOldValue() instanceof ExpressionOwner || pce.getNewValue() instanceof ExpressionOwner) && this.isAutodetectTypes()) {
                this.detectVariableTypes();
            }
        } else if (pce.getPropertyName().equals("formula") && pce.getNewValue() instanceof String) {
            this.readMath((String)pce.getNewValue(), null);
            if (this.isAutodetectTypes()) {
                this.detectVariableTypes();
            }
        }
    }

    protected void initParser() {
        if (this.parser == null) {
            this.parser = new Parser();
            this.parser.setContext((ParserContext)this);
            this.parser.setDeclareUndefinedVariables(true);
        }
    }

    public Parser getParser() {
        if (this.parser == null) {
            this.initParser();
        }
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public List<AstStart> readMath(String[] math, Role role) {
        return this.readMath(math, role, (VariableResolver)this.getVariableResolver(0));
    }

    public List<AstStart> readMath(String[] math, Role role, VariableResolver resolver) {
        ArrayList<AstStart> starts = new ArrayList<AstStart>();
        if (math != null) {
            for (String m : math) {
                if (m == null) continue;
                starts.add(this.readMath(m, role, resolver));
            }
        }
        return starts;
    }

    public AstStart readMath(String math, Role role) {
        if (role instanceof Equation && math.equals(((Equation)role).getFormula())) {
            return ((Equation)role).getMath();
        }
        return this.readMath(math, role, 0);
    }

    public AstStart readMath(String math, Role role, int varNameMode) {
        return this.readMath(math, role, (VariableResolver)this.getVariableResolver(varNameMode));
    }

    public AstStart readMath(String math, Role role, VariableResolver resolver) {
        return this.readMath(math, role, resolver, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AstStart readMath(String math, Role role, VariableResolver resolver, boolean silent) {
        AstStart start = null;
        if (math != null && math.length() > 0) {
            this.initParser();
            this.parsedRole = role;
            try {
                Parser parser = this.parser;
                synchronized (parser) {
                    this.parser.setVariableResolver(resolver);
                    int status = this.parser.parse(math);
                    if (status > 0 && !silent) {
                        MessageBundle.error(log, "ERROR_MATH_PARSING", new String[]{this.getDiagramElement() == null ? "(no element)" : this.getDiagramElement().getName(), role == null || role.getDiagramElement() == null ? "-" : role.getDiagramElement().getName(), math, Utils.formatErrors((ru.biosoft.math.model.Parser)this.parser)});
                    }
                    if (status < 4) {
                        start = this.parser.getStartNode();
                    }
                }
            }
            catch (Throwable t) {
                MessageBundle.error(log, "ERROR_MATH_PARSING", new String[]{this.getDiagramElement() == null ? "(no element)" : this.getDiagramElement().getName(), role == null || role.getDiagramElement() == null ? "-" : role.getDiagramElement().getName(), math, ExceptionRegistry.log((Throwable)t)});
            }
        }
        return start;
    }

    public void removeNotUsedParameters() {
        try {
            this.detectVariableTypes();
            for (String name : this.getParameters().stream().filter(v -> "Not used".equals(v.getType())).map(v -> v.getName()).collect(Collectors.toList())) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Remove not used parameter: " + name);
                }
                this.getVariables().remove(name);
            }
        }
        catch (Throwable t) {
            MessageBundle.error(log, "ERROR_REMOVE_NOT_USED_PARAMS", new String[]{this.getDiagramElement().getName(), t.toString()});
        }
    }

    private Set<String> detectUnusedVariables() {
        Set<String> notUsedParams = this.getVariables().stream().map(Variable::getName).filter(varname -> !varname.equals("time")).collect(Collectors.toSet());
        if (this.conversionFactor != null) {
            notUsedParams.remove(this.conversionFactor.getName());
        }
        DiagramVariableResolver resolver = this.getVariableResolver(0);
        Diagram diagram = this.getParent();
        for (DiagramElement de : diagram.recursiveStream()) {
            Role role = de.getRole();
            if (role instanceof ExpressionOwner && !(role instanceof Function)) {
                for (AstStart start : this.readMath(((ExpressionOwner)((Object)role)).getExpressions(), role, (VariableResolver)resolver)) {
                    this.completeUsedParametersList((ru.biosoft.math.model.Node)start, notUsedParams);
                }
                continue;
            }
            if (role instanceof VariableRole) {
                notUsedParams.remove(((VariableRole)role).getConversionFactor());
                continue;
            }
            if (!Util.isPort(de) || Util.isModulePort(de)) continue;
            notUsedParams.remove(Util.getPortVariable(de));
        }
        return notUsedParams;
    }

    public void detectVariableTypes() {
        Variable var2;
        if (DiagramUtility.isComposite(this.getParent())) {
            SubDiagram.diagrams(this.getParent()).without((Object)this.getParent()).map(d -> d.getRole()).select(EModel.class).forEach(e -> e.detectVariableTypes());
        }
        Set<String> constants = this.getVariables().stream().map(Variable::getName).filter(varname -> !varname.equals("time")).collect(Collectors.toSet());
        this.getParser().setDeclareUndefinedVariables(false);
        Set<String> notUsedParams = this.detectUnusedVariables();
        notUsedParams.forEach(name -> this.getVariable((String)name).setType("Not used"));
        constants.removeAll(notUsedParams);
        for (Event event : this.getEvents()) {
            for (Assignment assignment : event.getEventAssignment()) {
                String variableName = assignment.getVariable();
                Variable var3 = this.getVariable(variableName);
                if (var3.isConstant()) continue;
                var3.setType("Discrete");
                constants.remove(variableName);
            }
        }
        for (Equation eq2 : this.getInitialAssignments()) {
            String variableName = eq2.getVariable();
            var2 = this.getVariable(variableName);
            if (var2 == null || var2.isConstant()) continue;
            var2.setType("Calculated");
            constants.remove(variableName);
        }
        for (Equation eq3 : this.getEquations()) {
            String variableName = eq3.getVariable();
            var2 = this.getVariable(variableName);
            if (var2 == null || var2.isConstant()) continue;
            if (Util.isSpecieReference(eq3.getDiagramElement()) && var2 instanceof VariableRole) {
                if (((VariableRole)var2).isBoundaryCondition()) continue;
                var2.setType("Differential");
                constants.remove(variableName);
                continue;
            }
            if (eq3.getType().equals("scalar") || eq3.getType().equals("scalar_internal")) {
                var2.setType("Calculated");
                constants.remove(variableName);
                continue;
            }
            if (!Equation.isRate(eq3.getType())) continue;
            var2.setType("Differential");
            constants.remove(variableName);
        }
        ((StreamEx)this.getAlgebraic().flatMap(eq -> Utils.getVariables((ru.biosoft.math.model.Node)eq.getMath()).stream()).filter(var -> constants.contains(var))).forEach(var -> {
            Variable variable = this.getVariable((String)var);
            if (!variable.isConstant()) {
                variable.setType("Algebraic");
                constants.remove(var);
            }
        });
        constants.forEach(name -> this.getVariable((String)name).setType("Parameter"));
        this.getParser().setDeclareUndefinedVariables(true);
    }

    private void completeUsedParametersList(ru.biosoft.math.model.Node node, Set<String> modelParameters) {
        if (node == null) {
            return;
        }
        if (node instanceof AstVarNode) {
            modelParameters.remove(((AstVarNode)node).getName());
        }
        Utils.children((ru.biosoft.math.model.Node)node).forEach(child -> this.completeUsedParametersList((ru.biosoft.math.model.Node)child, modelParameters));
    }

    public void elementWillAdd(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
    }

    public void elementAdded(DataCollectionEvent e) throws Exception {
        if (!this.notificationEnabled) {
            return;
        }
        DataElement de = e.getDataElement();
        if (de instanceof DiagramElement) {
            Role role = ((DiagramElement)de).getRole();
            if (role instanceof Variable) {
                Variable newVar = (Variable)((Object)role);
                this.getVariables().put((DataElement)newVar);
                this.firePropertyChange("variables", null, null);
            } else if (role instanceof ExpressionOwner) {
                this.readMath(((ExpressionOwner)((Object)role)).getExpressions(), role);
            }
        }
    }

    public void elementWillRemove(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
        this.elementToRemove = e.getDataElement();
    }

    public void elementRemoved(DataCollectionEvent e) throws Exception {
        if (!this.notificationEnabled) {
            return;
        }
        if (this.elementToRemove instanceof Node) {
            Node node = (Node)this.elementToRemove;
            Role role = node.getRole();
            if (role instanceof VariableRole) {
                if (((VariableRole)role).removeAssociatedElement(node)) {
                    this.getVariables().remove(((Variable)((Object)role)).getName());
                }
            } else if (role instanceof Variable) {
                this.getVariables().remove(((Variable)((Object)role)).getName());
            }
        }
        this.firePropertyChange("variables", null, null);
    }

    public void elementWillChange(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
        while (e.getPrimaryEvent() != null) {
            e = e.getPrimaryEvent();
        }
        if (e.getType() == 3) {
            this.elementWillRemove(e);
        }
    }

    public void elementChanged(DataCollectionEvent e) throws Exception {
        if (!this.notificationEnabled) {
            return;
        }
        while (e.getPrimaryEvent() != null) {
            e = e.getPrimaryEvent();
        }
        if (e.getType() == 4) {
            this.elementAdded(e);
        } else if (e.getType() == 6) {
            this.elementRemoved(e);
        }
    }

    public State getInitialState() {
        return this.initialState;
    }

    public void setInitialState(State initialState) {
        this.initialState = initialState;
    }

    public void setConversionFactor(String variableName) {
        if (CONVERSION_FACTOR_UNDEFINED.equals(variableName)) {
            this.conversionFactor = null;
            return;
        }
        Variable variable = this.getVariable(variableName);
        if (variable == null) {
            throw new IllegalArgumentException("Can not found parameter " + variableName + " in model");
        }
        if (variable instanceof VariableRole) {
            throw new IllegalArgumentException("Incorrect conversion factor, it should be model parameter with set constant = true");
        }
        this.conversionFactor = variable;
    }

    @PropertyName(value="Conversion factor")
    @PropertyDescription(value="Conversion factor.")
    public String getConversionFactor() {
        if (this.conversionFactor == null) {
            return CONVERSION_FACTOR_UNDEFINED;
        }
        return this.conversionFactor.getName();
    }

    @Override
    public Diagram getDiagramElement() {
        return (Diagram)super.getDiagramElement();
    }

    @Override
    public Diagram getParent() {
        return (Diagram)super.getParent();
    }

    public String getConversionFactor(Variable var) {
        return !(var instanceof VariableRole) ? null : ((VariableRole)var).getConversionFactor();
    }

    public boolean isAutodetectTypes() {
        return this.autodetectTypes;
    }

    public void setAutodetectTypes(boolean autodetectTypes) {
        this.autodetectTypes = autodetectTypes;
    }

    static {
        for (char c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
            if (Character.isLetter(c)) {
                EModel.firstVariableChar[c] = true;
                EModel.followingVariableChars[c] = true;
                continue;
            }
            if (!Character.isDigit(c) && c != 95) continue;
            EModel.followingVariableChars[c] = true;
        }
    }

    public static class AssignmentFilter
    extends NodeFilter {
        @Override
        protected boolean isNodeAcceptable(Node de) {
            return de.getRole(Equation.class).isAssignment();
        }
    }

    public static class AlgebraicFilter
    extends NodeFilter {
        @Override
        protected boolean isNodeAcceptable(Node de) {
            return de.getRole(Equation.class).isAlgebraic();
        }
    }

    public static class ODEFilter
    extends NodeFilter {
        @Override
        protected boolean isNodeAcceptable(Node de) {
            return de.getRole(Equation.class).isODE();
        }
    }

    public static class NotInitialAssignmentsFilter
    extends NodeFilter {
        @Override
        protected boolean isNodeAcceptable(Node de) {
            return !de.getRole(Equation.class).getType().equals("initial assignment");
        }
    }

    public static class InitialAssignmentsFilter
    extends NodeFilter {
        @Override
        protected boolean isNodeAcceptable(Node de) {
            return de.getRole(Equation.class).getType().equals("initial assignment");
        }
    }

    public static class InitialEquationsFilter
    extends NodeFilter {
        EModel emodel;

        public InitialEquationsFilter(EModel emodel) {
            this.emodel = emodel;
        }

        @Override
        protected boolean isNodeAcceptable(Node de) {
            String varName;
            Variable var;
            Equation role = de.getRole(Equation.class);
            String type = role.getType();
            if (!("initial assignment".equals(type) || "initial value assignment".equals(type) || (var = this.emodel.getVariable(varName = role.getVariable())) != null && !var.isConstant())) {
                return false;
            }
            return "scalar".equals(type) || "initial assignment".equals(type) || "scalar_internal".equals(type) || "scalar_delayed".equals(type) || "initial value assignment".equals(type);
        }
    }

    public static class ExtendedAssignmentsFilter
    extends NodeFilter {
        EModel emodel;

        public ExtendedAssignmentsFilter(EModel emodel) {
            this.emodel = emodel;
        }

        @Override
        protected boolean isNodeAcceptable(Node de) {
            Equation role = de.getRole(Equation.class);
            String type = role.getType();
            String varName = role.getVariable();
            if (varName == null) {
                return false;
            }
            Variable var = this.emodel.getVariable(varName);
            if (var == null || var.isConstant()) {
                return false;
            }
            return "scalar".equals(type) || "scalar_internal".equals(type) || "scalar_delayed".equals(type);
        }
    }

    public static class AssignmentsFilter
    extends NodeFilter {
        @Override
        protected boolean isNodeAcceptable(Node de) {
            Equation role = de.getRole(Equation.class);
            return role.getType().equals("scalar") || role.getType().equals("scalar_internal");
        }
    }

    public static abstract class NodeFilter
    implements Filter<DiagramElement> {
        public boolean isEnabled() {
            return true;
        }

        public boolean isAcceptable(DiagramElement de) {
            return de instanceof Node && this.isNodeAcceptable((Node)de);
        }

        protected abstract boolean isNodeAcceptable(Node var1);
    }

    public class DiagramVariableResolver
    implements VariableResolver {
        protected int varNameMode;
        private final Map<String, String> index = new HashMap<String, String>();

        public DiagramVariableResolver(int varNameMode) {
            this.varNameMode = varNameMode;
            for (Variable var : EModel.this.variables) {
                this.addVariable(var);
            }
        }

        public void addVariable(Variable v) {
            if (v instanceof VariableRole) {
                DiagramElement varDe = ((VariableRole)v).getDiagramElement();
                String title = EModel.getTitle(varDe, false);
                String completeTitle = EModel.getTitle(varDe, true);
                if (!this.index.containsKey(title) || this.index.get(title).length() > v.getName().length()) {
                    this.index.put(title, v.getName());
                }
                if (!this.index.containsKey(title) || this.index.get(title).length() > v.getName().length()) {
                    this.index.put(completeTitle, v.getName());
                }
            }
        }

        public String getVariableName(String variableTitle) {
            String vName = this.index.get(variableTitle);
            if (vName != null) {
                return vName;
            }
            Variable var = EModel.this.getVariable(variableTitle);
            if (var != null) {
                return var.getName();
            }
            DiagramElement de = null;
            if (EModel.this.parsedRole != null) {
                de = EModel.this.parsedRole.getDiagramElement();
            }
            return EModel.this.getQualifiedName(variableTitle, de, 0);
        }

        public String resolveVariable(String variableName) {
            DiagramElement de = null;
            if (EModel.this.parsedRole != null) {
                de = EModel.this.parsedRole.getDiagramElement();
            }
            return EModel.this.getQualifiedName(variableName, de, this.varNameMode);
        }
    }

    public static class DelayedExpression {
        public Role role;
        public AstVarNode node;

        public DelayedExpression(AstVarNode node, Role role) {
            this.node = node;
            this.role = role;
        }
    }

    public static class CompartmentFilter
    implements Filter<DataElement> {
        private boolean findCompartments;

        public CompartmentFilter(boolean findCompartments) {
            this.findCompartments = findCompartments;
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isAcceptable(DataElement de) {
            if (de instanceof VariableRole) {
                boolean isCompartment = ((VariableRole)de).getDiagramElement().getKernel() instanceof biouml.standard.type.Compartment;
                return isCompartment == this.findCompartments;
            }
            return false;
        }
    }

    public static class VariableFilter
    implements Filter<DataElement> {
        private final boolean isVariableRole;

        public VariableFilter(boolean isVariableRole) {
            this.isVariableRole = isVariableRole;
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isAcceptable(DataElement de) {
            if (de.getName().startsWith("$$")) {
                return false;
            }
            if (!this.isVariableRole && de.getName().startsWith("$")) {
                return false;
            }
            return this.isVariableRole == de instanceof VariableRole;
        }
    }
}

