/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.SimpleTableElement;
import biouml.model.dynamics.Variable;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Utils;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;

public class DAEModelUtilities {
    static Logger log = Logger.getLogger(EModel.class.getName());

    boolean verifyDAE(EModel emodel) {
        return true;
    }

    public static void substituteAssignmentRules(Map<String, ru.biosoft.math.model.Node> macroMap, AstStart start) throws Exception {
        DAEModelUtilities.substituteSubtree(macroMap, (ru.biosoft.math.model.Node)start);
    }

    protected static void substituteSubtree(Map<String, ru.biosoft.math.model.Node> map, ru.biosoft.math.model.Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof AstVarNode) {
            ru.biosoft.math.model.Node substNode = map.get(((AstVarNode)node).getName());
            if (substNode != null && substNode.jjtGetNumChildren() > 0) {
                ru.biosoft.math.model.Node parent = node.jjtGetParent();
                parent.jjtReplaceChild(node, substNode.jjtGetChild(0));
                DAEModelUtilities.substituteSubtree(map, substNode.jjtGetChild(0));
            }
        } else {
            Utils.children((ru.biosoft.math.model.Node)node).forEach(child -> DAEModelUtilities.substituteSubtree(map, child));
        }
    }

    public static void reorderAssignmentRules(EModel emodel, List<Equation> orderedEquations, List<Equation> cycledEquations, EModel.NodeFilter filter) throws Exception {
        DAEModelUtilities.reorderEquations(emodel.getEquations(filter).toSet(), orderedEquations, cycledEquations);
    }

    public static void reorderAssignmentRules(Set<Equation> equations, List<Equation> orderedEquations, List<Equation> cycledEquations) throws Exception {
        DAEModelUtilities.reorderEquations(equations, orderedEquations, cycledEquations);
    }

    protected static Map<String, EquationASTPair> getEquationsMap(Set<Equation> equations) throws Exception {
        HashMap<String, EquationASTPair> map = new HashMap<String, EquationASTPair>();
        for (Equation equation : equations) {
            if (map.containsKey(equation.getVariable())) {
                log.log(Level.SEVERE, "Duplicate assignment rules for variable " + equation.getVariable());
                throw new Exception("Duplicate assignment rules for variable " + equation.getVariable());
            }
            AstStart start = equation.getMath();
            if (start == null) continue;
            map.put(equation.getVariable(), new EquationASTPair(equation, start));
        }
        return map;
    }

    protected static void reorderEquations(Set<Equation> equations, List<Equation> orderedEquations, List<Equation> cycledEquations) throws Exception {
        Map<String, EquationASTPair> map = DAEModelUtilities.getEquationsMap(equations);
        Set<Map.Entry<String, EquationASTPair>> entrySet = map.entrySet();
        boolean independentEquationFound = true;
        block0: while (independentEquationFound && !(entrySet = map.entrySet()).isEmpty()) {
            independentEquationFound = false;
            for (Map.Entry<String, EquationASTPair> entry : entrySet) {
                EquationASTPair pair = entry.getValue();
                if (DAEModelUtilities.dependentFromOthers(pair, map)) continue;
                independentEquationFound = true;
                orderedEquations.add(pair.equation);
                map.remove(entry.getKey());
                continue block0;
            }
        }
        ArrayList<Equation> tail = new ArrayList<Equation>();
        boolean unusedEquationFound = true;
        block2: while (unusedEquationFound && !(entrySet = map.entrySet()).isEmpty()) {
            unusedEquationFound = false;
            for (Map.Entry entry : entrySet) {
                EquationASTPair pair = (EquationASTPair)entry.getValue();
                if (DAEModelUtilities.othersDepend(pair, map)) continue;
                unusedEquationFound = true;
                tail.add(pair.equation);
                map.remove(entry.getKey());
                continue block2;
            }
        }
        Collections.reverse(tail);
        orderedEquations.addAll(tail);
        if (cycledEquations == null) {
            return;
        }
        for (EquationASTPair equationASTPair : map.values()) {
            cycledEquations.add(equationASTPair.equation);
        }
    }

    protected static boolean dependentFromOthers(EquationASTPair pair, Map<String, EquationASTPair> map) {
        return pair.variables.stream().anyMatch(s -> map.containsKey(s));
    }

    protected static boolean othersDepend(EquationASTPair pair, Map<String, EquationASTPair> map) {
        String variable = pair.equation.getVariable();
        return EntryStream.of(map).values().anyMatch(p -> p.variables.contains(variable));
    }

    public static boolean hasVariables(DiagramElement de, Set<String> required) {
        block7: {
            block11: {
                Role role;
                block10: {
                    String type;
                    block9: {
                        block8: {
                            Base kernel = de.getKernel();
                            if (kernel == null) break block7;
                            role = de.getRole();
                            type = kernel.getType();
                            if (!(kernel instanceof Reaction)) break block8;
                            String formula = ((Reaction)kernel).getKineticLaw().getFormula();
                            if (Utils.variables((String)formula).anyMatch(required::contains)) {
                                return true;
                            }
                            if (((StreamEx)((Node)de).edges().map(e -> e.getOtherEnd((Node)de)).filter(n -> n.getRole() != null && n.getRole() instanceof Variable)).anyMatch(n -> required.contains(((Variable)((Object)((Object)n.getRole()))).getName()))) {
                                return true;
                            }
                            break block7;
                        }
                        if (!Util.isPort(de)) break block9;
                        if (required.contains(Util.getPortVariable(de))) {
                            return true;
                        }
                        break block7;
                    }
                    if (role == null || !(role instanceof ExpressionOwner) || type.equals("math-function")) break block10;
                    for (String expression : ((ExpressionOwner)((Object)role)).getExpressions()) {
                        if (!Utils.variables((String)expression).anyMatch(required::contains)) continue;
                        return true;
                    }
                    break block7;
                }
                if (!(role instanceof Variable)) break block11;
                if (required.contains(((Variable)((Object)role)).getName())) {
                    return true;
                }
                break block7;
            }
            if (de instanceof Edge) {
                return ((StreamEx)((Edge)de).nodes().filter(n -> Util.isPort(n))).anyMatch(n -> required.contains(Util.getPortVariable(n)));
            }
            if (!Util.isBlock(de)) break block7;
            Iterator<DiagramElement> iterator = ((Compartment)de).iterator();
            while (iterator.hasNext()) {
                DiagramElement blockDe = iterator.next();
                if (!DAEModelUtilities.hasVariables(blockDe, required)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasFunction(DiagramElement de, Set<String> required) {
        block3: {
            block5: {
                String type;
                Role role;
                block4: {
                    Base kernel = de.getKernel();
                    if (kernel == null) break block3;
                    role = de.getRole();
                    type = kernel.getType();
                    if (!(kernel instanceof Reaction)) break block4;
                    String formula = ((Reaction)kernel).getKineticLaw().getFormula();
                    if (Utils.functions((String)formula).anyMatch(required::contains)) {
                        return true;
                    }
                    break block3;
                }
                if (role == null || !(role instanceof ExpressionOwner) || type.equals("math-function")) break block5;
                for (String expression : ((ExpressionOwner)((Object)role)).getExpressions()) {
                    if (!Utils.functions((String)expression).anyMatch(required::contains)) continue;
                    return true;
                }
                break block3;
            }
            if (!Util.isBlock(de)) break block3;
            Iterator<DiagramElement> iterator = ((Compartment)de).iterator();
            while (iterator.hasNext()) {
                DiagramElement blockDe = iterator.next();
                if (!DAEModelUtilities.hasFunction(blockDe, required)) continue;
                return true;
            }
        }
        return false;
    }

    public static void processSimpleTableElement(@Nonnull Compartment compartment, Node node) throws Exception {
        SimpleTableElement tableElement = node.getRole(SimpleTableElement.class);
        TableDataCollection table = tableElement.getTable();
        if (table == null) {
            throw new Exception("Please specufy table data collection for element " + node.getTitle());
        }
        SimpleTableElement.VarColumn argColumn = tableElement.getArgColumn();
        SimpleTableElement.VarColumn[] columns = tableElement.getColumns();
        String argName = argColumn.getVariable();
        String argColumnName = argColumn.getColumn();
        double[] arg = TableDataCollectionUtils.getColumn((TableDataCollection)table, (String)argColumnName);
        SemanticController controller = Diagram.getDiagram(compartment).getType().getSemanticController();
        for (int i = 0; i < columns.length; ++i) {
            SimpleTableElement.VarColumn var = columns[i];
            String varName = var.getVariable();
            String columnName = var.getColumn();
            double[] values = TableDataCollectionUtils.getColumn((TableDataCollection)table, (String)columnName);
            String rightHandSide = DAEModelUtilities.generatePiecewise(argName, arg, values);
            Equation eq = new Equation(null, "scalar", varName);
            eq.setFormula(rightHandSide);
            DiagramElement de = controller.createInstance(compartment, Equation.class, node.getLocation(), eq).getElement();
            compartment.put(de);
        }
    }

    public static String generatePiecewise(String argName, double[] time, double[] values) {
        StringBuffer result = new StringBuffer();
        result.append("piecewise( ");
        double curValue = Double.NaN;
        for (int i = 0; i < time.length - 1; ++i) {
            double nextValue = values[i];
            if (Double.isNaN(nextValue)) continue;
            if (!Double.isNaN(curValue) && nextValue != curValue) {
                result.append(argName + " < " + time[i] + " => " + curValue + "; ");
            }
            curValue = nextValue;
        }
        result.append(curValue + " );");
        return result.toString();
    }

    protected static class EquationASTPair {
        public Equation equation;
        public AstStart ast;
        public Set<String> variables;

        EquationASTPair(Equation equation, AstStart ast) {
            this.equation = equation;
            this.ast = ast;
            this.variables = Utils.variables((ru.biosoft.math.model.Node)ast).toSet();
        }
    }

    public static class MathScalarEquationFilter
    extends EModel.NodeFilter {
        @Override
        protected boolean isNodeAcceptable(Node de) {
            Equation role = de.getRole(Equation.class);
            String type = de.getKernel().getType();
            return role.getType().equals("scalar") && (type.equals("math-equation") || type.equals("equation"));
        }
    }
}

