/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.EModelRoleSupport;
import biouml.model.dynamics.ExpressionOwner;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.math.model.AstStart;

@PropertyName(value="Constraint")
@PropertyDescription(value="Mathematical constraint.")
public class Constraint
extends EModelRoleSupport
implements ExpressionOwner {
    private String message = "Set message!";
    private String formula = "false";
    private AstStart math;

    public Constraint(DiagramElement de) {
        this(de, "false", "");
    }

    public Constraint(DiagramElement de, String formula, String message) {
        super(de);
        this.formula = formula;
        this.message = message;
    }

    public String toString() {
        return "Constraint: " + this.formula;
    }

    @Override
    public Role clone(DiagramElement de) {
        Constraint eq = new Constraint(de, this.getFormula(), this.getMessage());
        eq.comment = this.comment;
        return eq;
    }

    @Override
    public boolean isExpression(String propertyName) {
        return "formula".equals(propertyName);
    }

    @Override
    public String[] getExpressions() {
        return new String[]{this.getFormula()};
    }

    @Override
    public void setExpressions(String[] exps) {
        this.setFormula(exps[0]);
    }

    @Override
    public Role getRole() {
        return this;
    }

    @PropertyName(value="Formula")
    @PropertyDescription(value="Formula.")
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        String oldValue = this.getFormula();
        this.formula = formula;
        this.math = null;
        this.firePropertyChange("formula", oldValue, formula);
    }

    public AstStart getMath() {
        if (this.math == null) {
            this.math = this.initMath();
        }
        return this.math;
    }

    protected AstStart initMath() {
        Role role = Diagram.getDiagram(this.getDiagramElement()).getRole();
        if (role instanceof EModel) {
            return ((EModel)role).readMath(this.getFormula(), (Role)this, 0);
        }
        return null;
    }

    @PropertyName(value="Message")
    @PropertyDescription(value="Message for constraint violation.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldValue = this.getMessage();
        this.message = message;
        this.firePropertyChange("message", oldValue, message);
    }
}

