/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.Variable;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;
import ru.biosoft.util.TextUtil;

@PropertyName(value="Assignment")
@PropertyDescription(value="Model variable or parameter assignment.")
public class Assignment
extends Option
implements ExpressionOwner {
    protected String variable;
    protected String math;

    public Assignment() {
        this.variable = "unknown";
        this.math = "0";
    }

    public Assignment(String variable, String math, Option parent) {
        super(parent);
        this.variable = variable;
        this.math = math;
    }

    public Assignment(String variable, String math) {
        this.variable = variable;
        this.math = math;
    }

    @PropertyName(value="Variable")
    @PropertyDescription(value="Name of variable or parameter.")
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        if (this.getParent() instanceof Role && (variable = Assignment.validateVariableName(variable, ((Role)this.getParent()).getDiagramElement())) == null) {
            return;
        }
        String oldValue = this.variable;
        this.variable = variable;
        this.firePropertyChange("variable", oldValue, variable);
    }

    @PropertyName(value="Expression")
    @PropertyDescription(value="Expression (formula) which result will be assigned to variable.")
    public String getMath() {
        return this.math;
    }

    public void setMath(String math) {
        String oldValue = this.math;
        this.math = math;
        this.firePropertyChange("math", oldValue, math);
    }

    public Assignment clone(Role parent) {
        Assignment assignment = new Assignment(this.variable, this.math);
        if (parent != null) {
            assignment.setParent((Option)parent);
        }
        return assignment;
    }

    public static Assignment[] clone(Assignment[] assignments, Role parent) {
        if (assignments == null) {
            return new Assignment[0];
        }
        return (Assignment[])StreamEx.of((Object[])assignments).map(assignment -> assignment.clone(parent)).toArray(Assignment[]::new);
    }

    @Override
    public boolean isExpression(String propertyName) {
        return "math".equals(propertyName) || "variable".equals(propertyName);
    }

    @Override
    public String[] getExpressions() {
        return new String[]{this.variable, this.math};
    }

    @Override
    public void setExpressions(String[] exps) {
        this.setVariable(exps[0]);
        this.setMath(exps[1]);
    }

    @Override
    public Role getRole() {
        return (Role)this.getParent();
    }

    public String toString() {
        return "Assignment: " + this.variable + " = " + this.math;
    }

    public Assignment(String str) {
        str = str.replace("Assignment:", "");
        String[] strings = TextUtil.split((String)str, (char)'=');
        this.variable = strings[0].trim();
        this.math = strings[1].trim();
    }

    static String validateVariableName(String var, DiagramElement de) {
        if (de == null || var.length() == 0 || !var.matches("[$]{0,2}[_a-zA-Z](\\w)*([\\x2E][_a-zA-Z](\\w)*)*") && !var.matches("[$]\"(.)+\"")) {
            return null;
        }
        Diagram diagram = Diagram.optDiagram(de);
        if (diagram == null || diagram.getRole() == null || !(diagram.getRole() instanceof EModel)) {
            return null;
        }
        EModel emodel = diagram.getRole(EModel.class);
        try {
            String qualifiedName = emodel.getQualifiedName(var, de);
            Variable variable = emodel.getVariable(qualifiedName);
            if (variable != null) {
                return variable.getName();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (var.startsWith("$")) {
            return null;
        }
        return var;
    }
}

