/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramContainer;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.standard.diagram.Util;
import biouml.standard.state.State;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.BeanInfoEx;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.awt.infos.ColorMessageBundle;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.ListResourceBundle;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataCollectionVetoException;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.FolderCollection;
import ru.biosoft.access.core.TransformedDataCollection;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.exception.InternalException;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.workbench.editors.GenericComboBoxEditor;

@PropertyName(value="Subdiagram")
@PropertyDescription(value="Element containing diagram to be included into another diagram.")
public class SubDiagram
extends DiagramContainer {
    public static final String ORIGINAL_PORT_ATTR = "originalPort";
    public static final String RELATIVE_SUBDIAGRAM = "relativeSubDiagram";
    public static final String SUBDIAGRAM_STATE_NAME = "SubdiagramState";
    public static final String SUBDIAGRAM_IS_MUTABLE = "subDiagramIsMutable";
    private static final String _DIAGRAM_ = "_diagram_";
    private final DiagramPropertyChangeListener listener;
    private DataElementPath diagramPath;
    private boolean isDiagramMutable = false;

    @Override
    public DiagramElement get(String name) {
        return name.equals(_DIAGRAM_) ? this.diagram : super.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubDiagram(DataCollection<?> origin, Diagram diagram, String name) throws Exception {
        super(origin, diagram, (Base)new Stub.SubDiagramKernel(origin, name));
        Diagram diagram2 = diagram;
        synchronized (diagram2) {
            this.diagramPath = diagram.getOrigin() instanceof TransformedDataCollection || diagram.getOrigin() instanceof FolderCollection ? diagram.getCompletePath() : null;
            this.setTitle(name.equals(diagram.getName()) ? name : name + " (" + diagram.getName() + ")");
            this.attributes.add(DPSUtils.createHiddenReadOnlyTransient((String)"innerNodesPortFinder", Boolean.class, (Object)true));
            State curState = diagram.getCurrentState();
            boolean isNodtificationEnabled = diagram.isNotificationEnabled();
            diagram.setNotificationEnabled(false);
            if (curState != null) {
                diagram.restore();
            }
            this.diagram = diagram.clone(diagram.getOrigin(), diagram.getName());
            if (!this.diagram.getStateNames().contains(SUBDIAGRAM_STATE_NAME)) {
                this.diagram.addState(new State(null, this.diagram, SUBDIAGRAM_STATE_NAME));
            }
            this.diagram.getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)RELATIVE_SUBDIAGRAM, SubDiagram.class, (Object)((Object)this)));
            if (curState != null) {
                this.diagram.setCurrentStateName(curState.getName());
            }
            this.listener = new DiagramPropertyChangeListener();
            this.diagram.addPropertyChangeListener(this.listener);
            this.diagram.addDataCollectionListener(this.listener);
            if (curState != null) {
                diagram.setStateEditingMode(curState);
            }
            diagram.setNotificationEnabled(isNodtificationEnabled);
            this.updatePorts();
        }
    }

    public String getStateName() {
        return this.diagram.getCurrentStateName();
    }

    public void setStateName(String stateName) {
        String oldValue = this.getStateName();
        this.diagram.setCurrentStateName(stateName);
        this.firePropertyChange("stateName", oldValue, stateName);
    }

    public State getState() {
        return this.diagram.getCurrentState();
    }

    public void setState(State state) {
        this.diagram.setStateEditingMode(state);
    }

    public void setDiagram(Diagram diagram) throws Exception {
        this.diagram.removeDataCollectionListener(this.listener);
        this.diagram.removePropertyChangeListener(this.listener);
        this.diagram.getAttributes().remove(RELATIVE_SUBDIAGRAM);
        this.diagramPath = diagram.getOrigin() instanceof TransformedDataCollection || diagram.getOrigin() instanceof FolderCollection ? diagram.getCompletePath() : null;
        this.diagram = diagram.clone(diagram.getOrigin(), diagram.getName());
        this.diagram.addPropertyChangeListener(this.listener);
        this.diagram.addDataCollectionListener(this.listener);
        this.diagram.getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)RELATIVE_SUBDIAGRAM, SubDiagram.class, (Object)((Object)this)));
        this.updatePorts(this.location);
    }

    public String getDiagramPath() {
        return this.diagramPath != null ? this.diagramPath.toString() : this.getCompletePath().getChildPath(new String[]{_DIAGRAM_}).toString();
    }

    public void refresh() {
        try {
            this.updatePorts();
            this.setView(null);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error during subdiagram refreshing: " + ex.getMessage());
        }
    }

    public void updatePorts() {
        this.updatePorts(this.getLocation());
    }

    public void updatePorts(Point pt) {
        ArrayList<Node> deletedPorts = new ArrayList<Node>();
        for (Node node : this.getNodes()) {
            Node originalPort;
            DynamicProperty dp = node.getAttributes().getProperty(ORIGINAL_PORT_ATTR);
            if (dp == null) {
                String variable = Util.getPortVariable(node);
                boolean containPort = ((StreamEx)((StreamEx)this.diagram.recursiveStream().select(Node.class).filter(n -> Util.isPort(n))).filter(n -> !Util.isPrivatePort(n))).map(n -> Util.getPortVariable(n)).has((Object)variable);
                if (containPort) continue;
                deletedPorts.add(node);
                continue;
            }
            String originalPortName = dp.getValue().toString();
            Node node2 = originalPort = originalPortName == null ? null : this.diagram.findNode(originalPortName);
            if (originalPort == null) {
                deletedPorts.add(node);
                continue;
            }
            if (!originalPort.getKernel().getType().equals(node.getKernel().getType())) {
                deletedPorts.add(node);
                continue;
            }
            String portVariable = Util.getPortVariable(originalPort);
            if (portVariable == null) continue;
            Util.setPortVariable(node, portVariable);
        }
        for (Node deletedPort : deletedPorts) {
            this.forceRemove(deletedPort);
        }
        for (Node originalPortNode : Util.getPorts(this.diagram)) {
            if (this.contains(originalPortNode.getName()) || Util.isPrivatePort(originalPortNode)) continue;
            SubDiagram.createPort(originalPortNode, this, pt);
        }
    }

    private void forceRemove(DiagramElement de) {
        if (de instanceof Edge) {
            ((Edge)de).nodes().forEach(n -> n.removeEdge((Edge)de));
        } else if (de instanceof Node) {
            for (Edge e : ((Node)de).getEdges()) {
                this.forceRemove(e);
            }
        }
        DataCollection origin = de.getOrigin();
        try {
            if (origin != null) {
                origin.remove(de.getName());
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not remove port " + de.getName() + " :" + e.getMessage());
        }
    }

    public static Node createPort(Node node, SubDiagram subDiagram, Point pt) {
        try {
            Node newNode = node.clone(subDiagram, node.getName());
            newNode.setLocation(pt);
            newNode.getAttributes().add(DPSUtils.createHiddenReadOnly((String)ORIGINAL_PORT_ATTR, String.class, (Object)node.getCompleteNameInDiagram()));
            DynamicProperty dp = newNode.getAttributes().getProperty("variableName");
            if (dp != null) {
                dp.setReadOnly(true);
            }
            newNode.save();
            newNode.setVisible(subDiagram.isVisible());
            return newNode;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not create port " + node.getName() + " :" + e.getMessage());
            return null;
        }
    }

    @Override
    @Nonnull
    public SubDiagram clone(Compartment newParent, String newName) {
        if (newParent == this) {
            throw new IllegalArgumentException("Can not clone compartment into itself, compartment=" + (Object)((Object)newParent));
        }
        try {
            SubDiagram result = new SubDiagram(newParent, this.getDiagram(), newName);
            State state = this.getDiagram().getCurrentState();
            if (state != null) {
                result.getDiagram().setCurrentStateName(state.getName());
            }
            result.setNotificationEnabled(false);
            this.doClone(result);
            result.setNotificationEnabled(this.isNotificationEnabled());
            return result;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error while subdiagram " + this.getName() + " cloning: " + ex.getMessage());
            throw ExceptionRegistry.translateException((Throwable)ex);
        }
    }

    @Override
    public boolean isDiagramMutable() {
        return this.isDiagramMutable;
    }

    public static SubDiagram getParentSubDiagram(Diagram diagram) {
        try {
            DynamicProperty dp = diagram.getAttributes().getProperty(RELATIVE_SUBDIAGRAM);
            return dp != null && dp.getValue() instanceof SubDiagram ? (SubDiagram)((Object)dp.getValue()) : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static StreamEx<Diagram> diagrams(Diagram diagram) {
        return diagram.recursiveStream().select(SubDiagram.class).map(DiagramContainer::getDiagram).prepend((Object)diagram);
    }

    public Optional<Node> findPort(String variableName) {
        return this.stream(Node.class).findAny(de -> Util.isPort(de) && variableName.equals(Util.getPortVariable(de)));
    }

    public static class PortOrientationEditor
    extends GenericComboBoxEditor {
        public Object[] getAvailableValues() {
            return new Object[]{PortOrientation.LEFT, PortOrientation.RIGHT, PortOrientation.TOP, PortOrientation.BOTTOM};
        }
    }

    public static class OrientationEditorMessageBundle
    extends ListResourceBundle {
        @Override
        protected Object[][] getContents() {
            return new Object[][]{{"DISPLAY_NAME", "Orientation"}, {"SHORT_DESCRIPTION", "Orientation property"}};
        }
    }

    public static class PortOrientationBeanInfo
    extends BeanInfoEx {
        public PortOrientationBeanInfo() {
            super(PortOrientation.class, ColorMessageBundle.class.getName());
            this.beanDescriptor.setDisplayName(this.getResourceString("DISPLAY_NAME"));
            this.beanDescriptor.setShortDescription(this.getResourceString("SHORT_DESCRIPTION"));
            this.setSimple(true);
            this.setBeanEditor(PortOrientationEditor.class);
        }
    }

    public static enum PortOrientation {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

        public static final String ORIENTATION_ATTR = "orientation";

        public String toString() {
            return this.name().toLowerCase();
        }

        public String toDirection() {
            switch (this) {
                case LEFT: {
                    return "west";
                }
                case RIGHT: {
                    return "east";
                }
                case TOP: {
                    return "north";
                }
                case BOTTOM: {
                    return "south";
                }
            }
            throw new InternalException();
        }

        public boolean isVertical() {
            return this.equals((Object)TOP) || this.equals((Object)BOTTOM);
        }

        public PortOrientation opposite() {
            switch (this) {
                case TOP: {
                    return BOTTOM;
                }
                case BOTTOM: {
                    return TOP;
                }
                case LEFT: {
                    return RIGHT;
                }
            }
            return LEFT;
        }

        public PortOrientation clockwise() {
            switch (this) {
                case TOP: {
                    return RIGHT;
                }
                case BOTTOM: {
                    return LEFT;
                }
                case LEFT: {
                    return TOP;
                }
            }
            return BOTTOM;
        }

        public static PortOrientation createInstance(String value) {
            return PortOrientation.getOrientation(value);
        }

        public static PortOrientation getOrientation(String value) {
            switch (value) {
                case "left": {
                    return LEFT;
                }
                case "right": {
                    return RIGHT;
                }
                case "top": {
                    return TOP;
                }
                case "bottom": {
                    return BOTTOM;
                }
            }
            return RIGHT;
        }
    }

    public class DiagramPropertyChangeListener
    implements PropertyChangeListener,
    DataCollectionListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("currentStateName")) {
                boolean oldValue = SubDiagram.this.isDiagramMutable;
                SubDiagram.this.isDiagramMutable = SubDiagram.SUBDIAGRAM_STATE_NAME.equals(evt.getNewValue().toString());
                SubDiagram.this.diagram.firePropertyChange(new PropertyChangeEvent((Object)SubDiagram.this, SubDiagram.SUBDIAGRAM_IS_MUTABLE, oldValue, SubDiagram.this.isDiagramMutable));
            }
        }

        public void elementAdded(DataCollectionEvent e) throws Exception {
            SubDiagram.this.refresh();
        }

        public void elementWillAdd(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
            SubDiagram.this.refresh();
        }

        public void elementChanged(DataCollectionEvent e) throws Exception {
            SubDiagram.this.refresh();
        }

        public void elementWillChange(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
            SubDiagram.this.refresh();
        }

        public void elementRemoved(DataCollectionEvent e) throws Exception {
            SubDiagram.this.refresh();
        }

        public void elementWillRemove(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
            SubDiagram.this.refresh();
        }
    }
}

