/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.CollectionDescription;
import biouml.model.Diagram;
import biouml.model.Module;
import biouml.model.ModuleType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.LocalRepository;
import ru.biosoft.access.ProtectedElement;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionInfo;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementDescriptor;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.QuerySystem;
import ru.biosoft.access.core.RepositoryAccessDeniedException;
import ru.biosoft.access.security.CodePrivilege;
import ru.biosoft.access.security.CodePrivilegeType;
import ru.biosoft.access.security.Permission;
import ru.biosoft.access.security.ProtectedDataCollectionInfo;
import ru.biosoft.access.security.SecurityManager;
import ru.biosoft.util.ExProperties;

@CodePrivilege(value={CodePrivilegeType.REPOSITORY})
public class ProtectedModule
extends Module
implements ProtectedElement {
    public static final String NEXT_CONFIG_NAME = "default.primary.config";
    private List<DataCollectionListener> initListeners;

    protected void check(String method) throws RepositoryAccessDeniedException {
        SecurityManager.check((DataElementPath)this.primaryCollection.getCompletePath(), (String)method);
    }

    public static ProtectedModule protect(Module module, int protectionStatus) throws Exception {
        File nextConfig;
        File root = ((LocalRepository)module.getPrimaryCollection()).getRootDirectory();
        File config = new File(root, "default.config");
        if (!config.renameTo(nextConfig = new File(root, NEXT_CONFIG_NAME))) {
            throw new IOException("Unable to rename " + config + " to " + nextConfig);
        }
        Properties properties = new Properties();
        properties.setProperty("name", module.getName());
        String plugins = module.getInfo().getProperty("plugins");
        if (plugins != null) {
            properties.setProperty("plugins", plugins);
        }
        properties.setProperty("class", ProtectedModule.class.getName());
        properties.setProperty("nextConfig", NEXT_CONFIG_NAME);
        properties.setProperty("protectionStatus", String.valueOf(protectionStatus));
        ExProperties.store((Properties)properties, (File)config);
        DataCollection repository = module.getOrigin().getCompletePath().getDataCollection();
        properties.put("configPath", root.getPath());
        DataCollection result = CollectionFactory.createCollection((DataCollection)repository, (Properties)properties);
        repository.put((DataElement)result);
        return (ProtectedModule)result;
    }

    public ProtectedModule(DataCollection<?> parent, Properties properties) throws Exception {
        super(parent, properties);
        Iterator<Object> iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            this.primaryCollection.getInfo().getProperties().put(key, properties.getProperty(key));
        }
        if (this.initListeners != null) {
            for (DataCollectionListener listener : this.initListeners) {
                this.addDataCollectionListener(listener);
            }
        }
        this.initListeners = null;
    }

    @Override
    protected void initModule() {
    }

    public int getSize() {
        this.check("getSize");
        return this.primaryCollection.getSize();
    }

    @Nonnull
    public Class<? extends DataElement> getDataElementType() {
        this.check("getDataElementType");
        return this.primaryCollection.getDataElementType();
    }

    public boolean isMutable() {
        Permission permission = SecurityManager.getPermissions((DataElementPath)this.getCompletePath());
        return permission.isAllowed(4) && this.primaryCollection.isMutable();
    }

    @Nonnull
    public List<String> getNameList() {
        this.check("getNameList");
        return this.primaryCollection.getNameList();
    }

    public DataCollectionInfo getInfo() {
        if (this.primaryCollection == null) {
            return super.getInfo();
        }
        this.check("getInfo");
        return new ProtectedDataCollectionInfo((DataCollection)this, this.primaryCollection.getInfo());
    }

    public boolean contains(DataElement element) {
        this.check("contains");
        return this.primaryCollection.contains(element);
    }

    public boolean contains(String name) {
        this.check("contains");
        return this.primaryCollection.contains(name);
    }

    public DataElement get(String name) throws Exception {
        Permission childPermission;
        Permission permission = SecurityManager.getPermissions((DataElementPath)this.primaryCollection.getCompletePath());
        if (permission.isMethodAllowed("get")) {
            return this.primaryCollection.get(name);
        }
        if (permission.isInfoAllowed() && (childPermission = SecurityManager.getPermissions((DataElementPath)this.primaryCollection.getCompletePath().getChildPath(new String[]{name}))).isInfoAllowed()) {
            return this.primaryCollection.get(name);
        }
        throw new RepositoryAccessDeniedException(this.primaryCollection.getCompletePath(), SecurityManager.getSessionUser(), "Read");
    }

    public DataElement put(DataElement element) {
        this.check("put");
        return this.primaryCollection.put(element);
    }

    public void remove(String name) throws Exception, UnsupportedOperationException {
        this.check("remove");
        this.primaryCollection.remove(name);
    }

    @Nonnull
    public Iterator<DataElement> iterator() {
        this.check("iterator");
        return this.primaryCollection.iterator();
    }

    public void close() throws Exception {
        this.check("close");
        this.primaryCollection.close();
    }

    @Override
    public void release(String name) {
        this.check("release");
        this.primaryCollection.release(name);
    }

    public DataElement getFromCache(String dataElementName) {
        this.check("getFromCache");
        return this.primaryCollection.getFromCache(dataElementName);
    }

    public void addDataCollectionListener(DataCollectionListener listener) {
        if (this.primaryCollection == null) {
            if (this.initListeners == null) {
                this.initListeners = new ArrayList<DataCollectionListener>();
            }
            this.initListeners.add(listener);
        } else {
            this.check("addDataCollectionListener");
            this.primaryCollection.addDataCollectionListener(listener);
        }
    }

    public void removeDataCollectionListener(DataCollectionListener listener) {
        this.check("removeDataCollectionListener");
        this.primaryCollection.removeDataCollectionListener(listener);
    }

    public void propagateElementWillChange(DataCollection source, DataCollectionEvent primaryEvent) {
        this.check("propagateElementWillChange");
        this.primaryCollection.propagateElementWillChange(source, primaryEvent);
    }

    public void propagateElementChanged(DataCollection source, DataCollectionEvent primaryEvent) {
        this.check("propagateElementChanged");
        this.primaryCollection.propagateElementChanged(source, primaryEvent);
    }

    public boolean isPropagationEnabled() {
        this.check("isPropagationEnabled");
        return this.primaryCollection.isPropagationEnabled();
    }

    public void setPropagationEnabled(boolean propagationEnabled) {
        this.check("setPropagationEnabled");
        this.primaryCollection.setPropagationEnabled(propagationEnabled);
    }

    public boolean isNotificationEnabled() {
        this.check("isNotificationEnabled");
        return this.primaryCollection.isNotificationEnabled();
    }

    public void setNotificationEnabled(boolean isEnabled) {
        this.check("setNotificationEnabled");
        this.primaryCollection.setNotificationEnabled(isEnabled);
    }

    @Override
    public ModuleType getType() {
        this.check("getInfo");
        return ((Module)this.primaryCollection).getType();
    }

    @Override
    public String getVersion() {
        this.check("getInfo");
        return ((Module)this.primaryCollection).getVersion();
    }

    @Override
    protected void applyType(String className) throws Exception {
    }

    @Override
    public <T extends DataElement> DataCollection<T> getCategory(Class<T> c) {
        this.check("get");
        return ((Module)this.primaryCollection).getCategory(c);
    }

    @Override
    public File getPath() {
        this.check("getInfo");
        return ((Module)this.primaryCollection).getPath();
    }

    @Override
    public DataElement getKernel(String relativeName) {
        this.check("get");
        return ((Module)this.primaryCollection).getKernel(relativeName);
    }

    @Override
    public <T extends DataElement> T getKernel(Class<T> c, String name) throws Exception {
        this.check("get");
        return ((Module)this.primaryCollection).getKernel(c, name);
    }

    public void putKernel(DataElement kernel) throws Exception {
        this.check("put");
        ((Module)this.primaryCollection).putKernel(kernel);
    }

    @Override
    public DataCollection<Diagram> getDiagrams() {
        this.check("get");
        return ((Module)this.primaryCollection).getDiagrams();
    }

    @Override
    public void putDiagram(Diagram diagram) throws Exception {
        this.check("put");
        ((Module)this.primaryCollection).putDiagram(diagram);
    }

    @Override
    public List<CollectionDescription> getExternalTypes() {
        this.check("getInfo");
        return ((Module)this.primaryCollection).getExternalTypes();
    }

    @Override
    public CollectionDescription[] getExternalCategories(Class<?> c) throws Exception {
        this.check("getInfo");
        return ((Module)this.primaryCollection).getExternalCategories(c);
    }

    @Override
    public QuerySystem[] getExternalLuceneFacades() {
        this.check("getInfo");
        return ((Module)this.primaryCollection).getExternalLuceneFacades();
    }

    @Override
    @Nonnull
    public String[] getExternalModuleNames() {
        this.check("getInfo");
        return ((Module)this.primaryCollection).getExternalModuleNames();
    }

    @Override
    public Module[] getExternalModules(String relativeName) {
        this.check("getInfo");
        return ((Module)this.primaryCollection).getExternalModules(relativeName);
    }

    public boolean isAcceptable(Class clazz) {
        this.check("isAcceptable");
        return this.primaryCollection.isAcceptable(clazz);
    }

    public DataElement getUnprotectedElement(int access) throws RepositoryAccessDeniedException {
        if (access == 0) {
            return this.primaryCollection;
        }
        Permission permission = SecurityManager.getPermissions((DataElementPath)this.getCompletePath());
        if (!permission.isAllowed(access)) {
            throw new RepositoryAccessDeniedException(this.getCompletePath(), SecurityManager.getSessionUser(), DataCollectionUtils.permissionToString((Permission)permission));
        }
        return this.primaryCollection;
    }

    public DataCollection<DataElement> getPrimaryCollection() {
        throw new SecurityException("Direct access to primary collection is disabled");
    }

    @Override
    public DataElementDescriptor getDescriptor(String name) {
        this.check("getDescriptor");
        return this.primaryCollection.getDescriptor(name);
    }
}

