/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramViewOptions;
import biouml.model.Node;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataCollectionVetoException;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.util.DPSUtils;

public abstract class NodeViewBuilder
implements DataCollectionListener,
PropertyChangeListener {
    protected static final String NODE_VIEW_BUILDER = "nodeViewBuilder";

    @Nonnull
    public abstract CompositeView createNodeView(Node var1, DiagramViewOptions var2, Graphics var3);

    public abstract boolean isApplicable(Node var1);

    public abstract boolean isApplicable(Diagram var1);

    public void elementAdded(DataCollectionEvent e) throws Exception {
        Node node;
        if (e.getDataElement() instanceof Node && this.isApplicable(node = (Node)e.getDataElement())) {
            this.applyNodeViewBuilder(node);
        }
    }

    public void elementWillAdd(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
    }

    public void elementChanged(DataCollectionEvent e) throws Exception {
    }

    public void elementWillChange(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
    }

    public void elementRemoved(DataCollectionEvent e) throws Exception {
    }

    public void elementWillRemove(DataCollectionEvent e) throws DataCollectionVetoException, Exception {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void applyNodeViewBuilder(Compartment compartment) {
        ((StreamEx)compartment.recursiveStream().select(Node.class).filter(this::isApplicable)).forEach(this::applyNodeViewBuilder);
    }

    public void applyNodeViewBuilder(Node node) {
        DynamicProperty dp = new DynamicProperty(NODE_VIEW_BUILDER, NodeViewBuilder.class, (Object)this);
        dp.setHidden(true);
        DPSUtils.makeTransient((DynamicProperty)dp);
        node.getAttributes().add(dp);
    }
}

