/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Role;
import biouml.standard.type.Base;
import biouml.standard.type.ImageDescriptor;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.graphics.View;
import ru.biosoft.util.DimensionEx;

@ClassIcon(value="resources/node.gif")
@PropertyName(value="Node")
@PropertyDescription(value="Diagram node.")
public class Node
extends DiagramElement {
    public static final String INNER_NODES_PORT_FINDER_ATTR = "innerNodesPortFinder";
    private boolean isVisible = true;
    protected Point location = new Point(0, 0);
    private double titleAngle = Double.NaN;
    private int titleOffset = 0;
    private View titleView;
    private boolean showTitle = true;
    private boolean useCustomImage = false;
    private DimensionEx size = new DimensionEx((Option)this);
    protected Dimension shapeSize;
    protected ImageDescriptor image = null;
    private final Map<String, Edge> edges = new LinkedHashMap<String, Edge>();

    public Node(DataCollection<?> parent, String name, Base kernel) {
        super(parent, name, kernel);
    }

    public Node(DataCollection<?> parent, Base kernel) {
        super(parent, kernel);
    }

    @PropertyName(value="Location")
    @PropertyDescription(value="Node location.")
    @Nonnull
    public Point getLocation() {
        return (Point)this.location.clone();
    }

    public void setLocation(Point location) {
        Point oldValue = this.location;
        this.location = (Point)location.clone();
        this.firePropertyChange("location", oldValue, location.clone());
    }

    public void setLocation(int x, int y) {
        this.setLocation(new Point(x, y));
    }

    public void setRelativeLocation(Diagram diagram, Point location) {
        if (diagram.getView() == null) {
            this.setLocation(location);
            return;
        }
        Rectangle rect = diagram.getView().getBounds();
        Point point = new Point();
        Node de = diagram.stream(Node.class).without((Object)this).findFirst().orElse(null);
        if (de != null) {
            point = de.getLocation();
            if (de.getView() != null) {
                rect = de.getView().getBounds();
            }
        }
        this.setLocation(location.x + point.x - rect.x, location.y + point.y - rect.y);
    }

    @PropertyName(value="Shape Size")
    @CheckForNull
    public DimensionEx getShapeSize2() {
        return this.size;
    }

    public void setShapeSize2(DimensionEx size) {
        DimensionEx oldValue = this.size;
        this.size = size;
        this.shapeSize = size.getDimension();
        if (this.useCustomImage && this.image != null) {
            this.image.updateScale();
        }
        this.firePropertyChange("shapeSize2", oldValue, this.size);
    }

    @PropertyName(value="Shape Size")
    @Nonnull
    public Dimension getShapeSize() {
        return this.size.getDimension();
    }

    public void setShapeSize(Dimension shapeSize) {
        this.size.setHeight(shapeSize.height);
        this.size.setWidth(shapeSize.width);
        if (this.useCustomImage && this.image != null) {
            this.image.updateScale();
        }
    }

    @PropertyName(value="Image")
    @Nonnull
    public ImageDescriptor getImage() {
        if (this.image == null) {
            this.image = new ImageDescriptor();
            this.image.setParent((Option)this);
        }
        return this.image;
    }

    public void setImage(ImageDescriptor image) {
        ImageDescriptor oldValue = this.image;
        this.image = image;
        if (image != null) {
            image.setParent((Option)this);
        }
        this.firePropertyChange("image", oldValue, image);
    }

    public void addEdge(Edge edge) {
        if (!this.edges.containsKey(edge.getName())) {
            this.edges.put(edge.getName(), edge);
        }
    }

    public void removeEdge(Edge edge) {
        this.edges.remove(edge.getName());
    }

    @Nonnull
    public Edge[] getEdges() {
        return this.edges.values().toArray(new Edge[this.edges.size()]);
    }

    @Nonnull
    public StreamEx<Edge> edges() {
        return StreamEx.ofValues(this.edges);
    }

    @Nonnull
    public Node clone(Compartment newParent, String newName, Base newKernel) {
        Node node = new Node(newParent, newName, newKernel);
        node.setPropagationEnabled(false);
        this.doClone(node);
        node.setView(this.view);
        node.setPropagationEnabled(this.isPropagationEnabled());
        return node;
    }

    @Override
    @Nonnull
    public Node clone(Compartment newParent, String newName) {
        return this.clone(newParent, newName, this.getKernel());
    }

    protected void doClone(Node node) {
        node.setTitle(this.getTitle());
        if (this.role != null) {
            Role role = this.role.clone(node);
            node.setRole(role);
        }
        if (this.attributes != null) {
            Iterator iter = this.attributes.nameIterator();
            while (iter.hasNext()) {
                DynamicProperty oldProp = this.attributes.getProperty((String)iter.next());
                DynamicProperty prop = null;
                try {
                    prop = DynamicPropertySetSupport.cloneProperty((DynamicProperty)oldProp);
                }
                catch (Exception e) {
                    prop = oldProp;
                }
                node.getAttributes().add(prop);
            }
        }
        node.setComment(this.getComment());
        node.setUseCustomImage(this.isUseCustomImage());
        if (node.isUseCustomImage()) {
            node.setImage(this.getImage().clone());
        }
        node.setLocation(this.getLocation());
        node.setShapeSize(this.getShapeSize());
        node.setFixed(this.isFixed());
        node.setVisible(this.isVisible());
        node.setShowTitle(this.isShowTitle());
        node.setPredefinedStyle(this.getPredefinedStyle());
        if (node.getPredefinedStyle().equals("Not selected")) {
            node.setCustomStyle(this.getCustomStyle().clone());
        }
    }

    public static Compartment findCommonOrigin(@Nonnull DiagramElement first, @Nonnull DiagramElement second) {
        DataElementPath path;
        DataCollection origin;
        if (first.getOrigin() == null || second.getOrigin() == null) {
            return null;
        }
        DataElementPath secondPath = second.getOrigin().getCompletePath();
        for (origin = first.getOrigin(); origin != null && !secondPath.isDescendantOf(path = origin.getCompletePath()); origin = origin.getOrigin()) {
        }
        return (Compartment)origin;
    }

    public boolean isNotResizable() {
        Diagram diagram = Diagram.optDiagram(this);
        return diagram == null || !diagram.getType().getSemanticController().isResizable(this);
    }

    public boolean isImageHidden() {
        return Diagram.optDiagram(this).getType().getDiagramViewBuilder().forbidCustomImage(this);
    }

    public double getTitleAngle() {
        return this.titleAngle;
    }

    public void setTitleAngle(double titleAngle) {
        double oldValue = this.titleAngle;
        this.titleAngle = titleAngle;
        this.firePropertyChange("titleAngle", oldValue, titleAngle);
    }

    public int getTitleOffset() {
        return this.titleOffset;
    }

    public void setTitleOffset(int titleOffset) {
        int oldValue = this.titleOffset;
        this.titleOffset = titleOffset;
        this.firePropertyChange("titleOffset", oldValue, titleOffset);
    }

    public View getTitleView() {
        return this.titleView;
    }

    public void setTitleView(View titleView) {
        this.titleView = titleView;
    }

    @PropertyName(value="Visible")
    @PropertyDescription(value="Visible.")
    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        boolean oldValue = this.isVisible();
        this.isVisible = isVisible;
        this.firePropertyChange("isVisible", oldValue, isVisible);
    }

    @PropertyName(value="Show title")
    @PropertyDescription(value="Show title.")
    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        boolean oldValue = this.isShowTitle();
        this.showTitle = showTitle;
        this.firePropertyChange("showTitle", oldValue, showTitle);
    }

    @Override
    protected boolean shouldFire(PropertyChangeEvent evt) {
        if (evt.getPropagationId() == this.getImage() || evt.getPropagationId() == this.getShapeSize2() || evt.getPropagationId() == this.getCustomStyle()) {
            return true;
        }
        return super.shouldFire(evt);
    }

    public boolean useDefaultView() {
        return !this.isUseCustomImage();
    }

    @PropertyName(value="Use custom image")
    public boolean isUseCustomImage() {
        return this.useCustomImage;
    }

    public void setUseCustomImage(boolean useCustomImage) {
        if (this.useCustomImage == useCustomImage) {
            return;
        }
        boolean oldValue = this.useCustomImage;
        this.useCustomImage = useCustomImage;
        this.setImage(null);
        this.firePropertyChange("useCustomImage", oldValue, useCustomImage);
    }
}

