/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.CollectionDescription;
import biouml.model.Diagram;
import biouml.model.ModuleType;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.annot.PropertyName;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import one.util.streamex.EntryStream;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.HtmlDescribedElement;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementDescriptor;
import ru.biosoft.access.core.DataElementGetException;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.DerivedDataCollection;
import ru.biosoft.access.core.QuerySystem;
import ru.biosoft.access.exception.Assert;
import ru.biosoft.exception.InternalException;
import ru.biosoft.util.TextUtil;

@PropertyName(value="module")
public class Module
extends DerivedDataCollection
implements HtmlDescribedElement {
    public static final String DIAGRAM = "Diagrams";
    public static final String DATA = "Data";
    public static final String METADATA = "Dictionaries";
    public static final String SIMULATION = "Simulation";
    public static final String IMAGES = "Images";
    public static final String GRAPHIC_NOTATIONS = "graphic notations";
    public static final String TYPE_PROPERTY = "module-type";
    public static final String RESULT = "result";
    public static final String PLOT = "plot";
    protected String pluginNames;
    protected ModuleType type;
    DataCollection<Diagram> diagrams;
    protected List<CollectionDescription> externalTypes;

    @Nonnull
    public static Module getModule(@Nonnull DataElement element) {
        Assert.notNull((String)"element", (Object)element);
        Module module = Module.optModule(element);
        if (module == null) {
            throw new InternalException("No module found for " + element.getCompletePath());
        }
        return module;
    }

    @CheckForNull
    public static Module optModule(DataElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Module) {
            return (Module)element;
        }
        if (element.getOrigin() == null) {
            return null;
        }
        String[] components = element.getCompletePath().getPathComponents();
        if (components.length == 0) {
            return null;
        }
        DataCollection dc = DataElementPath.create((String)components[0]).optDataCollection();
        if (dc == null) {
            return null;
        }
        for (int i = 1; i < components.length; ++i) {
            if (dc instanceof Module) {
                return (Module)dc;
            }
            try {
                DataElement de = dc.get(components[i]);
                if (!(de instanceof DataCollection)) {
                    return null;
                }
                dc = (DataCollection)de;
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return dc instanceof Module ? (Module)dc : null;
    }

    @Nonnull
    public static DataElementPath getModulePath(@Nonnull DataElement element) {
        return Module.getModule(element).getCompletePath();
    }

    @CheckForNull
    public static DataElementPath optModulePath(DataElement element) {
        Module module = Module.optModule(element);
        if (module == null) {
            return null;
        }
        return module.getCompletePath();
    }

    public Module(DataCollection<?> origin, Properties properties) throws Exception {
        super(origin, properties);
        String className = properties.getProperty(TYPE_PROPERTY);
        this.pluginNames = properties.getProperty("plugins");
        this.initModule();
        this.applyType(className);
        this.v_cache = new HashMap();
    }

    protected void initModule() {
        Properties primaryProperties = this.getPrimaryCollection().getInfo().getProperties();
        EntryStream.of((Map)primaryProperties).forKeyValue(this.getInfo().getProperties()::putIfAbsent);
    }

    public void release(String name) {
    }

    protected void applyType(String className) throws Exception {
        this.type = (ModuleType)ClassLoading.loadSubClass((String)className, (String)this.pluginNames, ModuleType.class).newInstance();
    }

    public ModuleType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.type.getVersion();
    }

    public <T extends DataElement> DataCollection<T> getCategory(Class<T> c) {
        if (Stub.class.isAssignableFrom(c)) {
            return null;
        }
        String name = this.type.getCategory(c);
        if (name == null) {
            return null;
        }
        DataElement de = CollectionFactory.getDataElement((String)name, (DataCollection)this);
        if (de instanceof DataCollection) {
            return (DataCollection)de;
        }
        return null;
    }

    public File getPath() {
        return new File(this.path);
    }

    public DataElement getKernel(String relativeName) {
        if (TextUtil.isFullPath((String)relativeName)) {
            return CollectionFactory.getDataElement((String)relativeName);
        }
        return CollectionFactory.getDataElement((String)relativeName, (DataCollection)this);
    }

    public <T extends DataElement> T getKernel(Class<T> c, String name) throws Exception {
        DataCollection<T> dc = this.getCategory(c);
        if (dc == null) {
            return null;
        }
        return (T)dc.get(name);
    }

    public <T extends DataElement> void putKernel(T kernel) throws Exception {
        Class<?> clazz = kernel.getClass();
        DataCollection<?> dc = this.getCategory(clazz);
        if (dc != null) {
            dc.put(kernel);
        }
    }

    public DataCollection<Diagram> getDiagrams() {
        if (this.diagrams == null) {
            try {
                this.diagrams = (DataCollection)this.get(DIAGRAM);
            }
            catch (Exception e) {
                throw new DataElementGetException((Throwable)e, this.getCompletePath().getChildPath(new String[]{DIAGRAM}));
            }
        }
        return this.diagrams;
    }

    public Diagram getDiagram(String name) throws Exception {
        return (Diagram)this.getDiagrams().get(name);
    }

    public void putDiagram(Diagram diagram) throws Exception {
        if (this.diagrams == null) {
            this.diagrams = (DataCollection)this.get(DIAGRAM);
        }
        this.diagrams.put((DataElement)diagram);
    }

    public List<CollectionDescription> getExternalTypes() {
        return this.externalTypes;
    }

    public CollectionDescription[] getExternalCategories(Class<?> c) throws Exception {
        if (this.getExternalTypes() == null) {
            return null;
        }
        if (Stub.class.isAssignableFrom(c)) {
            return null;
        }
        ArrayList<CollectionDescription> results = new ArrayList<CollectionDescription>();
        for (CollectionDescription eType : this.getExternalTypes()) {
            DataCollection dc = eType.getDc();
            if (dc == null) {
                DataElementPath completeName = DataElementPath.create((String)"databases", (String[])new String[]{eType.getModuleName()});
                if (eType.getSectionName() != null) {
                    completeName = completeName.getChildPath(new String[]{eType.getSectionName()});
                }
                if (eType.getTypeName() != null && !eType.getTypeName().equals("")) {
                    completeName = completeName.getChildPath(new String[]{eType.getTypeName()});
                }
                dc = completeName.optDataCollection();
                eType.setDc(dc);
            }
            if (dc == null || !dc.getDataElementType().getName().equals(c.getName())) continue;
            results.add(eType);
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new CollectionDescription[results.size()]);
    }

    public QuerySystem[] getExternalLuceneFacades() {
        if (this.getExternalTypes() == null) {
            return null;
        }
        ArrayList<QuerySystem> results = new ArrayList<QuerySystem>();
        try {
            for (CollectionDescription eType : this.getExternalTypes()) {
                QuerySystem lqs;
                Module module = (Module)this.getOrigin().get(eType.getModuleName());
                if (module == null || module.getInfo() == null || results.contains(lqs = module.getInfo().getQuerySystem())) continue;
                results.add(lqs);
            }
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "error while external databases loading", t);
            return null;
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new QuerySystem[results.size()]);
    }

    @Nonnull
    public String[] getExternalModuleNames() {
        if (this.getExternalTypes() == null) {
            return new String[0];
        }
        return (String[])this.getExternalTypes().stream().map(CollectionDescription::getModuleName).distinct().toArray(String[]::new);
    }

    public Module[] getExternalModules(String relativeName) {
        if (this.getExternalTypes() == null) {
            return null;
        }
        ArrayList<Module> results = new ArrayList<Module>();
        try {
            for (CollectionDescription eType : this.getExternalTypes()) {
                DataCollection dc = eType.getDc();
                Module module = (Module)this.getOrigin().get(eType.getModuleName());
                if (dc == null) {
                    DataElementPath completeName = DataElementPath.create((String)"databases", (String[])new String[]{eType.getModuleName()});
                    if (eType.getSectionName() != null) {
                        completeName = completeName.getChildPath(new String[]{eType.getSectionName()});
                    }
                    if (eType.getTypeName() != null) {
                        completeName = completeName.getChildPath(new String[]{eType.getTypeName()});
                    }
                    dc = completeName.optDataCollection();
                    eType.setDc(dc);
                }
                if (module == null || dc == null || dc.getCompletePath().toString().indexOf(relativeName) == -1) continue;
                results.add(module);
            }
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "error while external databases loading", t);
            return null;
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new Module[results.size()]);
    }

    public DataElementDescriptor getDescriptor(String name) {
        return this.getPrimaryCollection().getDescriptor(name);
    }

    public URL getBase() {
        try {
            return this.getPath().toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getBaseId() {
        return this.path;
    }

    public String getDescriptionHTML() {
        String description = this.getInfo().getDescription();
        if (description == null) {
            return "";
        }
        URL url = null;
        try {
            url = new File(this.getPath(), description).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            return description;
        }
        try {
            return ApplicationUtils.readAsString((InputStream)url.openStream());
        }
        catch (Exception e) {
            return description;
        }
    }

    public void setDescription(String description) {
        String descriptionFileName = this.getInfo().getDescription();
        File file = new File(this.getPath(), descriptionFileName);
        if (file.exists()) {
            try (PrintWriter writer = new PrintWriter(file, "UTF-8");){
                writer.write(description);
            }
            catch (IOException e) {
                this.getInfo().setDescription(description);
            }
        } else {
            this.getInfo().setDescription(description);
        }
    }
}

