/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramContainer;
import biouml.model.DiagramElement;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import javax.annotation.Nonnull;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.TransformedDataCollection;
import ru.biosoft.util.DPSUtils;

@PropertyName(value="Model definition")
@PropertyDescription(value="Element defining diagram to be included into another diagram.")
public class ModelDefinition
extends DiagramContainer {
    private DataElementPath diagramPath;
    public static final String REF_MODEL_DEFINITION = "refModelDefinition";

    @Override
    public DiagramElement get(String name) {
        return name.equals("_diagram_") ? this.diagram : super.get(name);
    }

    public ModelDefinition(DataCollection<?> origin, Diagram diagram, String name) {
        super(origin, diagram, (Base)new Stub(origin, name, "modelDefinition"));
        this.markRefModelDefinition(diagram);
        this.diagramPath = diagram.getOrigin() instanceof TransformedDataCollection ? diagram.getCompletePath() : null;
    }

    public void markRefModelDefinition(Diagram diagram) {
        DynamicProperty dp = DPSUtils.createHiddenReadOnly((String)REF_MODEL_DEFINITION, ModelDefinition.class, (Object)((Object)this));
        DPSUtils.makeTransient((DynamicProperty)dp);
        diagram.getAttributes().add(dp);
    }

    public static boolean isDefindInModelDefinition(Diagram diagram) {
        return diagram.getAttributes().getProperty(REF_MODEL_DEFINITION) != null;
    }

    public static ModelDefinition getModelDefinition(Diagram diagram) {
        DynamicProperty dp = diagram.getAttributes().getProperty(REF_MODEL_DEFINITION);
        if (dp == null) {
            return null;
        }
        return (ModelDefinition)((Object)dp.getValue());
    }

    public String getDiagramPath() {
        return this.diagramPath != null ? this.diagramPath.toString() : this.getCompletePath().getChildPath(new String[]{"_diagram_"}).toString();
    }

    @Override
    @Nonnull
    public ModelDefinition clone(Compartment newParent, String newName) {
        if (newParent == this) {
            throw new IllegalArgumentException("Can not clone compartment into itself, compartment=" + (Object)((Object)newParent));
        }
        ModelDefinition result = new ModelDefinition(newParent, this.getDiagram(), newName);
        result.setNotificationEnabled(false);
        this.doClone(result);
        result.setNotificationEnabled(this.isNotificationEnabled());
        return result;
    }
}

