/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.InitialElementProperties;
import biouml.model.Node;
import biouml.model.SemanticController;
import com.developmentontheedge.beans.Option;
import java.awt.Dimension;
import java.awt.Point;
import ru.biosoft.graphics.editor.ViewEditorPane;

public abstract class InitialElementPropertiesSupport
extends Option
implements InitialElementProperties {
    @Override
    public DiagramElementGroup createElements(Compartment c, Point location, ViewEditorPane viewPane) throws Exception {
        DiagramElementGroup elements = this.doCreateElements(c, location, viewPane);
        boolean notification = c.isNotificationEnabled();
        c.setNotificationEnabled(true);
        SemanticController controller = Diagram.getDiagram(c).getType().getSemanticController();
        if (viewPane != null) {
            viewPane.startTransaction("Add elements");
        }
        for (Node n : elements.nodesStream()) {
            n.setLocation(new Point(0, 0));
            controller.move(n, c, new Dimension(location.x, location.y), null);
            c.put(n);
        }
        elements.edgesStream().forEach(e -> c.put((DiagramElement)((Object)e)));
        if (viewPane != null) {
            viewPane.completeTransaction();
        }
        c.setNotificationEnabled(notification);
        return elements;
    }

    public abstract DiagramElementGroup doCreateElements(Compartment var1, Point var2, ViewEditorPane var3) throws Exception;
}

