/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Preferences;
import com.developmentontheedge.beans.editors.StringTagEditorSupport;
import org.apache.commons.lang.ArrayUtils;

public class GlobalViewOptions {
    protected static final String PREFERENCES_VIEW_OPTIONS = "View Options";
    protected static final String PREFERENCES_TITLE_SIZE_VIEW_OPTION = "Diagram element title size";
    protected static final String PREFERENCES_VAR_NAME_MODE_OPTION = "Variable name mode";
    protected static final int DEFAULT_MAX_TITLE_SIZE = 30;
    static final String[] VARIABLE_MODES = new String[]{"ID", "title(complete)", "title(brief)"};
    protected static final int DEFAULT_VAR_NAME_MODE = 2;

    public static int getMaxTitleSize() {
        Preferences voPreferences = GlobalViewOptions.getViewOptionsPreferences();
        if (voPreferences == null) {
            return 30;
        }
        Integer value = (Integer)voPreferences.getValue(PREFERENCES_TITLE_SIZE_VIEW_OPTION);
        if (value == null) {
            value = 30;
            try {
                voPreferences.add(new DynamicProperty(PREFERENCES_TITLE_SIZE_VIEW_OPTION, "Title size", "Maximum diagram element title size", Integer.class, (Object)value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static int getVarNameMode() {
        Preferences voPreferences = GlobalViewOptions.getViewOptionsPreferences();
        if (voPreferences == null) {
            return 2;
        }
        String value = voPreferences.getValueAsString(PREFERENCES_VAR_NAME_MODE_OPTION);
        if (value == null) {
            try {
                value = VARIABLE_MODES[2];
                DynamicProperty dp = new DynamicProperty(PREFERENCES_VAR_NAME_MODE_OPTION, PREFERENCES_VAR_NAME_MODE_OPTION, PREFERENCES_VAR_NAME_MODE_OPTION, String.class, (Object)value);
                dp.getDescriptor().setPropertyEditorClass(VarModeEditor.class);
                voPreferences.add(dp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ArrayUtils.indexOf((Object[])VARIABLE_MODES, (Object)value);
    }

    protected static Preferences getViewOptionsPreferences() {
        Preferences preferences = Application.getPreferences();
        if (preferences == null) {
            return null;
        }
        Preferences voPreferences = (Preferences)preferences.getValue(PREFERENCES_VIEW_OPTIONS);
        if (voPreferences == null) {
            try {
                voPreferences = new Preferences();
                preferences.add(new DynamicProperty(PREFERENCES_VIEW_OPTIONS, PREFERENCES_VIEW_OPTIONS, "View options", Preferences.class, (Object)voPreferences));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return voPreferences;
    }

    public static class VarModeEditor
    extends StringTagEditorSupport {
        public VarModeEditor() {
            super(VARIABLE_MODES);
        }
    }
}

