/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.Role;
import biouml.standard.type.Base;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.PropertyChangeObservable;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Point;
import java.beans.IntrospectionException;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.exception.Assert;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.SimplePath;
import ru.biosoft.util.WeakPropertyChangeForwarder;

@ClassIcon(value="resources/edge.gif")
@PropertyName(value="Edge")
@PropertyDescription(value="Diagram edge.")
public class Edge
extends DiagramElement {
    @Nonnull
    private Node input;
    @Nonnull
    private Node output;
    private Path path;
    private Point inPort;
    private Point outPort;
    private boolean fixedInOut;

    public Edge(Base kernel, @Nonnull Node input, @Nonnull Node output) {
        this(Node.findCommonOrigin(input, output), kernel, input, output);
    }

    public Edge(DataCollection<?> parent, Base kernel, @Nonnull Node input, @Nonnull Node output) {
        this(parent, Edge.getUniqEdgeName(parent, kernel, input, output), kernel, input, output);
    }

    public Edge(String id, Base kernel, @Nonnull Node input, @Nonnull Node output) {
        this(Node.findCommonOrigin(input, output), id, kernel, input, output);
    }

    public Edge(DataCollection<?> parent, String id, Base kernel, @Nonnull Node input, @Nonnull Node output) {
        super(parent, id, kernel);
        Assert.notNull((String)"input", (Object)((Object)input));
        Assert.notNull((String)"output", (Object)((Object)output));
        this.input = input;
        this.output = output;
        if (kernel instanceof Option) {
            Option option = (Option)kernel;
            new WeakPropertyChangeForwarder(evt -> {
                if (evt.getPropertyName().equals("title")) {
                    this.setTitle((String)evt.getNewValue());
                }
            }, (PropertyChangeObservable)option);
        }
    }

    public static String getUniqEdgeName(DataCollection<?> parent, Base kernel, Node input, Node output) {
        return Edge.getUniqEdgeName(parent, kernel == null ? "" : kernel.getName(), input, output);
    }

    public static String getUniqEdgeName(DataCollection<?> parent, String kernelName, Node input, Node output) {
        String result = kernelName;
        if (parent != null) {
            String name = result;
            int i = 0;
            while (parent.contains(name)) {
                name = result + "_" + ++i;
            }
            result = name;
        }
        return result;
    }

    @Nonnull
    public Node getInput() {
        return this.input;
    }

    public void setInput(@Nonnull Node input) {
        Node oldValue = this.input;
        Assert.notNull((String)"input", (Object)((Object)input));
        this.input = input;
        this.firePropertyChange("input", (Object)oldValue, (Object)input);
    }

    @Nonnull
    public Node getOutput() {
        return this.output;
    }

    public void setOutput(@Nonnull Node output) {
        Node oldValue = this.output;
        Assert.notNull((String)"output", (Object)((Object)output));
        this.output = output;
        this.firePropertyChange("output", (Object)oldValue, (Object)output);
    }

    @PropertyName(value="Path")
    @PropertyDescription(value="Path.")
    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        Path oldValue = this.path;
        this.path = path;
        this.firePropertyChange("path", oldValue, path);
        if (path != null && path.npoints > 0) {
            this.inPort = new Point(path.xpoints[0], path.ypoints[0]);
            this.outPort = new Point(path.xpoints[path.npoints - 1], path.ypoints[path.npoints - 1]);
        }
    }

    public SimplePath getSimplePath() {
        return this.path == null ? null : new SimplePath(this.path.xpoints, this.path.ypoints, this.path.pointTypes, this.path.npoints);
    }

    @PropertyName(value="Input")
    @PropertyDescription(value="Input.")
    public Point getInPort() {
        return this.inPort;
    }

    public void setInPort(Point inPort) {
        Point oldValue = this.inPort;
        this.inPort = inPort;
        this.firePropertyChange("inPort", oldValue, inPort);
    }

    @PropertyName(value="Output")
    @PropertyDescription(value="Output.")
    public Point getOutPort() {
        return this.outPort;
    }

    public void setOutPort(Point outPort) {
        Point oldValue = this.outPort;
        this.outPort = outPort;
        this.firePropertyChange("outPort", oldValue, outPort);
    }

    @PropertyName(value="Fixed edge ends")
    @PropertyDescription(value="Fix input and output points of edge.")
    public boolean isFixedInOut() {
        return this.fixedInOut;
    }

    public void setFixedInOut(boolean fixedInOut) {
        Boolean oldValue = this.fixedInOut;
        this.fixedInOut = fixedInOut;
        this.firePropertyChange("fixedInOut", oldValue, fixedInOut);
    }

    @Nonnull
    public Node getOtherEnd(Node n) {
        if (n == this.getInput()) {
            return this.getOutput();
        }
        if (n == this.getOutput()) {
            return this.getInput();
        }
        throw new IllegalArgumentException((Object)((Object)this) + ": Supplied node " + (Object)((Object)n) + " is not my input or output");
    }

    @Override
    public Edge clone(Compartment newParent, String newName) {
        try {
            String inName = CollectionFactory.getRelativeName((DataElement)this.getInput(), (DataCollection)this.getOrigin());
            String outName = CollectionFactory.getRelativeName((DataElement)this.getOutput(), (DataCollection)this.getOrigin());
            Node newInput = (Node)CollectionFactory.getDataElement((String)inName, (DataCollection)newParent, Node.class);
            Node newOutput = (Node)CollectionFactory.getDataElement((String)outName, (DataCollection)newParent, Node.class);
            Edge edge = newName != null ? new Edge(newParent, newName, this.getKernel(), newInput, newOutput) : new Edge(newParent, this.getKernel(), newInput, newOutput);
            edge.setTitle(this.getTitle());
            Role role = this.getRole();
            if (role != null) {
                Role newRole = role.clone(edge);
                edge.setRole(newRole);
            }
            if (this.path != null) {
                edge.setPath(this.path.clone());
            }
            if (this.inPort != null) {
                edge.setInPort((Point)this.inPort.clone());
            }
            if (this.outPort != null) {
                edge.setOutPort((Point)this.outPort.clone());
            }
            edge.setFixed(this.fixed);
            if (this.isFixedInOut()) {
                edge.setFixedInOut(true);
            }
            if (this.attributes != null) {
                for (DynamicProperty oldProp : this.attributes) {
                    DynamicProperty prop = null;
                    try {
                        prop = DynamicPropertySetSupport.cloneProperty((DynamicProperty)oldProp);
                    }
                    catch (IntrospectionException e) {
                        prop = oldProp;
                    }
                    edge.getAttributes().add(prop);
                }
            }
            edge.setPredefinedStyle(this.getPredefinedStyle());
            if (edge.getPredefinedStyle().equals("Not selected")) {
                edge.setCustomStyle(this.getCustomStyle().clone());
            }
            return edge;
        }
        catch (Exception e) {
            throw ExceptionRegistry.translateException((Throwable)e);
        }
    }

    public StreamEx<Node> nodes() {
        return StreamEx.of((Object[])new Node[]{this.getInput(), this.getOutput()});
    }
}

