/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementStyle;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.BeanProvider;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.RepositoryException;
import ru.biosoft.util.bean.BeanInfoEx2;

public class DiagramViewOptionsBeanProvider
implements BeanProvider {
    public Object getBean(String path) {
        try {
            DataElementPath dePath = DataElementPath.create((String)path);
            DataElement de = dePath.getDataElement();
            if (de instanceof Diagram) {
                return ((Diagram)de).getViewOptions();
            }
            if (de instanceof DiagramElement) {
                return new DiagramElementViewOptions((DiagramElement)de);
            }
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public static class DiagramElementViewOptionsBeanInfo
    extends BeanInfoEx2<DiagramElementViewOptions> {
        public DiagramElementViewOptionsBeanInfo() {
            super(DiagramElementViewOptions.class);
        }

        public void initProperties() throws Exception {
            this.addWithTags("predefinedStyle", bean -> bean.getAvailableStyles());
            this.addHidden("customStyle", "isStylePredefined");
        }
    }

    public static class DiagramElementViewOptions {
        DiagramElement de;

        public DiagramElementViewOptions(DiagramElement de) {
            this.de = de;
        }

        @PropertyName(value="Predefined style")
        public String getPredefinedStyle() {
            return this.de.getPredefinedStyle();
        }

        public Stream<String> getAvailableStyles() {
            return StreamEx.of((Object[])Diagram.getDiagram(this.de).getViewOptions().getStyles()).map(s -> s.getName()).append((Object[])new String[]{"Not selected", "Default"});
        }

        public void setPredefinedStyle(String predefinedStyle) {
            this.de.setPredefinedStyle(predefinedStyle);
        }

        @PropertyName(value="Custom style")
        public DiagramElementStyle getCustomStyle() {
            return this.de.getCustomStyle();
        }

        public void setCustomStyle(DiagramElementStyle customStyle) {
            this.de.setCustomStyle(customStyle);
        }

        public boolean isStylePredefined() {
            return this.de.isStylePredefined();
        }
    }
}

