/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.DiagramElementStyle;
import biouml.model.DiagramElementStyleDeclaration;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.Preferences;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.model.Property;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.EventListenerList;
import one.util.streamex.StreamEx;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graph.OrthogonalPathLayouter;
import ru.biosoft.graph.PathLayouterWrapper;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.editor.GridOptions;
import ru.biosoft.graphics.editor.GridOptionsMessageBundle;
import ru.biosoft.graphics.font.ColorFont;
import ru.biosoft.util.BeanUtil;
import ru.biosoft.util.TextUtil;

@PropertyName(value="Diagram view options")
public class DiagramViewOptions
extends Option
implements Cloneable {
    protected ColorFont diagramTitleFont = new ColorFont("Arial", 1, 14, Color.black);
    protected ColorFont compartmentTitleFont = new ColorFont("Arial", 1, 13, Color.black);
    protected ColorFont defaultFont = new ColorFont("Arial", 0, 12, Color.black);
    protected Pen defaultPen = new Pen(1.0f, Color.black);
    protected Pen noteLinkPen;
    protected Pen highlightPen = new Pen(2.0f, new Color(96, 171, 247));
    protected Pen nodePen = new Pen(1.0f, Color.black);
    protected Brush connectionBrush = new Brush((Paint)Color.black);
    protected Brush noteBrush = new Brush((Paint)Color.white);
    protected Point noteMargin = new Point(3, 3);
    public int compartmentTitleAlignment = 31;
    public int diagramTitleAlignment = 63;
    private PathLayouterWrapper pathLayouterWrapper = new PathLayouterWrapper((Layouter)new OrthogonalPathLayouter());
    protected boolean dependencyEdges = false;
    protected boolean autoLayout = false;
    private boolean drawOnFly = false;
    protected boolean designMode = false;
    private int nodeTitleLimit = 1000;
    protected GridOptions gridOptions;
    protected Map<String, ColorFont> fontRegistry = new HashMap<String, ColorFont>();
    private DiagramElementStyleDeclaration[] styles = new DiagramElementStyleDeclaration[0];
    protected boolean diagramTitleVisible = true;
    protected ColorFont nodeTitleFont = new ColorFont("Arial", 0, 12, Color.black);
    protected Point nodeTitleMargin = new Point(0, 3);
    protected Pen connectionPen = new Pen(1.0f, Color.black);

    public DiagramViewOptions(Option parent) {
        super(parent);
    }

    @PropertyName(value="Auto-layout edges")
    @PropertyDescription(value="Layout diagram edges automatically")
    public boolean isAutoLayout() {
        return false;
    }

    public void setAutoLayout(boolean autoLayout) {
        this.autoLayout = autoLayout;
    }

    @PropertyName(value="Draw on the fly")
    @PropertyDescription(value="If true then diagram elements will be automatically redrawn on mouse drag.")
    public boolean isDrawOnFly() {
        return this.drawOnFly;
    }

    public void setDrawOnFly(boolean drawOnFly) {
        this.drawOnFly = drawOnFly;
    }

    @PropertyName(value="Dependency edges")
    @PropertyDescription(value="If true then depndency edges will be automatically generated for equations.")
    public boolean isDependencyEdges() {
        return this.dependencyEdges;
    }

    public void setDependencyEdges(boolean dependencyEdges) {
        boolean oldValue = this.dependencyEdges;
        this.dependencyEdges = dependencyEdges;
        this.firePropertyChange("dependencyEdges", oldValue, dependencyEdges);
    }

    public Layouter getPathLayouter() {
        return this.pathLayouterWrapper.getPathLayouter();
    }

    @PropertyName(value="Path layouter")
    @PropertyDescription(value="Path layouter properties")
    public PathLayouterWrapper getPathLayouterWrapper() {
        return this.pathLayouterWrapper;
    }

    public void setPathLayouterWrapper(PathLayouterWrapper pathLayouterWrapper) {
        this.pathLayouterWrapper = pathLayouterWrapper;
    }

    public Map<String, ColorFont> getFontRegistry() {
        return this.fontRegistry;
    }

    @PropertyName(value="Grid options")
    @PropertyDescription(value="Diagram editor's grid options.")
    public GridOptions getGridOptions() {
        if (this.gridOptions == null) {
            Preferences preferences = Application.getPreferences();
            if (preferences != null) {
                Preferences gridPreferences = (Preferences)preferences.getValue("GridOptions");
                if (gridPreferences == null) {
                    this.gridOptions = new GridOptions();
                    try {
                        GridOptionsMessageBundle messageBundle = new GridOptionsMessageBundle();
                        preferences.add(new DynamicProperty("GridOptions", messageBundle.getString("DISPLAY_NAME"), messageBundle.getString("SHORT_DESCRIPTION"), Preferences.class, (Object)this.gridOptions.getAsPreferences()));
                    }
                    catch (Exception exception) {}
                } else {
                    this.gridOptions = new GridOptions(gridPreferences);
                }
                this.gridOptions.setUseDefault(true);
                this.gridOptions.setParent((Option)this);
            } else {
                this.gridOptions = new GridOptions();
            }
        }
        return this.gridOptions;
    }

    public void setGridOptions(GridOptions gridOptions) {
        if (this.gridOptions != null) {
            this.gridOptions.setParent(null);
        }
        GridOptions oldValue = this.gridOptions;
        this.gridOptions = gridOptions;
        if (this.gridOptions != null) {
            this.gridOptions.setParent((Option)this);
        }
        this.firePropertyChange("gridOptions", oldValue, gridOptions);
    }

    public boolean isDesignMode() {
        return this.designMode;
    }

    public void setDesignMode(boolean designMode) {
        boolean oldValue = this.designMode;
        this.designMode = designMode;
        this.firePropertyChange("designMode", oldValue, designMode);
    }

    @PropertyName(value="Diagram title font")
    @PropertyDescription(value="Diagram title font.")
    public ColorFont getDiagramTitleFont() {
        return this.diagramTitleFont;
    }

    public void setDiagramTitleFont(ColorFont diagramTitleFont) {
        ColorFont oldValue = this.diagramTitleFont;
        this.diagramTitleFont = diagramTitleFont;
        this.firePropertyChange("diagramTitleFont", oldValue, diagramTitleFont);
    }

    @PropertyName(value="Title visible")
    @PropertyDescription(value="Check this box if diagram title should be visible.")
    public boolean isDiagramTitleVisible() {
        return this.diagramTitleVisible;
    }

    public void setDiagramTitleVisible(boolean diagramTitleVisible) {
        boolean oldValue = this.diagramTitleVisible;
        this.diagramTitleVisible = diagramTitleVisible;
        this.firePropertyChange("diagramTitleVisible", oldValue, diagramTitleVisible);
    }

    public int getDiagramTitleAlignment() {
        return this.diagramTitleAlignment;
    }

    public void setDiagramTitleAlignment(int diagramTitleAlignment) {
        int oldValue = this.diagramTitleAlignment;
        this.diagramTitleAlignment = diagramTitleAlignment;
        this.firePropertyChange("diagramTitleAlignment", oldValue, diagramTitleAlignment);
    }

    @PropertyName(value="Compartment title font")
    @PropertyDescription(value="Compartment title font.")
    public ColorFont getCompartmentTitleFont() {
        return this.compartmentTitleFont;
    }

    public void setCompartmentTitleFont(ColorFont compartmentTitleFont) {
        ColorFont oldValue = this.compartmentTitleFont;
        this.compartmentTitleFont = compartmentTitleFont;
        this.firePropertyChange("compartmentTitleFont", oldValue, compartmentTitleFont);
    }

    public int getCompartmentTitleAlignment() {
        return this.compartmentTitleAlignment;
    }

    public void setCompartmentTitleAlignment(int compartmentTitleAlignment) {
        int oldValue = this.compartmentTitleAlignment;
        this.compartmentTitleAlignment = compartmentTitleAlignment;
        this.firePropertyChange("compartmentTitleAlignment", oldValue, compartmentTitleAlignment);
    }

    @PropertyName(value="Note brush")
    @PropertyDescription(value="Brush for notes")
    public Brush getNoteBrush() {
        return this.noteBrush;
    }

    public void setNoteBrush(Brush noteBrush) {
        Brush oldValue = this.noteBrush;
        this.noteBrush = noteBrush;
        this.firePropertyChange("noteBrush", oldValue, noteBrush);
    }

    public Point getNoteMargin() {
        return this.noteMargin;
    }

    public void setNoteMargin(Point noteMargin) {
        Point oldValue = this.noteMargin;
        this.noteMargin = noteMargin;
        this.firePropertyChange("noteMargin", oldValue, noteMargin);
    }

    @PropertyName(value="Note link pen")
    @PropertyDescription(value="Note link pen.")
    public Pen getNoteLinkPen() {
        if (this.noteLinkPen == null) {
            this.noteLinkPen = new Pen(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{7.0f, 3.0f}, 0.0f), Color.magenta.darker().darker());
        }
        return this.noteLinkPen;
    }

    public void setNoteLinkPen(Pen noteLinkPen) {
        Pen oldValue = this.noteLinkPen;
        this.noteLinkPen = noteLinkPen;
        this.firePropertyChange("noteLinkPen", oldValue, noteLinkPen);
    }

    @PropertyName(value="Node pen")
    @PropertyDescription(value="Pen for nodes border.")
    public Pen getNodePen() {
        return this.nodePen;
    }

    public void setNodePen(Pen nodePen) {
        Pen oldValue = this.nodePen;
        this.nodePen = nodePen;
        this.firePropertyChange("nodePen", oldValue, nodePen);
    }

    @PropertyName(value="Node title font")
    @PropertyDescription(value="Default Node title font.")
    public ColorFont getNodeTitleFont() {
        return this.nodeTitleFont;
    }

    public void setNodeTitleFont(ColorFont nodeTitleFont) {
        ColorFont oldValue = this.nodeTitleFont;
        this.nodeTitleFont = nodeTitleFont;
        this.firePropertyChange("nodeTitle", oldValue, nodeTitleFont);
    }

    public Point getNodeTitleMargin() {
        return this.nodeTitleMargin;
    }

    public void setNodeTitleMargin(Point nodeTitleMargin) {
        Point oldValue = this.nodeTitleMargin;
        this.nodeTitleMargin = nodeTitleMargin;
        this.firePropertyChange("nodeTitleMargin", oldValue, nodeTitleMargin);
    }

    @PropertyName(value="Connection pen")
    @PropertyDescription(value="Pen for connection edges")
    public Pen getConnectionPen() {
        return this.connectionPen;
    }

    public void setConnectionPen(Pen connectionPen) {
        Pen oldValue = this.connectionPen;
        this.connectionPen = connectionPen;
        this.firePropertyChange("connectionPen", oldValue, connectionPen);
    }

    @PropertyName(value="Connection brush")
    @PropertyDescription(value="Brush for arrow tips of connection edges")
    public Brush getConnectionBrush() {
        return this.connectionBrush;
    }

    public void setConnectionBrush(Brush connectionBrush) {
        Brush oldValue = this.connectionBrush;
        this.connectionBrush = connectionBrush;
        this.firePropertyChange("connectionBrush", oldValue, connectionBrush);
    }

    @PropertyName(value="Default pen")
    @PropertyDescription(value="Pen used for other elements")
    public Pen getDefaultPen() {
        return this.defaultPen;
    }

    public void setDefaultPen(Pen defaultPen) {
        Pen oldValue = this.defaultPen;
        this.defaultPen = defaultPen;
        this.firePropertyChange("defaultPen", oldValue, defaultPen);
    }

    @PropertyName(value="Default font")
    @PropertyDescription(value="Commonly used font")
    public ColorFont getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(ColorFont defaultFont) {
        ColorFont oldValue = this.defaultFont;
        this.defaultFont = defaultFont;
        this.firePropertyChange("defaultFont", oldValue, defaultFont);
    }

    @PropertyName(value="Styles")
    @PropertyDescription(value="Diagram element styles.")
    public DiagramElementStyleDeclaration[] getStyles() {
        return this.styles;
    }

    public void setStyles(DiagramElementStyleDeclaration[] styles) {
        DiagramElementStyleDeclaration[] oldValue = this.styles;
        this.styles = styles;
        this.firePropertyChange("styles", oldValue, styles);
    }

    public void addStyleIfAbsent(DiagramElementStyleDeclaration newStyle) {
        DiagramElementStyleDeclaration style = StreamEx.of((Object[])this.styles).findAny(s -> s.getName().equals(newStyle.getName())).orElse(null);
        if (style == null) {
            DiagramElementStyleDeclaration[] newStyles = Arrays.copyOf(this.styles, this.styles.length + 1);
            newStyles[newStyles.length - 1] = newStyle;
            this.setStyles(newStyles);
        }
    }

    public void addStylesIfAbsent(Map<String, DiagramElementStyleDeclaration> newStyles) {
        StreamEx.of((Object[])this.styles).forEach(s -> {
            DiagramElementStyleDeclaration cfr_ignored_0 = (DiagramElementStyleDeclaration)newStyles.remove(s.getName());
        });
        if (newStyles.isEmpty()) {
            return;
        }
        int i = this.styles.length;
        DiagramElementStyleDeclaration[] newStylesWithAdded = Arrays.copyOf(this.styles, this.styles.length + newStyles.size());
        Iterator<DiagramElementStyleDeclaration> iterator = newStyles.values().iterator();
        while (iterator.hasNext()) {
            newStylesWithAdded[i++] = iterator.next();
        }
        this.setStyles(newStylesWithAdded);
    }

    public DiagramElementStyle getStyle(String name) {
        DiagramElementStyleDeclaration predefined = StreamEx.of((Object[])this.styles).findAny(s -> s.getName().equals(name)).orElse(null);
        return predefined != null ? predefined.getStyle() : null;
    }

    @PropertyName(value="Highlight color")
    @PropertyDescription(value="Color to highlight nodes with specific properties.")
    public Pen getHighlightPen() {
        return this.highlightPen;
    }

    public void setHighlightPen(Pen highlightPen) {
        this.highlightPen = highlightPen;
    }

    @PropertyName(value="Node title limit")
    @PropertyDescription(value="Titles exceeding this limit wll be splitted into several lines.")
    public int getNodeTitleLimit() {
        return this.nodeTitleLimit;
    }

    public void setNodeTitleLimit(int nodeTitleLimit) {
        Integer oldValue = this.nodeTitleLimit;
        this.nodeTitleLimit = nodeTitleLimit;
        this.firePropertyChange("nodeTitleLimit", oldValue, nodeTitleLimit);
    }

    public void initFromJSON(JSONObject from) throws JSONException {
        for (Property property : BeanUtil.properties((Object)this)) {
            Object val = from.get(property.getName());
            try {
                property.setValue(TextUtil.fromString((Class)property.getValueClass(), (String)val.toString()));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        for (Property property : BeanUtil.properties((Object)this)) {
            try {
                Object value = property.getValue();
                if (value == null) continue;
                String name = property.getName();
                String object = TextUtil.toString((Object)value);
                json.putOpt(name, (Object)object);
            }
            catch (Exception exception) {}
        }
        return json;
    }

    public Object clone() {
        try {
            DiagramViewOptions clone = (DiagramViewOptions)super.clone();
            clone.listenerList = new EventListenerList();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

