/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.DiagramTypeConverter;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Variable;
import biouml.model.xml.XmlDiagramType;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.core.AbstractDataCollection;

public abstract class DiagramTypeConverterSupport
implements DiagramTypeConverter {
    protected static final Logger log = Logger.getLogger(DiagramTypeConverterSupport.class.getName());

    @Override
    public Diagram convert(Diagram diagram, Object type) throws Exception {
        DiagramType diagramType = null;
        if (type instanceof Class) {
            if (DiagramType.class.isAssignableFrom((Class)type)) {
                diagramType = (DiagramType)((Class)type).newInstance();
            } else {
                log.log(Level.SEVERE, "Incorrect diagram type class: " + ((Class)type).getName());
            }
        } else if (type instanceof String) {
            XmlDiagramType diagramTypeObj = XmlDiagramType.getTypeObject((String)type);
            if (diagramTypeObj != null) {
                diagramType = diagramTypeObj;
                ((AbstractDataCollection)diagramTypeObj.getOrigin()).removeFromCache(diagramTypeObj.getName());
            } else {
                log.log(Level.SEVERE, "Incorrect graphic notation: " + (String)type);
            }
        }
        return this.convert(diagramType, diagram);
    }

    protected abstract Diagram convert(DiagramType var1, Diagram var2) throws Exception;

    @Override
    public DiagramElement[] convertDiagramElement(DiagramElement de, Diagram diagram) throws Exception {
        return new DiagramElement[]{de};
    }

    @Override
    public boolean canConvert(DiagramElement de) {
        return true;
    }

    public void updateDiagramModel(Compartment compartment, Diagram diagram) {
        EModel model = diagram.getRole(EModel.class);
        for (DiagramElement de : compartment.recursiveStream()) {
            String varName;
            Role deRole = de.getRole();
            if (deRole instanceof Variable) {
                model.put((Variable)((Object)deRole));
                continue;
            }
            if (!(deRole instanceof Equation) || (varName = ((Equation)deRole).getVariable()).startsWith("$") && !varName.startsWith("$$") || model.containsVariable(varName)) continue;
            model.put(new Variable(varName, model, model.getVariables()));
        }
    }
}

