/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Diagram;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import ru.biosoft.access.DataElementExporter;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.jobcontrol.FunctionJobControl;

public abstract class DiagramExporter
implements DataElementExporter {
    public static final String DIAGRAM_TYPE = "diagramType";
    protected String diagramType;
    protected Map<String, String> newPaths = new HashMap<String, String>();

    public void setNewPaths(Map<String, String> newPaths) {
        this.newPaths = newPaths;
    }

    public abstract boolean accept(Diagram var1);

    public abstract void doExport(@Nonnull Diagram var1, @Nonnull File var2) throws Exception;

    public abstract boolean init(String var1, String var2);

    public int accept(DataElement de) {
        if (!(de instanceof Diagram)) {
            return 0;
        }
        if (!this.diagramType.equals("*") && !this.diagramType.equals(((Diagram)de).getType().getClass().getName())) {
            return 0;
        }
        if (this.accept((Diagram)de)) {
            return 20;
        }
        return 0;
    }

    public void doExport(@Nonnull DataElement de, @Nonnull File file) throws Exception {
        this.doExport((Diagram)de, file);
    }

    public void doExport(@Nonnull DataElement de, @Nonnull File file, FunctionJobControl jobControl) throws Exception {
        if (jobControl == null) {
            this.doExport(de, file);
            return;
        }
        jobControl.functionStarted();
        this.doExport((Diagram)de, file);
        if (jobControl.getStatus() != 4 && jobControl.getStatus() != 5) {
            jobControl.setPreparedness(100);
            jobControl.functionFinished();
        }
    }

    public boolean init(Properties properties) {
        this.diagramType = properties.getProperty(DIAGRAM_TYPE);
        if (this.diagramType == null || this.diagramType.equals("")) {
            this.diagramType = "*";
        }
        return this.init(properties.getProperty("format"), properties.getProperty("suffix"));
    }

    public List<Class<? extends DataElement>> getSupportedTypes() {
        return Collections.singletonList(Diagram.class);
    }
}

