/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.DiagramElementStyle;
import com.developmentontheedge.beans.annot.PropertyName;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.font.ColorFont;

public final class DiagramElementStyleDeclaration
implements Cloneable {
    String name = "Style_1";
    DiagramElementStyle style;
    JSONObject json = null;

    public DiagramElementStyleDeclaration() {
        this.name = "Style_1";
        this.style = new DiagramElementStyle();
    }

    public DiagramElementStyleDeclaration(String name) {
        this.name = name;
        this.style = new DiagramElementStyle();
    }

    public DiagramElementStyleDeclaration(String name, Pen pen, Brush brush, ColorFont font) {
        this(name);
        if (pen != null) {
            this.style.setPen(pen);
        }
        if (brush != null) {
            this.style.setBrush(brush);
        }
        if (font != null) {
            this.style.setFont(font);
        }
    }

    @PropertyName(value="Style name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.equals("Default") || name.equals("Not selected")) {
            return;
        }
        this.name = name;
    }

    @PropertyName(value="Style properties")
    public DiagramElementStyle getStyle() {
        return this.style;
    }

    public void setStyle(DiagramElementStyle style) {
        this.style = style;
    }

    public DiagramElementStyleDeclaration(JSONObject jsonObj) {
        this.initFromJSON(jsonObj);
    }

    public String toString() {
        try {
            return this.toJSON().toString();
        }
        catch (JSONException e) {
            return "";
        }
    }

    public JSONObject toJSON() throws JSONException {
        if (this.json == null) {
            this.json = new JSONObject();
            this.json.put("name", (Object)new JSONObject(this.name));
            this.json.put("style", (Object)this.style.toJSON());
        }
        return this.json;
    }

    private void initFromJSON(JSONObject from) {
        try {
            this.name = from.getJSONObject("name").toString();
            this.style = new DiagramElementStyle(from.getJSONObject("style"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public DiagramElementStyleDeclaration clone() {
        DiagramElementStyleDeclaration style = new DiagramElementStyleDeclaration(this.name);
        style.setStyle(this.getStyle().clone());
        return style;
    }
}

