/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.DiagramElement;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Color;
import java.awt.Paint;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.font.ColorFont;

public final class DiagramElementStyle
extends Option
implements Cloneable {
    public static final String STYLE_NOT_SELECTED = "Not selected";
    public static final String STYLE_DEFAULT = "Default";
    private Pen pen;
    private Brush brush;
    private ColorFont font;
    transient JSONObject json = null;

    public DiagramElementStyle(DiagramElement de) {
        super((Option)de);
        this.pen = new Pen();
        this.brush = new Brush((Paint)Color.white);
        this.font = new ColorFont("Arial", 0, 12, Color.black);
    }

    public DiagramElementStyle() {
        this.pen = new Pen();
        this.brush = new Brush((Paint)Color.white);
        this.font = new ColorFont("Arial", 0, 12, Color.black);
    }

    public DiagramElementStyle(JSONObject jsonObj) {
        this.initFromJSON(jsonObj);
    }

    public String toString() {
        try {
            return this.toJSON().toString();
        }
        catch (JSONException e) {
            return "";
        }
    }

    @PropertyName(value="Pen")
    @PropertyDescription(value="Border pen.")
    public Pen getPen() {
        return this.pen;
    }

    public void setPen(Pen pen) {
        Pen oldValue = this.pen;
        this.pen = pen;
        this.firePropertyChange("pen", oldValue, pen);
    }

    @PropertyName(value="Brush")
    @PropertyDescription(value="Brush.")
    public Brush getBrush() {
        return this.brush;
    }

    public void setBrush(Brush brush) {
        Brush oldValue = this.brush;
        this.brush = brush;
        this.firePropertyChange("brush", oldValue, brush);
    }

    @PropertyName(value="Title font")
    @PropertyDescription(value="Title font.")
    public ColorFont getFont() {
        return this.font;
    }

    public void setFont(ColorFont font) {
        ColorFont oldValue = this.font;
        this.font = font;
        this.firePropertyChange("font", oldValue, font);
    }

    public JSONObject toJSON() throws JSONException {
        if (this.json == null) {
            this.json = new JSONObject();
            this.json.put("font", (Object)this.font.toJSON());
            this.json.put("pen", (Object)this.pen.toJSON());
            this.json.put("brush", (Object)this.brush.toJSON());
        }
        return this.json;
    }

    private void initFromJSON(JSONObject from) {
        try {
            this.brush = new Brush(from.getJSONObject("brush"));
            this.pen = new Pen(from.getJSONObject("pen"));
            this.font = new ColorFont(from.getJSONObject("font"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public DiagramElementStyle clone() {
        DiagramElementStyle style = new DiagramElementStyle();
        style.setBrush(new Brush(this.brush.getPaint()));
        style.setPen(this.pen.clone());
        style.setFont(new ColorFont(this.font.getFont(), this.font.getColor()));
        return style;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiagramElementStyle other = (DiagramElementStyle)obj;
        return Objects.equals(this.brush, other.brush) && Objects.equals(this.font, other.font) && Objects.equals(this.pen, other.pen);
    }
}

