/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;

public class DiagramElementGroup {
    public static final DiagramElementGroup EMPTY_EG = new DiagramElementGroup();
    private List<DiagramElement> elements = new ArrayList<DiagramElement>();

    public DiagramElementGroup() {
    }

    public DiagramElementGroup(DiagramElement de) {
        if (de != null) {
            this.elements.add(de);
        }
    }

    public DiagramElementGroup(List<DiagramElement> deList) {
        this.elements.addAll(deList);
    }

    public DiagramElement get(int i) {
        if (this.elements != null && this.elements.size() > i) {
            return this.elements.get(i);
        }
        return null;
    }

    public DiagramElement getElement() {
        if (this.elements != null && this.elements.size() > 0) {
            return this.elements.get(0);
        }
        return null;
    }

    public List<DiagramElement> getElements() {
        return this.elements;
    }

    public void addAll(List<DiagramElement> additional) throws Exception {
        if (this.elements == null) {
            throw new Exception("Can not add to empty diagram element group");
        }
        this.elements.addAll(additional);
    }

    public DiagramElement getElement(Predicate<? super DiagramElement> predicate) {
        if (this.elements == null) {
            return null;
        }
        return this.elements.stream().filter(predicate).findFirst().orElse(null);
    }

    public StreamEx<Node> nodesStream() {
        if (this.elements == null) {
            return StreamEx.empty();
        }
        return StreamEx.of(this.elements).select(Node.class);
    }

    public StreamEx<Edge> edgesStream() {
        if (this.elements == null) {
            return StreamEx.empty();
        }
        return StreamEx.of(this.elements).select(Edge.class);
    }

    public void add(DiagramElement de) throws Exception {
        if (this.elements == null) {
            throw new Exception("Can not add to empty diagram element group");
        }
        this.elements.add(de);
    }

    public void putToCompartment() {
        if (this.elements == null || this.elements.size() == 0) {
            return;
        }
        this.nodesStream().forEach(n -> n.getCompartment().put((DiagramElement)((Object)n)));
        this.edgesStream().forEach(e -> e.getCompartment().put((DiagramElement)((Object)e)));
    }

    public int size() {
        return this.elements.size();
    }
}

