/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElementStyle;
import biouml.model.Role;
import biouml.model.dynamics.FormulaDelegate;
import biouml.standard.type.Base;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import com.developmentontheedge.beans.PropertyChangeObservable;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementReadException;
import ru.biosoft.access.core.MutableDataElementSupport;
import ru.biosoft.exception.LoggedClassCastException;
import ru.biosoft.graphics.View;
import ru.biosoft.util.WeakPropertyChangeForwarder;

public abstract class DiagramElement
extends MutableDataElementSupport {
    private PropertyChangeListener listener;
    private String predefinedStyle = "Default";
    private DiagramElementStyle customStyle = new DiagramElementStyle(this);
    protected boolean fixed;
    protected Base kernel;
    protected volatile View view;
    protected Role role;
    protected String comment;
    protected String title;
    protected DynamicPropertySet attributes;

    public DiagramElement(DataCollection parent, String name, Base kernel) {
        super(parent, name);
        this.kernel = kernel;
        String string = this.title = kernel != null ? kernel.getTitle() : name;
        if (kernel instanceof PropertyChangeObservable) {
            this.listener = evt -> {
                evt.setPropagationId(kernel);
                this.firePropertyChange(evt);
            };
            new WeakPropertyChangeForwarder(this.listener, (PropertyChangeObservable)kernel);
        }
    }

    public DiagramElement(DataCollection parent, Base kernel) {
        this(parent, kernel.getName(), kernel);
    }

    @PropertyName(value="Data")
    @PropertyDescription(value="Digram element is wrapper for some data entry. This data entry is storing all specific data from the database.")
    public Base getKernel() {
        return this.kernel;
    }

    public void setKernel(Base kernel) {
        throw new UnsupportedOperationException("In diagram element kernel can not be replaced.");
    }

    @PropertyName(value="Attributes")
    @PropertyDescription(value="Dynamic set of attributes.<br>This attributes can be added:<br><ul><li>during mapping of information from a database into Java objects<li>by plug-in for some specific usage<li>by customer to store some specific information formally<li>during import of experimental data</ul>")
    public DynamicPropertySet getAttributes() {
        if (this.attributes == null) {
            this.attributes = new DynamicPropertySetAsMap();
            this.attributes.addPropertyChangeListener(evt -> this.firePropertyChange(new PropertyChangeEvent((Object)this, "attributes/" + evt.getPropertyName(), evt.getOldValue(), evt.getNewValue())));
        }
        return this.attributes;
    }

    public void originChanged(Object oldValue, Object newValue) {
        this.firePropertyChange("origin", oldValue, newValue);
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    @PropertyName(value="Title")
    @PropertyDescription(value="The diagram element title.<br>By default title is data entry name. However a user can change the diagram element title.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (Objects.equals(title, this.title)) {
            return;
        }
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    @PropertyName(value="Comment")
    @PropertyDescription(value="Arbitrary text comment.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (Objects.equals(comment, this.comment)) {
            return;
        }
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    @PropertyName(value="Role")
    @PropertyDescription(value="The diagram element role in executable model e.g. variable, equation etc.")
    @CheckForNull
    public Role getRole() {
        return this.role;
    }

    @Nonnull
    public <T extends Role> T getRole(@Nonnull Class<T> clazz) throws DataElementReadException {
        Role r = this.role;
        if (r == null) {
            throw new DataElementReadException((DataElement)this, (Object)"role");
        }
        if (!clazz.isInstance(r)) {
            throw new DataElementReadException((Throwable)new LoggedClassCastException(r.getClass().getName(), clazz.getName()), (DataElement)this, (Object)"role");
        }
        return (T)r;
    }

    public void setRole(Role role) {
        Role oldValue = this.role;
        this.role = role;
        this.firePropertyChange("role", oldValue, role);
    }

    public DiagramElement clone(Compartment newParent, String newName) {
        return null;
    }

    public boolean isRoleHidden() {
        return this.role == null || this.kernel instanceof FormulaDelegate;
    }

    public String getCompleteNameInDiagram() {
        Diagram diagram = Diagram.getDiagram(this);
        return (String)((StreamEx)StreamEx.iterate((Object)((Object)this), DataElement::getOrigin).takeWhile(dc -> dc != null && dc != diagram)).map(DataElement::getName).foldLeft((str, name) -> name + "." + str).get();
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.shouldFire(evt)) {
            super.firePropertyChange(evt);
        }
    }

    protected boolean shouldFire(PropertyChangeEvent evt) {
        if (evt.getSource() == this) {
            return true;
        }
        Object propagationSource = evt.getPropagationId();
        if (propagationSource != null) {
            if (propagationSource == this.getRole() || propagationSource == this.getKernel()) {
                return true;
            }
            try {
                if (!(propagationSource instanceof DataElement) || !(this instanceof DataCollection) || propagationSource != ((DataCollection)this).get(((DataElement)propagationSource).getName())) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public void save() throws Exception {
        this.getOrigin().put((DataElement)this);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.getTitle();
    }

    @PropertyName(value="Fixed")
    @PropertyDescription(value="Indicates that Diagram element location is fixed.")
    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        Boolean oldValue = this.fixed;
        this.fixed = fixed;
        this.firePropertyChange("fixed", oldValue, fixed);
    }

    @Nonnull
    public Compartment getCompartment() {
        return (Compartment)this.getOrigin().cast(Compartment.class);
    }

    public StreamEx<DiagramElement> recursiveStream() {
        return StreamEx.ofTree((Object)((Object)this), Compartment.class, Compartment::stream);
    }

    public boolean hasNoAttributes() {
        return this.getAttributes().isEmpty();
    }

    @PropertyName(value="Predefined style")
    public String getPredefinedStyle() {
        return this.predefinedStyle;
    }

    public Stream<String> getAvailableStyles() {
        return StreamEx.of((Object[])Diagram.getDiagram(this).getViewOptions().getStyles()).map(s -> s.getName()).append((Object[])new String[]{"Not selected", "Default"});
    }

    public void setPredefinedStyle(String predefinedStyle) {
        String oldValue = this.predefinedStyle;
        if (oldValue.equals(predefinedStyle)) {
            return;
        }
        if (predefinedStyle.equals("Not selected")) {
            this.setCustomStyle(new DiagramElementStyle(this));
        } else if (!predefinedStyle.equals("Default")) {
            DiagramElementStyle style = Diagram.getDiagram(this).getViewOptions().getStyle(predefinedStyle);
            if (style == null) {
                return;
            }
            this.setCustomStyle(style);
        }
        this.predefinedStyle = predefinedStyle;
        this.firePropertyChange("predefinedStyle", oldValue, predefinedStyle);
        this.firePropertyChange("*", null, null);
    }

    @PropertyName(value="Custom style")
    public DiagramElementStyle getCustomStyle() {
        return this.customStyle;
    }

    public void setCustomStyle(DiagramElementStyle customStyle) {
        DiagramElementStyle oldValue = this.customStyle;
        this.customStyle = customStyle;
        this.firePropertyChange("customStyle", oldValue, customStyle);
    }

    public boolean isStylePredefined() {
        return !this.predefinedStyle.equals("Not selected");
    }
}

