/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.DiagramFilter;
import biouml.model.DiagramType;
import biouml.model.DiagramViewBuilder;
import biouml.model.DiagramViewOptions;
import biouml.model.Node;
import biouml.model.NodeViewBuilder;
import biouml.model.NodeViewBuilderRegistry;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.EModel;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.state.State;
import biouml.standard.state.StateChangeListener;
import biouml.standard.state.StateDiagramViewBuilder;
import biouml.standard.state.StateUndoManager;
import biouml.standard.type.Base;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.Referrer;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import com.developmentontheedge.beans.undo.Transactable;
import com.developmentontheedge.beans.undo.TransactionListener;
import com.developmentontheedge.beans.util.Beans;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.undo.UndoManager;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.exception.InternalException;
import ru.biosoft.graph.Layouter;
import ru.biosoft.plugins.graph.GraphPlugin;
import ru.biosoft.plugins.graph.LayouterDescriptor;
import ru.biosoft.util.TextUtil;

@ClassIcon(value="resources/diagram.gif")
@PropertyName(value="Diagram")
public class Diagram
extends Compartment {
    protected static final Logger log = Logger.getLogger(Diagram.class.getName());
    public static final String DIAGRAM_TYPE_PROPERTY = "diagramType";
    public static final String DIAGRAM_ROLE_PROPERTY = "diagramRole";
    public static final String COMPOSITE_DIAGRAM_PROPERTY = "compositeDiagram";
    public static final String DEFAULT_LAYOUTER = "defaultLayouter";
    public static final String NON_STATE = "non";
    private boolean hasSubDiagrams = false;
    private boolean hideInvisibleElements = true;
    protected Layouter pathLayouter = null;
    protected Layouter labelLayouter = null;
    protected DiagramType type;
    protected DiagramViewOptions viewOptions;
    protected String currentStateName = "non";
    protected State currentState = null;
    private Set<String> names = new HashSet<String>();
    protected DiagramFilter filter;
    protected DiagramFilter[] filterList;
    protected HashMap<String, State> states;
    protected StateChangeListener undoRedoListener = null;
    protected Transactable transactable;

    public Diagram(DataCollection<?> origin, Base kernel, DiagramType type) {
        super(origin, kernel);
        this.setType(type);
        this.getInfo().getProperties().setProperty("cloneForEdit", "true");
    }

    public Diagram(DataCollection<?> origin, String id) throws Exception {
        super(origin, id, (Base)null);
        this.getInfo().getProperties().setProperty("cloneForEdit", "true");
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    @Nonnull
    public static Diagram getDiagram(DiagramElement de) {
        Diagram d = Diagram.optDiagram(de);
        if (d == null) {
            throw new InternalException("No parent diagram found for " + de.getCompletePath());
        }
        return d;
    }

    @CheckForNull
    public static Diagram optDiagram(DiagramElement de) {
        if (de instanceof Diagram) {
            return (Diagram)de;
        }
        return de.parents().filter(Diagram.class::isInstance).map(d -> (Diagram)((Object)d)).findFirst().orElse(null);
    }

    @Override
    public void setRole(Role role) {
        Role oldValue = this.role;
        if (oldValue != null) {
            if (oldValue instanceof PropertyChangeListener) {
                this.removePropertyChangeListener((PropertyChangeListener)((Object)oldValue));
            }
            if (oldValue instanceof DataCollectionListener) {
                this.removeDataCollectionListener((DataCollectionListener)oldValue);
            }
        }
        this.role = role;
        if (role == null) {
            this.getInfo().getProperties().remove(DIAGRAM_ROLE_PROPERTY);
        } else {
            this.getInfo().getProperties().setProperty(DIAGRAM_ROLE_PROPERTY, role.getClass().getName());
        }
        this.firePropertyChange("role", oldValue, role);
    }

    public boolean needsRelayout() {
        return this.stream(Node.class).map(Node::getLocation).allMatch(p -> p.x == 0 && p.y == 0);
    }

    @PropertyName(value="Layouter")
    public String getLayouterName() {
        if (this.pathLayouter == null) {
            return "Default layouter";
        }
        List layouters = GraphPlugin.loadLayouters();
        for (LayouterDescriptor layouterDescriptor : layouters) {
            if (layouterDescriptor.getType() != this.pathLayouter.getClass()) continue;
            return layouterDescriptor.getDescription();
        }
        return "Default layouter";
    }

    public Layouter getPathLayouter() {
        return this.pathLayouter;
    }

    public void setPathLayouter(Layouter pathLayouter) {
        Layouter oldValue = this.pathLayouter;
        this.pathLayouter = pathLayouter;
        this.firePropertyChange("layouter", oldValue, pathLayouter);
    }

    public Layouter getLabelLayouter() {
        return this.labelLayouter;
    }

    public void setLabelLayouter(Layouter labelLayouter) {
        this.labelLayouter = labelLayouter;
    }

    public DiagramType getType() {
        return this.type;
    }

    public void setType(DiagramType type) {
        DiagramType oldValue = this.type;
        this.type = type;
        if (type == null) {
            this.getInfo().getProperties().remove(DIAGRAM_TYPE_PROPERTY);
            this.getInfo().getProperties().remove(COMPOSITE_DIAGRAM_PROPERTY);
        } else {
            this.getInfo().getProperties().setProperty(DIAGRAM_TYPE_PROPERTY, type.getClass().getName());
            this.getInfo().getProperties().setProperty(COMPOSITE_DIAGRAM_PROPERTY, String.valueOf(DiagramUtility.isComposite(this)));
        }
        this.setNodeViewBuilders();
        this.firePropertyChange("type", oldValue, type);
    }

    public void setNodeViewBuilders() {
        List<NodeViewBuilder> builders = NodeViewBuilderRegistry.getBuilders();
        if (builders == null) {
            return;
        }
        for (NodeViewBuilder builder : builders) {
            if (!builder.isApplicable(this)) continue;
            this.removeDataCollectionListener(builder);
            this.removePropertyChangeListener(builder);
            this.addDataCollectionListener(builder);
            this.addPropertyChangeListener(builder);
            builder.applyNodeViewBuilder(this);
        }
    }

    @PropertyName(value="Diagram type")
    @PropertyDescription(value="Diagram type.")
    public String getDiagramType() {
        try {
            if (this.type != null) {
                BeanInfo info = Introspector.getBeanInfo(this.type.getClass());
                return info.getBeanDescriptor().getDisplayName();
            }
        }
        catch (IntrospectionException e) {
            log.log(Level.SEVERE, "Invalid type BeanInfo", e);
        }
        return "Undefined diagram type";
    }

    public DiagramViewOptions getViewOptions() {
        if (this.viewOptions == null && this.type != null && this.type.getDiagramViewBuilder() != null) {
            this.viewOptions = this.type.getDiagramViewBuilder().createDefaultDiagramViewOptions();
        }
        return this.viewOptions;
    }

    public void setViewOptions(DiagramViewOptions options) {
        if (this.viewOptions != null) {
            this.viewOptions.setParent(null);
        }
        this.viewOptions = options;
        this.viewOptions.setParent((Option)this);
    }

    public DiagramFilter getFilter() {
        if (this.filter == null) {
            this.setDiagramFilter(this.type.getDiagramFilter(this));
        }
        return this.filter;
    }

    public void setDiagramFilter(DiagramFilter filter) {
        if (this.filter != null && this.filter instanceof Option) {
            ((Option)this.filter).setParent(null);
        }
        this.filter = filter;
        if (filter instanceof Option) {
            ((Option)filter).setParent((Option)this);
        }
    }

    public DiagramFilter[] getFilterList() {
        if (this.filterList == null) {
            this.filterList = new DiagramFilter[0];
        }
        return this.filterList;
    }

    public void setFilterList(DiagramFilter[] filters) {
        this.filterList = filters;
    }

    @Override
    public void setKernel(Base newKernel) {
        Base oldValue = this.kernel;
        this.kernel = newKernel;
        this.firePropertyChange("kernel", oldValue, newKernel);
    }

    @Override
    public void setNotificationEnabled(boolean notificationEnabled) {
        super.setNotificationEnabled(notificationEnabled);
        if (this.hasSubDiagrams) {
            this.stream(Diagram.class).forEach(d -> d.setNotificationEnabled(notificationEnabled));
        }
    }

    public boolean containState(State state) {
        return this.states != null && this.states.containsKey(state.getName()) && this.states.get(state.getName()).equals(state);
    }

    public void addState(State state) {
        HashMap<String, State> oldValue = this.states;
        if (this.states == null) {
            this.states = new HashMap();
        }
        this.states.put(state.getName(), state);
        this.firePropertyChange("states", oldValue, this.states);
    }

    public void removeAllStates() {
        if (this.states == null) {
            return;
        }
        HashMap<String, State> oldValue = this.states;
        if (this.currentState != null) {
            this.restore();
        }
        this.states = null;
        this.firePropertyChange("states", oldValue, this.states);
    }

    public void removeState(State state) {
        State stateWithSameName;
        HashMap<String, State> oldValue = this.states;
        if (this.states == null) {
            return;
        }
        if (this.currentState != null && this.currentState.equals(state)) {
            this.restore();
        }
        if ((stateWithSameName = this.states.get(state.getName())).equals(state)) {
            this.states.remove(state.getName());
        }
        this.firePropertyChange("states", oldValue, this.states);
    }

    @Nonnull
    public StreamEx<State> states() {
        return this.states == null ? StreamEx.empty() : StreamEx.ofValues(this.states);
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void setStateEditingMode(State state) {
        this.setStateEditingMode(state, null);
    }

    public void setStateEditingMode(State state, Transactable transactable) {
        this.restore();
        this.transactable = transactable;
        this.currentState = state;
        String oldValue = this.currentStateName;
        this.currentStateName = this.currentState.getName();
        this.getViewOptions();
        DiagramViewBuilder viewBuilder = this.type.getDiagramViewBuilder();
        this.type.setDiagramViewBuilder(new StateDiagramViewBuilder(viewBuilder, state, this));
        StateUndoManager undoManager = state.getStateUndoManager();
        while (((UndoManager)((Object)undoManager)).canRedo()) {
            ((UndoManager)((Object)undoManager)).redo();
        }
        this.firePropertyChange("currentStateName", oldValue, this.currentStateName);
        this.undoRedoListener = new StateChangeListener(state);
        this.addDataCollectionListener(this.undoRedoListener);
        this.addPropertyChangeListener(this.undoRedoListener);
        if (this.transactable != null) {
            this.transactable.addTransactionListener((TransactionListener)this.undoRedoListener);
        }
    }

    public void restore() {
        DiagramViewBuilder viewBuilder = this.getType().getDiagramViewBuilder();
        if (viewBuilder instanceof StateDiagramViewBuilder) {
            this.getType().setDiagramViewBuilder(((StateDiagramViewBuilder)viewBuilder).getBaseViewBuilder());
        }
        if (this.currentState != null) {
            if (this.undoRedoListener != null) {
                this.removeDataCollectionListener(this.undoRedoListener);
                this.removePropertyChangeListener(this.undoRedoListener);
                this.undoRedoListener = null;
            }
            StateUndoManager undoManager = this.currentState.getStateUndoManager();
            while (((UndoManager)((Object)undoManager)).canUndo()) {
                ((UndoManager)((Object)undoManager)).undo();
            }
            if (this.currentState != null) {
                this.currentState = null;
                String oldValue = this.currentStateName;
                this.currentStateName = NON_STATE;
                this.firePropertyChange("currentStateName", oldValue, this.currentStateName);
            }
            if (this.transactable != null) {
                this.transactable.removeTransactionListener((TransactionListener)this.undoRedoListener);
                this.transactable = null;
            }
        }
    }

    @PropertyName(value="State")
    @PropertyDescription(value="Current state.")
    public String getCurrentStateName() {
        return this.currentStateName;
    }

    public void setCurrentStateName(String currentStateName) {
        State curState;
        boolean restored = false;
        if (this.states != null && (curState = this.states.get(currentStateName)) != null) {
            this.setStateEditingMode(curState);
            restored = true;
        }
        if (!restored && !this.currentStateName.equals(NON_STATE)) {
            this.restore();
        }
    }

    public List<String> getStateNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(NON_STATE);
        if (this.states != null) {
            names.addAll(this.states.keySet());
        }
        return names;
    }

    public State getState(String name) {
        if (this.states == null) {
            return null;
        }
        return this.states.get(name);
    }

    @Nonnull
    public Diagram clone(DataCollection<?> origin, String newName) throws Exception {
        boolean notif = this.isNotificationEnabled();
        this.setNotificationEnabled(false);
        Diagram diagram = this.getType().clone().createDiagram(origin, newName, null);
        this.doClone(diagram);
        this.setNotificationEnabled(notif);
        return diagram;
    }

    @Override
    @Nonnull
    public Diagram clone(Compartment newParent, String newName) {
        try {
            Diagram diagram = this.getType().clone().createDiagram(newParent, newName, null);
            this.doClone(diagram);
            return diagram;
        }
        catch (Exception e) {
            throw ExceptionRegistry.translateException((Throwable)e);
        }
    }

    protected void doClone(Diagram diagram) throws Exception {
        diagram.restore();
        boolean notificationEnabled = false;
        if (diagram.isNotificationEnabled()) {
            notificationEnabled = true;
            diagram.setNotificationEnabled(false);
        }
        if (diagram.getRole() instanceof EModel) {
            diagram.getRole(EModel.class).setAutodetectTypes(false);
        }
        Beans.copyBean((Object)this.getViewOptions(), (Object)diagram.getViewOptions());
        super.doClone(diagram);
        if (this.getKernel() instanceof DiagramInfo) {
            DiagramInfo newInfo = ((DiagramInfo)this.kernel).clone(diagram.getName());
            newInfo.setParent((Option)diagram);
            diagram.kernel = newInfo;
        }
        if (this.filterList != null) {
            ArrayList newFilters = new ArrayList();
            for (DiagramFilter element : this.filterList) {
                if (element == null) continue;
                DiagramFilter newFilter = element.clone();
                if (this.filter == element) {
                    diagram.setDiagramFilter(newFilter);
                }
                newFilters.add(newFilter);
            }
            diagram.setFilterList(newFilters.toArray(new DiagramFilter[newFilters.size()]));
        }
        if (this.states != null) {
            for (State state : this.states.values()) {
                state.clone(null, diagram, state.getName());
            }
        }
        diagram.setCurrentStateName(this.getCurrentStateName());
        if (this.pathLayouter != null) {
            diagram.setPathLayouter(this.pathLayouter);
        }
        if (this.labelLayouter != null) {
            diagram.setLabelLayouter(this.labelLayouter);
        }
        Properties newProperties = diagram.getInfo().getProperties();
        Properties oldProperties = this.getInfo().getProperties();
        Enumeration<?> oldPropertyNames = oldProperties.propertyNames();
        while (oldPropertyNames.hasMoreElements()) {
            String name = oldPropertyNames.nextElement().toString();
            try {
                newProperties.setProperty(name, oldProperties.getProperty(name));
            }
            catch (Exception exception) {}
        }
        if (notificationEnabled) {
            diagram.setNotificationEnabled(true);
        }
        if (diagram.getRole() instanceof EModel) {
            diagram.getRole(EModel.class).setAutodetectTypes(true);
        }
    }

    public String getDescription() {
        return ((Referrer)this.getKernel()).getDescription();
    }

    public void setDescription(String description) {
        ((Referrer)this.getKernel()).setDescription(TextUtil.nullToEmpty((String)description));
        try {
            this.getCompletePath().save((DataElement)this);
        }
        catch (Exception e) {
            ExceptionRegistry.log((Throwable)e);
        }
    }

    public boolean containsRecursively(String name) {
        return this.names.contains(name);
    }

    @Override
    public DiagramElement put(DiagramElement obj) {
        DiagramElement oldElement = super.put(obj);
        if (obj instanceof SubDiagram) {
            this.hasSubDiagrams = true;
        }
        return oldElement;
    }

    protected void deregister(String name) {
        this.names.remove(name);
    }

    protected void deregister(Collection<String> names) {
        this.names.removeAll(names);
    }

    protected void register(String name) {
        this.names.add(name);
    }

    protected void register(Collection<String> names) {
        this.names.addAll(names);
    }

    public Set<String> getNames() {
        return this.names;
    }

    @PropertyName(value="Hide invisible elements")
    @PropertyDescription(value="Hide invisible elements.")
    public boolean isHideInvisibleElements() {
        return this.hideInvisibleElements;
    }

    public void setHideInvisibleElements(boolean hideInvisibleElements) {
        this.hideInvisibleElements = hideInvisibleElements;
    }

    public void removeStates() {
        if (!this.currentStateName.equals(NON_STATE)) {
            this.restore();
        }
        this.states = null;
    }

    @Override
    public String getCompleteNameInDiagram() {
        return "";
    }
}

