/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.DiagramType;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.EquivalentNodeGroup;
import biouml.model.MessageBundle;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.VariableRole;
import biouml.model.dynamics.util.EModelHelper;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.Reaction;
import biouml.standard.type.SemanticRelation;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import biouml.workbench.graph.DiagramToGraphTransformer;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import com.developmentontheedge.beans.undo.Transaction;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.undo.UndoableEdit;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.filter.Filter;
import ru.biosoft.access.core.undo.DataCollectionAddUndo;
import ru.biosoft.access.support.IdGenerator;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.editor.ViewEditorPane;

public class DefaultSemanticController
implements SemanticController {
    protected Logger log = Logger.getLogger(DefaultSemanticController.class.getName());
    protected static final MessageBundle messageBundle = new MessageBundle();
    public static final String ERROR_CAN_NOT_CLONE_NODE = messageBundle.getResourceString("ERROR_CAN_NOT_CLONE_NODE");
    public static final String ERROR_NODE_IS_DUPLICATED = messageBundle.getResourceString("ERROR_NODE_IS_DUPLICATED");

    public static boolean checkType(Object type, Base base) throws Exception {
        if (type instanceof Class) {
            return ((Class)type).isInstance(base);
        }
        if (type instanceof String) {
            return base.getType().equals(type);
        }
        return false;
    }

    @Override
    public boolean canAccept(Compartment compartment, DiagramElement de) {
        try {
            if (de != null && de.getKernel() != null) {
                Diagram diagram = Diagram.getDiagram(compartment);
                if (de instanceof Node) {
                    if (diagram.getType() == null) {
                        return true;
                    }
                    for (Object nodeType : diagram.getType().getNodeTypes()) {
                        if (!DefaultSemanticController.checkType(nodeType, de.getKernel())) continue;
                        return true;
                    }
                } else if (de instanceof Edge) {
                    for (Object edgeType : diagram.getType().getEdgeTypes()) {
                        if (!DefaultSemanticController.checkType(edgeType, de.getKernel())) continue;
                        Edge edge = (Edge)de;
                        return edge.nodes().allMatch(n -> Diagram.getDiagram(n) == diagram && CollectionFactory.getDataElement((String)CollectionFactory.getRelativeName((DataElement)n, (DataCollection)diagram), (DataCollection)diagram) != null);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.log.log(Level.SEVERE, "Error during type checkout", e);
        }
        return false;
    }

    @Override
    public boolean isResizable(DiagramElement diagramElement) {
        if (diagramElement.getKernel() instanceof Stub.Note) {
            return true;
        }
        return diagramElement instanceof Compartment && !(diagramElement instanceof Diagram) && !(diagramElement instanceof EquivalentNodeGroup);
    }

    @Override
    public boolean remove(DiagramElement de) throws Exception {
        if (de instanceof Diagram) {
            return false;
        }
        if (de instanceof Node) {
            Node node = (Node)de;
            for (Edge edge : Util.getEdges(node)) {
                edge.getOrigin().remove(edge.getName());
            }
            if (de instanceof Compartment) {
                ((Compartment)de).clear();
            }
        }
        de.getOrigin().remove(de.getName());
        return true;
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment compartment, Object type, Point point, ViewEditorPane viewEditor) {
        throw new UnsupportedOperationException("DefaultSemanticController.createInstance method should be defined in subclasses.");
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment compartment, Object type, Point point, Object properties) {
        throw new UnsupportedOperationException("DefaultSemanticController.createInstance method should be defined in subclasses.");
    }

    @Override
    public Object getPropertiesByType(Compartment compartment, Object type, Point point) {
        return null;
    }

    @Override
    public Dimension move(DiagramElement de, Compartment newParent, Dimension offset, Rectangle oldBounds) throws Exception {
        if (de instanceof Diagram) {
            if (!(de.getOrigin() instanceof DiagramElement)) {
                Diagram diagram = (Diagram)de;
                Point location = diagram.getLocation();
                location.translate(offset.width, offset.height);
                diagram.setLocation(location);
            }
        } else if (de instanceof Node) {
            Node node = (Node)de;
            Point location = node.getLocation();
            location.translate(offset.width, offset.height);
            Compartment parent = (Compartment)node.getOrigin();
            if (node == newParent) {
                newParent = (Compartment)node.getOrigin();
            }
            if (newParent != parent) {
                if (newParent.get(node.getName()) != null) {
                    throw new Exception(ERROR_NODE_IS_DUPLICATED);
                }
                if (this.canAccept(newParent, node)) {
                    node = this.changeNodeParent(node, newParent);
                }
            }
            node.setLocation(location);
            if (node instanceof Compartment) {
                this.moveInCompartment(node, (Compartment)node, offset);
            }
            for (Edge edge : node.getEdges()) {
                if (edge.isFixedInOut()) {
                    Path oldPath = edge.getPath();
                    Path newPath = new Path(oldPath.xpoints, oldPath.ypoints, oldPath.pointTypes, oldPath.npoints);
                    if (((Object)((Object)edge.getInput())).equals((Object)node)) {
                        newPath.xpoints[0] = newPath.xpoints[0] + offset.width;
                        newPath.ypoints[0] = newPath.ypoints[0] + offset.height;
                    } else if (((Object)((Object)edge.getOutput())).equals((Object)node)) {
                        int n = newPath.npoints - 1;
                        newPath.xpoints[n] = newPath.xpoints[n] + offset.width;
                        int n2 = newPath.npoints - 1;
                        newPath.ypoints[n2] = newPath.ypoints[n2] + offset.height;
                    }
                    edge.setPath(newPath);
                }
                this.recalculateEdgePath(edge);
            }
        } else if (de instanceof Edge) {
            Edge edge = (Edge)de;
            Path oldPath = edge.getPath();
            if (oldPath != null) {
                Path newPath = new Path();
                ArrayList<Integer> movedVertex = new ArrayList<Integer>();
                Rectangle bounds = null;
                if (oldBounds != null) {
                    bounds = new Rectangle(oldBounds.x, oldBounds.y, oldBounds.width + 1, oldBounds.height + 1);
                }
                for (int i = 0; i < oldPath.npoints; ++i) {
                    newPath.addPoint(oldPath.xpoints[i], oldPath.ypoints[i], oldPath.pointTypes[i]);
                    if (bounds != null && !bounds.contains(oldPath.xpoints[i], oldPath.ypoints[i])) continue;
                    if ((i == 0 || i == oldPath.npoints - 1) && edge.isFixedInOut()) {
                        Node node = i == 0 ? edge.getInput() : edge.getOutput();
                        Point location = new Point(oldPath.xpoints[i], oldPath.ypoints[i]);
                        location.translate(offset.width, offset.height);
                        Point p = Diagram.getDiagram(de).getType().getDiagramViewBuilder().getNearestNodePoint(location, node);
                        newPath.xpoints[i] = p.x;
                        newPath.ypoints[i] = p.y;
                        movedVertex.add(i);
                        continue;
                    }
                    int n = i;
                    newPath.xpoints[n] = newPath.xpoints[n] + offset.width;
                    int n3 = i;
                    newPath.ypoints[n3] = newPath.ypoints[n3] + offset.height;
                    movedVertex.add(i);
                }
                block2: for (int pos = movedVertex.size(); pos > 0; --pos) {
                    for (int i = 0; i < newPath.npoints; ++i) {
                        if (i == pos || Math.abs(newPath.xpoints[pos] - newPath.xpoints[i]) >= 7 || Math.abs(newPath.ypoints[pos] - newPath.ypoints[i]) >= 7) continue;
                        newPath.removePoint(pos);
                        continue block2;
                    }
                }
                edge.setPath(newPath);
            }
            this.recalculateEdgePath(edge);
        }
        return offset;
    }

    public void moveInCompartment(Node de, Compartment movingCompartment, Dimension offset) {
        if (de instanceof Compartment) {
            Iterator<DiagramElement> iterator = ((Compartment)de).iterator();
            while (iterator.hasNext()) {
                Path path;
                DiagramElement innerDe = iterator.next();
                if (innerDe instanceof Node) {
                    Node innerNode = (Node)innerDe;
                    Point location = innerNode.getLocation();
                    location.translate(offset.width, offset.height);
                    innerNode.setLocation(location);
                    for (Edge e : innerNode.getEdges()) {
                        Node otherNode = e.getOtherEnd(innerNode);
                        if (((Object)((Object)movingCompartment)).equals((Object)Compartment.findCommonOrigin(innerNode, otherNode))) continue;
                        this.recalculateEdgePath(e);
                    }
                    this.moveInCompartment(innerNode, movingCompartment, offset);
                    continue;
                }
                if (!(innerDe instanceof Edge) || (path = ((Edge)innerDe).getPath()) == null) continue;
                Path newPath = path.clone();
                newPath.translate(offset.width, offset.height);
                ((Edge)innerDe).setPath(newPath);
            }
        }
    }

    @Override
    public void recalculateEdgePath(Edge edge) {
        Diagram diagram = Diagram.getDiagram(edge);
        DiagramType diagramType = diagram.getType();
        if (diagramType == null) {
            return;
        }
        DiagramViewOptions viewOptions = diagram.getViewOptions();
        if (!edge.isFixed() && viewOptions != null && viewOptions.isAutoLayout() && diagramType.needAutoLayout(edge) && DiagramToGraphTransformer.layoutSingleEdge((Edge)edge, (Layouter)viewOptions.getPathLayouter(), this.getFilter())) {
            edge.setView((View)diagram.getType().getDiagramViewBuilder().createEdgeView(edge, diagram.getViewOptions(), ApplicationUtils.getGraphics()));
            return;
        }
        Point in = new Point();
        Point out = new Point();
        Path path = edge.getPath();
        if (!edge.isFixedInOut() || path == null || path.npoints < 2) {
            diagramType.getDiagramViewBuilder().calculateInOut(edge, in, out);
        } else {
            in = new Point(path.xpoints[0], path.ypoints[0]);
            out = new Point(path.xpoints[path.npoints - 1], path.ypoints[path.npoints - 1]);
        }
        if (path == null || path.npoints <= 2) {
            if (path != null && path.npoints == 2 && path.xpoints[0] == in.x && path.xpoints[1] == out.x && path.ypoints[0] == in.y && path.ypoints[1] == out.y) {
                edge.setView((View)diagram.getType().getDiagramViewBuilder().createEdgeView(edge, diagram.getViewOptions(), ApplicationUtils.getGraphics()));
                return;
            }
            edge.setPath(new Path(new int[]{in.x, out.x}, new int[]{in.y, out.y}, 2));
        } else {
            double bestDistIn = Double.MAX_VALUE;
            double bestDistOut = Double.MAX_VALUE;
            int bestPointIn = 0;
            int bestPointOut = 0;
            if (Math.abs(in.x - path.xpoints[0]) + Math.abs(in.y - path.ypoints[0]) < 3) {
                bestPointIn = 1;
                bestDistIn = 0.0;
            }
            if (Math.abs(out.x - path.xpoints[path.npoints - 1]) + Math.abs(out.y - path.ypoints[path.npoints - 1]) < 3) {
                bestPointOut = path.npoints - 2;
                bestDistOut = 0.0;
            }
            int[] tempXpoints = (int[])path.xpoints.clone();
            int[] tempYpoints = (int[])path.ypoints.clone();
            tempXpoints[0] = in.x;
            tempYpoints[0] = in.y;
            tempXpoints[tempXpoints.length - 1] = out.x;
            tempYpoints[tempYpoints.length - 1] = out.y;
            for (int i = 1; i < path.npoints - 1; ++i) {
                double distIn = (in.x - tempXpoints[i]) * (in.x - tempXpoints[i]) + (in.y - tempYpoints[i]) * (in.y - tempYpoints[i]);
                double distOut = (out.x - tempXpoints[i]) * (out.x - tempXpoints[i]) + (out.y - tempYpoints[i]) * (out.y - tempYpoints[i]);
                if (distIn < bestDistIn) {
                    bestDistIn = distIn;
                    bestPointIn = i;
                }
                if (!(distOut < bestDistOut)) continue;
                bestDistOut = distOut;
                bestPointOut = i;
            }
            int newLength = Math.max(0, bestPointOut - bestPointIn) + 3;
            int[] newXpoints = new int[newLength];
            int[] newYpoints = new int[newLength];
            int[] newPointTypes = new int[newLength];
            newXpoints[0] = in.x;
            newYpoints[0] = in.y;
            newPointTypes[0] = path.pointTypes[0];
            newXpoints[newXpoints.length - 1] = out.x;
            newYpoints[newYpoints.length - 1] = out.y;
            newPointTypes[newPointTypes.length - 1] = 0;
            System.arraycopy(tempXpoints, bestPointIn, newXpoints, 1, newLength - 2);
            System.arraycopy(tempYpoints, bestPointIn, newYpoints, 1, newLength - 2);
            System.arraycopy(path.pointTypes, bestPointIn, newPointTypes, 1, newLength - 2);
            Path newPath = new Path(newXpoints, newYpoints, newPointTypes, newLength);
            edge.setPath(newPath);
            if (!edge.isFixedInOut()) {
                diagramType.getDiagramViewBuilder().calculateInOut(edge, in, out);
            }
            newPath.xpoints[0] = in.x;
            newPath.ypoints[0] = in.y;
            newPath.xpoints[newPath.npoints - 1] = out.x;
            newPath.ypoints[newPath.npoints - 1] = out.y;
            edge.setPath(newPath);
        }
        edge.setView((View)diagram.getType().getDiagramViewBuilder().createEdgeView(edge, diagram.getViewOptions(), ApplicationUtils.getGraphics()));
    }

    @Nonnull
    private Node translateNode(@Nonnull Node oldNode, @Nonnull Node oldParent, @Nonnull Node newParent) {
        if (oldNode == oldParent) {
            return newParent;
        }
        if (!(oldParent instanceof Compartment) || !(newParent instanceof Compartment)) {
            return oldNode;
        }
        String path = oldNode.getName();
        for (DataCollection parent = oldNode.getOrigin(); parent != null && !(parent instanceof Diagram); parent = parent.getOrigin()) {
            if (parent == oldParent) {
                return (Node)CollectionFactory.getDataElement((String)path, (DataCollection)((DataCollection)newParent), Node.class);
            }
            path = parent.getName() + "/" + path;
        }
        return oldNode;
    }

    protected Node changeNodeParent(Node oldNode, Compartment newParent) throws Exception {
        EModelHelper helper;
        Role oldRole;
        Object role;
        Set edges = oldNode.recursiveStream().select(Node.class).flatMap(Node::edges).toSet();
        for (Edge edge : edges) {
            edge.getOrigin().remove(edge.getName());
        }
        Node newNode = oldNode.clone(newParent, oldNode.getName());
        Diagram diagram = Diagram.getDiagram(newNode);
        if (oldNode.getRole() instanceof VariableRole) {
            role = oldNode.getRole(VariableRole.class);
            newNode.setRole(((VariableRole)role).clone(newNode, VariableRole.createName(newNode, false)));
        }
        newNode.save();
        for (Edge edge : edges) {
            Node inNode = edge.getInput();
            Node outNode = edge.getOutput();
            Node newInNode = this.translateNode(inNode, oldNode, newNode);
            Node newOutNode = this.translateNode(outNode, oldNode, newNode);
            Edge newEdge = new Edge(edge.getName(), edge.getKernel(), newInNode, newOutNode);
            newEdge.setPropagationEnabled(false);
            newEdge.setTitle(edge.getTitle());
            Role role2 = edge.getRole();
            if (role2 != null) {
                newEdge.setRole(role2.clone(newEdge));
            }
            newEdge.setPath(edge.getPath());
            newEdge.setInPort(edge.getInPort());
            newEdge.setOutPort(edge.getOutPort());
            DynamicPropertySet attributes = edge.getAttributes();
            if (attributes != null) {
                for (DynamicProperty oldProp : attributes) {
                    DynamicProperty prop = null;
                    try {
                        prop = DynamicPropertySetSupport.cloneProperty((DynamicProperty)oldProp);
                    }
                    catch (Exception e) {
                        prop = oldProp;
                    }
                    newEdge.getAttributes().add(prop);
                }
            }
            newEdge.setPropagationEnabled(edge.isPropagationEnabled());
            newEdge.save();
        }
        role = diagram.getRole();
        if (role instanceof EModel && (oldRole = oldNode.getRole()) instanceof VariableRole) {
            String oldName = ((VariableRole)oldRole).getName();
            String newName = newNode.getRole(VariableRole.class).getName();
            helper = new EModelHelper((EModel)role);
            helper.renameVariable(oldName, newName);
        }
        if (newNode instanceof Compartment) {
            for (Node node : (StreamEx)newNode.recursiveStream().select(Node.class).filter(n -> n.getRole() instanceof VariableRole)) {
                VariableRole innerRole = node.getRole(VariableRole.class);
                newNode.setRole(innerRole.clone(newNode, VariableRole.createName(newNode, false)));
                helper = new EModelHelper((EModel)role);
                helper.renameVariable(innerRole.getName(), newNode.getRole(VariableRole.class).getName());
            }
        }
        oldNode.getOrigin().remove(oldNode.getName());
        return newNode;
    }

    protected void moveEdges(Node oldNode, Node newNode) throws Exception {
        if (oldNode instanceof Compartment && newNode instanceof Compartment) {
            for (Node childNode : ((Compartment)oldNode).getNodes()) {
                DiagramElement newChildNode = ((Compartment)newNode).get(childNode.getName());
                if (!(newChildNode instanceof Node)) continue;
                this.moveEdges(childNode, (Node)newChildNode);
            }
        }
    }

    protected Node findNewNode(Node oldNode, @Nonnull Compartment oldCompartment, Compartment newCompartment) {
        String name = CollectionFactory.getRelativeName((DataElement)oldNode, (DataCollection)oldCompartment);
        return (Node)CollectionFactory.getDataElement((String)name, (DataCollection)newCompartment, Node.class);
    }

    protected void moveEdge(Edge oldEdge, Node inNode, Node outNode) throws Exception {
        oldEdge.getOrigin().remove(oldEdge.getName());
        Edge newEdge = new Edge(oldEdge.getKernel(), inNode, outNode);
        Role oldRole = oldEdge.getRole();
        if (oldRole != null) {
            newEdge.setRole(oldRole.clone(newEdge));
        }
        newEdge.setInPort(null);
        newEdge.setOutPort(null);
        newEdge.save();
    }

    private static void fillAddedElementNames(UndoableEdit edit, Set<String> names) {
        if (edit instanceof DataCollectionAddUndo) {
            names.add(((DataCollectionAddUndo)edit).getDataElement().getName());
        } else if (edit instanceof Transaction) {
            for (UndoableEdit innerEdit : ((Transaction)edit).getEdits()) {
                DefaultSemanticController.fillAddedElementNames(innerEdit, names);
            }
        }
    }

    public static String generateUniqueName(Compartment compartment, String baseName) {
        return DefaultSemanticController.generateUniqueName(compartment, baseName, true);
    }

    public static String generateUniqueName(Compartment compartment, String baseName, boolean tryNoIndex) {
        Diagram diagram = Diagram.getDiagram(compartment);
        HashSet names = new HashSet();
        diagram.states().flatCollection(state -> state.getStateUndoManager().getEdits()).forEach(edit -> DefaultSemanticController.fillAddedElementNames(edit, names));
        int index = 1;
        if (tryNoIndex && !diagram.containsRecursively(baseName) && !names.contains(baseName)) {
            return baseName;
        }
        String result = baseName + "_" + index;
        while (diagram.containsRecursively(result) && !names.contains(baseName)) {
            result = baseName + "_" + ++index;
        }
        return result;
    }

    public static String generateUniqueNodeName(Compartment compartment, String baseName) {
        return DefaultSemanticController.generateUniqueNodeName(compartment, baseName, true);
    }

    public static boolean isNodeNameUnique(Compartment compartment, String id) {
        return DefaultSemanticController.isNodeNameUnique(compartment, id, true);
    }

    public static String generateUniqueNodeName(Compartment compartment, String id, boolean includeSubCompartments) {
        return DefaultSemanticController.generateUniqueNodeName(compartment, id, includeSubCompartments, "_");
    }

    public static String generateUniqueNodeName(Compartment compartment, String baseName, boolean includeSubCompartments, String delimiter) {
        while (compartment.getOrigin() instanceof Compartment && !(compartment instanceof Diagram)) {
            compartment = (Compartment)compartment.getOrigin();
        }
        if (DefaultSemanticController.isNodeNameUnique(compartment, baseName, includeSubCompartments)) {
            return baseName;
        }
        String id = baseName + delimiter;
        int n = 1;
        while (!DefaultSemanticController.isNodeNameUnique(compartment, id + n, includeSubCompartments)) {
            ++n;
        }
        return id + n;
    }

    public static boolean isNodeNameUnique(Compartment compartment, String id, boolean includeSubCompartments) {
        if (compartment.contains(id)) {
            return false;
        }
        if (compartment instanceof Diagram && ((Diagram)compartment).states().flatCollection(state -> state.getStateUndoManager().getEdits()).anyMatch(edit -> !DefaultSemanticController.isNameUnique(edit, id))) {
            return false;
        }
        if (!includeSubCompartments) {
            return true;
        }
        Iterator<DiagramElement> iterator = compartment.iterator();
        while (iterator.hasNext()) {
            DiagramElement de = iterator.next();
            if (!(de instanceof Compartment) || DefaultSemanticController.isNodeNameUnique((Compartment)de, id, true)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isNameUnique(UndoableEdit edit, String name) {
        if (edit instanceof DataCollectionAddUndo && name.equals(((DataCollectionAddUndo)edit).getDataElement().getName())) {
            return false;
        }
        if (edit instanceof Transaction) {
            for (UndoableEdit innerEdit : ((Transaction)edit).getEdits()) {
                if (DefaultSemanticController.isNameUnique(innerEdit, name)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public DiagramElement validate(Compartment compartment, @Nonnull DiagramElement de) throws Exception {
        return this.validate(compartment, de, false);
    }

    @Override
    public DiagramElement validate(Compartment compartment, @Nonnull DiagramElement de, boolean newElement) throws Exception {
        return de;
    }

    @Override
    public DiagramElementGroup addInstanceFromElement(Compartment compartment, DataElement dataElement, Point point, ViewEditorPane viewEditor) throws Exception {
        Node node = compartment.findNode(dataElement.getName());
        if (node != null) {
            this.log.info("Element " + dataElement.getName() + " already exists in compartment " + compartment.getName());
            return new DiagramElementGroup(node);
        }
        DiagramElementGroup result = this.createInstanceFromElement(compartment, dataElement, point, viewEditor);
        for (DiagramElement de : result.nodesStream()) {
            if (de == null) continue;
            viewEditor.add((Object)de, point);
        }
        for (DiagramElement de : result.edgesStream()) {
            if (de == null) continue;
            viewEditor.add((Object)de, point);
        }
        return result;
    }

    public DiagramElementGroup createInstanceFromElement(Compartment compartment, DataElement element, Point point, ViewEditorPane viewEditor) throws Exception {
        String name = element.getName();
        int i = 2;
        while (compartment.contains(name)) {
            name = element.getName() + "_" + i++;
        }
        DiagramElement result = null;
        if (element instanceof Node) {
            result = ((DiagramElement)element).clone(compartment, name);
        } else if (element instanceof Edge) {
            DiagramElement output;
            Edge edge = (Edge)element;
            DiagramElement input = compartment.get(edge.getInput().getName());
            Point inputPos = null;
            Point outputPos = null;
            if (input == null || !(input instanceof Node) || input.getKernel() != edge.getInput().getKernel()) {
                inputPos = new Point(point.x, point.y - 50);
                input = this.createInstanceFromElement(compartment, (DataElement)edge.getInput(), inputPos, viewEditor).getElement();
                if (input == null) {
                    throw new Exception("Cannot create input node for edge");
                }
            }
            if ((output = compartment.get(edge.getOutput().getName())) == null || !(output instanceof Node) || output.getKernel() != edge.getOutput().getKernel()) {
                outputPos = new Point(point.x, point.y + 50);
                output = this.createInstanceFromElement(compartment, (DataElement)edge.getOutput(), outputPos, viewEditor).getElement();
                if (output == null) {
                    throw new Exception("Cannot create output node for edge");
                }
            }
            if (!compartment.contains(input.getName()) && inputPos != null) {
                viewEditor.add((Object)input, inputPos);
            }
            if (!compartment.contains(output.getName()) && outputPos != null) {
                viewEditor.add((Object)output, outputPos);
            }
            result = new Edge(compartment, edge.getKernel(), (Node)input, (Node)output);
        } else if (element instanceof Base) {
            result = new Node(compartment, name, (Base)element);
        }
        if (result != null && this.canAccept(compartment, result)) {
            return new DiagramElementGroup(result);
        }
        return DiagramElementGroup.EMPTY_EG;
    }

    public static String generateReactionName(DataCollection<?> reactionDC) {
        String idFormat;
        DecimalFormat formatter = Reaction.NAME_FORMAT;
        if (reactionDC != null && (idFormat = reactionDC.getInfo().getProperty("id-format")) != null) {
            formatter = new DecimalFormat(idFormat);
        }
        int startInd = reactionDC instanceof Diagram ? (int)((Diagram)reactionDC).recursiveStream().count() + 1 : 0;
        return IdGenerator.generateUniqueName(reactionDC, (DecimalFormat)formatter, (int)startInd);
    }

    @Override
    public Filter<DiagramElement> getFilter() {
        return null;
    }

    @Override
    public Dimension resize(DiagramElement de, Dimension sizeChange) {
        return sizeChange;
    }

    @Override
    public Node cloneNode(@Nonnull Node node, String newName, Point location) {
        Node newNode = node.clone(node.getCompartment(), newName);
        if (newNode.getKernel() instanceof biouml.standard.type.Compartment) {
            ((Compartment)newNode).clear();
        }
        newNode.setRole(node.getRole());
        newNode.setLocation(location);
        return newNode;
    }

    @Override
    public Node copyNode(@Nonnull Node node, @Nonnull String newName, Compartment newParent, Point location) {
        Base kernel = node.getKernel();
        if (kernel instanceof BaseSupport) {
            DataElement newKernel = ((BaseSupport)kernel).clone(kernel.getOrigin(), newName);
            Node result = node.clone(newParent, newName, (Base)newKernel);
            Role newRole = this.copyRole(node.getRole(), result);
            result.setRole(newRole);
            result.setLocation(location);
            return result;
        }
        throw new IllegalArgumentException("Diagram element " + node.getName() + " can not be copied!");
    }

    @Override
    public Edge createEdge(@Nonnull Node fromNode, @Nonnull Node toNode, String edgeType, Compartment compartment) {
        Compartment origin = Node.findCommonOrigin(toNode, fromNode);
        BaseSupport edgeKernel = null;
        String edgeName = "From " + fromNode.getName() + " to " + toNode.getName();
        Node specieNode = toNode;
        Reaction reaction = DefaultSemanticController.getReactionByNode(fromNode);
        if (reaction == null) {
            reaction = DefaultSemanticController.getReactionByNode(toNode);
            specieNode = fromNode;
        }
        if ("semantic".equals(edgeType)) {
            edgeKernel = new SemanticRelation(null, edgeName);
        } else if ("noteLink".equals(edgeType)) {
            edgeKernel = new Stub.NoteLink(reaction, edgeName);
        } else {
            edgeKernel = new SpecieReference(reaction, edgeName, edgeType);
            ((SpecieReference)edgeKernel).setSpecie(specieNode.getCompleteNameInDiagram());
            reaction.put((SpecieReference)edgeKernel);
        }
        Edge oldEdge = this.findEdge(fromNode, toNode, edgeKernel);
        if (oldEdge == null) {
            Edge edge = new Edge(origin, (Base)edgeKernel, fromNode, toNode);
            return edge;
        }
        return null;
    }

    protected static Reaction getReactionByNode(Node node) {
        Base kernel = node.getKernel();
        if (kernel != null) {
            DataElement reactionDe;
            Object reactionNameObj;
            if (kernel instanceof Reaction) {
                return (Reaction)kernel;
            }
            if (kernel instanceof Stub && kernel.getType().equals("reaction") && (reactionNameObj = node.getAttributes().getValue("completeName")) != null && (reactionDe = CollectionFactory.getDataElement((String)reactionNameObj.toString())) instanceof Reaction) {
                return (Reaction)reactionDe;
            }
        }
        return null;
    }

    @Override
    public Edge findEdge(Node from, Node to, Base kernel) {
        Edge[] edges;
        for (Edge e : edges = from.getEdges()) {
            if (!e.getInput().getCompleteNameInDiagram().equals(from.getCompleteNameInDiagram()) || !e.getOutput().getCompleteNameInDiagram().equals(to.getCompleteNameInDiagram())) continue;
            if (e.getKernel() != null) {
                if (!e.getKernel().getClass().equals(kernel.getClass())) continue;
                if (e.getKernel() instanceof SpecieReference) {
                    if (!((SpecieReference)e.getKernel()).getRole().equals(((SpecieReference)kernel).getRole())) continue;
                    return e;
                }
                return e;
            }
            if (kernel != null) continue;
            return e;
        }
        return null;
    }

    @Override
    public Dimension resize(DiagramElement de, Dimension sizeChange, Dimension offset) {
        return this.resize(de, sizeChange);
    }

    @Override
    public String validateName(String name) {
        return name;
    }

    private Role copyRole(Role oldRole, DiagramElement de) {
        return oldRole instanceof VariableRole ? ((VariableRole)oldRole).clone(de, VariableRole.createName(de, false)) : (oldRole == null ? null : oldRole.clone(de));
    }

    @Override
    public boolean isAcceptableForReaction(Node node) {
        return node.getRole() instanceof VariableRole && !(node.getKernel() instanceof biouml.standard.type.Compartment);
    }
}

