/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramViewBuilder;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.EquivalentNodeGroup;
import biouml.model.GlobalViewOptions;
import biouml.model.Node;
import biouml.model.NodeViewBuilder;
import biouml.model.dynamics.VariableRole;
import biouml.standard.type.Base;
import biouml.standard.type.ImageDescriptor;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import one.util.streamex.StreamEx;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.graph.Path;
import ru.biosoft.graph.PortFinder;
import ru.biosoft.graph.ShapeChanger;
import ru.biosoft.graphics.ArrowView;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.ComplexTextView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.HtmlView;
import ru.biosoft.graphics.ImageView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.PolygonView;
import ru.biosoft.graphics.PolylineView;
import ru.biosoft.graphics.SimplePath;
import ru.biosoft.graphics.TextView;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;

public class DefaultDiagramViewBuilder
implements DiagramViewBuilder {
    protected Logger log = Logger.getLogger(DefaultDiagramViewBuilder.class.getName());
    protected DiagramViewBuilder baseViewBuilder = null;
    protected DiagramViewOptions baseViewOptions = new DiagramViewOptions(null);
    protected Map<Object, String> typeMapping = null;

    @Override
    public DiagramViewOptions createDefaultDiagramViewOptions() {
        return new DiagramViewOptions(null);
    }

    @Override
    public Icon getIcon(Object type) {
        if (type instanceof Class) {
            Icon icon = this.getIcon((Class)type, this.getResourcesRoot());
            if (icon != null) {
                return icon;
            }
            this.log.log(Level.SEVERE, "Image not found for type: " + ((Class)type).getName());
        }
        if (type instanceof String) {
            String imageFile = "resources/" + ((String)type).toLowerCase() + ".gif";
            URL url = this.getIconURL(this.getResourcesRoot(), imageFile);
            if (url != null) {
                return new ImageIcon(url);
            }
            this.log.log(Level.SEVERE, "Image not found for type: " + type);
        }
        return null;
    }

    protected Class<? extends DefaultDiagramViewBuilder> getResourcesRoot() {
        return this.getClass();
    }

    protected Icon getIcon(Class<?> type, Class<? extends DefaultDiagramViewBuilder> resourceRoot) {
        String imageFile;
        URL url;
        String name = type.getName();
        if ((name = name.substring(name.lastIndexOf(".") + 1)).indexOf(36) > 0) {
            name = name.substring(name.indexOf(36) + 1);
        }
        if ((url = this.getIconURL(resourceRoot, imageFile = "resources/" + name.toLowerCase() + ".gif")) != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    protected URL getIconURL(Class<? extends DefaultDiagramViewBuilder> resourceRoot, String relativePath) {
        return resourceRoot.getResource(relativePath);
    }

    @Override
    @Nonnull
    public CompositeView createDiagramView(Diagram diagram, Graphics g) {
        return this.createCompartmentView(diagram, diagram.getViewOptions(), g);
    }

    @Override
    @Nonnull
    public CompositeView createCompartmentView(Compartment compartment, DiagramViewOptions options, Graphics g) {
        boolean notificationEnabled = false;
        if (compartment.isNotificationEnabled()) {
            notificationEnabled = true;
            compartment.setNotificationEnabled(false);
        }
        CompositeView result = null;
        try {
            if (compartment.isUseCustomImage() && (result = this.createImageView(compartment, g)) != null) {
                this.buildNodes(compartment, options, g);
            }
        }
        catch (Exception ex) {
            this.log.info("Error during compartment image creation: name = " + compartment.getCompleteNameInDiagram() + ", error: " + ExceptionRegistry.translateException((Throwable)ex));
        }
        if (result == null) {
            result = this.doCreateCompartmentView(compartment, options, g);
        }
        if (notificationEnabled) {
            compartment.setNotificationEnabled(true);
        }
        return result;
    }

    @Nonnull
    protected CompositeView doCreateCompartmentView(Compartment compartment, DiagramViewOptions options, Graphics g) {
        CompositeView compartmentView = new CompositeView();
        compartment.setView((View)compartmentView);
        boolean showTitle = true;
        if (compartment instanceof Diagram) {
            BoxView stub = new BoxView(options.getDefaultPen(), null, 0, 0, 0, 0);
            stub.setVisible(false);
            stub.setModel((Object)compartment);
            compartmentView.add((View)stub);
            compartmentView.setModel((Object)compartment);
            compartmentView.setActive(true);
        } else {
            CompositeView view = this.createSpecialView(compartment, options, g);
            if (view != null) {
                return view;
            }
            showTitle = this.createCompartmentCoreView(compartmentView, compartment, options, g);
        }
        this.buildNodes(compartment, options, g);
        if (compartment instanceof Diagram && options.isDiagramTitleVisible() || !(compartment instanceof Diagram) && showTitle) {
            ComplexTextView title = new ComplexTextView(compartment.getTitle(), DefaultDiagramViewBuilder.getTitleFont(compartment, options.getDiagramTitleFont()), options.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
            compartmentView.add((View)title, options.getDiagramTitleAlignment(), new Point(5, 5));
        }
        return compartmentView;
    }

    @Nonnull
    public CompositeView createEquivalentNodeGroupView(EquivalentNodeGroup group, DiagramViewOptions options, Graphics g) {
        CompositeView groupView = new CompositeView();
        if (!options.isDesignMode()) {
            Node node = group.getRepresentative();
            if (node != null) {
                this.createNodeCoreView(groupView, node, options, g);
                ComplexTextView title = new ComplexTextView(node.getTitle(), options.getNodeTitleFont(), options.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
                groupView.add((View)title, 79, options.getNodeTitleMargin());
            }
            Iterator<DiagramElement> i = group.iterator();
            while (i.hasNext()) {
                Node n = (Node)i.next();
                n.setView((View)groupView);
                n.setLocation(group.getLocation());
            }
        }
        group.setView((View)groupView);
        groupView.setLocation(group.getLocation());
        groupView.setModel((Object)group);
        groupView.setActive(true);
        return groupView;
    }

    protected void buildNodes(Compartment compartment, DiagramViewOptions options, Graphics g) {
        Node node;
        CompositeView view;
        Compartment c;
        DiagramElement obj;
        Diagram d = Diagram.getDiagram(compartment);
        CompositeView compartmentView = (CompositeView)compartment.getView();
        Set edgeCompartments = ((StreamEx)((StreamEx)compartment.stream(Edge.class).flatMap(Edge::nodes).map(DiagramElement::getCompartment).distinct()).map(cmp -> this.traverseToChild(compartment, (Compartment)((Object)cmp))).nonNull()).toSet();
        for (Compartment c2 : edgeCompartments) {
            CompositeView view2 = this.createCompartmentView(c2, options, g);
            c2.setView((View)view2);
            view2.setVisible(c2.isVisible() || !d.isHideInvisibleElements());
            compartmentView.add((View)view2);
        }
        int edgeInsertPos = compartmentView.size();
        HashSet<Compartment> otherCompartments = new HashSet<Compartment>();
        Iterator iterator = compartment.iterator();
        while (iterator.hasNext()) {
            obj = iterator.next();
            if (!(obj instanceof Compartment) || obj.getKernel() == null || !"compartment".equals(obj.getKernel().getType()) || edgeCompartments.contains((Object)obj)) continue;
            c = (Compartment)obj;
            view = this.createCompartmentView(c, options, g);
            c.setView((View)view);
            view.setVisible(c.isVisible() || !d.isHideInvisibleElements());
            compartmentView.add((View)view);
            otherCompartments.add(c);
        }
        edgeInsertPos += otherCompartments.size();
        iterator = compartment.iterator();
        while (iterator.hasNext()) {
            obj = iterator.next();
            if (!(obj instanceof Compartment) || obj instanceof EquivalentNodeGroup || edgeCompartments.contains((Object)obj) || otherCompartments.contains((Object)obj)) continue;
            c = (Compartment)obj;
            view = this.createCompartmentView(c, options, g);
            c.setView((View)view);
            view.setVisible(c.isVisible() || !d.isHideInvisibleElements());
            compartmentView.add((View)view);
        }
        iterator = compartment.iterator();
        while (iterator.hasNext()) {
            obj = iterator.next();
            if (!(obj instanceof Node) || this.isReaction((node = (Node)obj).getKernel()) || node.getKernel() != null && node.getKernel() instanceof Stub.ConnectionPort) continue;
            if (node instanceof EquivalentNodeGroup) {
                view = this.createEquivalentNodeGroupView((EquivalentNodeGroup)node, options, g);
            } else {
                if (node instanceof Compartment) continue;
                view = this.createNodeView(node, options, g);
            }
            view.setVisible(node.isVisible() || !d.isHideInvisibleElements());
            compartmentView.add((View)view);
        }
        iterator = compartment.iterator();
        while (iterator.hasNext()) {
            obj = iterator.next();
            if (!(obj instanceof Node) || !this.isReaction((node = (Node)obj).getKernel()) && !(node.getKernel() instanceof Stub.ConnectionPort)) continue;
            view = this.createNodeView(node, options, g);
            view.setVisible(node.isVisible() || !d.isHideInvisibleElements());
            compartmentView.add((View)view);
        }
        for (Edge edge : compartment.stream(Edge.class)) {
            CompositeView view3 = this.createEdgeView(edge, options, g);
            edge.setView((View)view3);
            view3.setVisible(!d.isHideInvisibleElements() || edge.nodes().allMatch(Node::isVisible));
            compartmentView.insert((View)view3, edgeInsertPos);
        }
    }

    private Compartment traverseToChild(Compartment compartment, Compartment child) {
        if (child == compartment) {
            return null;
        }
        try {
            while (child.getCompartment() != compartment) {
                child = child.getCompartment();
            }
            return child;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean isReaction(Base kernel) {
        return kernel == null ? false : "reaction".equals(kernel.getType());
    }

    public CompositeView createImageView(Node node, Graphics g) {
        CompositeView cView = null;
        cView = node.getImage().getImageView((Graphics2D)g);
        if (cView != null) {
            return cView;
        }
        ImageDescriptor imageDescr = node.getImage();
        Image image = imageDescr.getImage();
        if (image == null) {
            return null;
        }
        Dimension size = node.getShapeSize();
        if (size.width == 0 && size.height == 0) {
            size = imageDescr.getOriginalSize();
        }
        ImageView imageView = new ImageView(image, node.getLocation().x, node.getLocation().y, size.width, size.height);
        imageView.setPath(imageDescr.getPath().toString());
        if (!size.equals(imageDescr.getOriginalSize())) {
            imageView.setToScale((double)((float)size.width / (float)imageDescr.getOriginalSize().width), (double)((float)size.height / (float)imageDescr.getOriginalSize().height));
        }
        cView = new CompositeView();
        cView.add((View)imageView);
        cView.setModel((Object)node);
        cView.setActive(true);
        cView.setLocation(node.getLocation());
        node.setView((View)cView);
        return cView;
    }

    @Override
    @Nonnull
    public CompositeView createNodeView(Node node, DiagramViewOptions options, Graphics g) {
        CompositeView view = this.createSpecialView(node, options, g);
        if (view != null) {
            return view;
        }
        boolean addTitle = false;
        try {
            if (node.isUseCustomImage()) {
                view = this.createImageView(node, g);
                addTitle = true;
            }
        }
        catch (Exception ex) {
            this.log.info("Error during node image creation: name = " + node.getCompleteNameInDiagram() + ", error: " + ExceptionRegistry.translateException((Throwable)ex));
        }
        if (view == null) {
            view = new CompositeView();
            addTitle = this.createNodeCoreView(view, node, options, g);
        }
        if (addTitle) {
            this.createNodeTitle(view, node, options, g);
        }
        view.setModel((Object)node);
        view.setActive(true);
        view.setLocation(node.getLocation());
        node.setView((View)view);
        return view;
    }

    private CompositeView createSpecialView(Node node, DiagramViewOptions options, Graphics g) {
        DynamicProperty dp = node.getAttributes().getProperty("nodeViewBuilder");
        if (dp != null) {
            try {
                return ((NodeViewBuilder)dp.getValue()).createNodeView(node, options, g);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    protected void createNodeTitle(CompositeView view, Node node, DiagramViewOptions options, Graphics g) {
        ComplexTextView title = new ComplexTextView(node.getTitle(), DefaultDiagramViewBuilder.getTitleFont(node, options.getNodeTitleFont()), options.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
        Diagram diagram = Diagram.optDiagram(node);
        if (diagram != null && diagram.getLabelLayouter() == null && Double.isNaN(node.getTitleAngle())) {
            view.add((View)title, 79, options.getNodeTitleMargin());
        } else {
            CompositeView parentView = (CompositeView)node.getCompartment().getView();
            if (parentView != null) {
                node.setTitleView((View)title);
                Rectangle titleBounds = title.getBounds();
                Rectangle nodeBounds = view.getBounds();
                Point point = new Point();
                point.x = node.getLocation().x - titleBounds.x + (nodeBounds.width - titleBounds.width) / 2 - (int)((double)node.getTitleOffset() * Math.cos(node.getTitleAngle()));
                point.y = node.getLocation().y - titleBounds.y + (nodeBounds.height - titleBounds.height) / 2 - (int)((double)node.getTitleOffset() * Math.sin(node.getTitleAngle()));
                parentView.add((View)title, 8, point);
            }
        }
    }

    @Override
    public boolean createNodeCoreView(CompositeView container, Node node, DiagramViewOptions options, Graphics g) {
        if (node.getKernel() instanceof Stub.Note) {
            return this.createNoteView(container, node, options);
        }
        if ("edge-end-stub".equals(node.getKernel().getType())) {
            container.add((View)new BoxView(null, null, 0, 0, 1, 1));
            return false;
        }
        String name = node.getKernel().getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        TextView type = new TextView(name, options.getDefaultFont(), g);
        type.setLocation(5, 5);
        BoxView bound = new BoxView(DefaultDiagramViewBuilder.getBorderPen(node, options.getDefaultPen()), null, 0, 0, type.getBounds().width + 10, type.getBounds().height + 10);
        container.add((View)bound);
        container.add((View)type);
        return true;
    }

    public boolean createNoteView(CompositeView container, Node node, DiagramViewOptions options) {
        Stub.Note note = (Stub.Note)node.getKernel();
        Dimension shapeSize = node.getShapeSize();
        if (shapeSize != null && note.isBackgroundVisible()) {
            shapeSize = (Dimension)node.getShapeSize().clone();
            shapeSize.width -= options.getNoteMargin().x * 2;
            shapeSize.height -= options.getNoteMargin().y * 2;
        }
        HtmlView view = new HtmlView(node.getTitle(), DefaultDiagramViewBuilder.getTitleFont(node, options.getNodeTitleFont()), new Point(0, 0), shapeSize);
        if (!note.isBackgroundVisible()) {
            container.add((View)view);
            return false;
        }
        int height = view.getBounds().height + options.getNoteMargin().y * 2;
        int delta = Math.min(15, height / 2);
        int width = view.getBounds().width + options.getNoteMargin().x * 2 + delta;
        Brush brush = DefaultDiagramViewBuilder.getBrush(node, options.getNoteBrush());
        Pen pen = DefaultDiagramViewBuilder.getBorderPen(node, options.getNodePen());
        PolygonView border = new PolygonView(pen, brush);
        border.addPoint(0, 0);
        border.addPoint(width - delta, 0);
        border.addPoint(width, delta);
        border.addPoint(width, height);
        border.addPoint(0, height);
        container.add((View)border);
        container.add((View)view, 28, options.getNoteMargin());
        PolygonView edge = new PolygonView(null, brush);
        edge.addPoint(width - delta, 0);
        edge.addPoint(width - delta, delta);
        edge.addPoint(width, delta);
        container.add((View)edge);
        PolylineView edgeLine = new PolylineView(pen);
        edgeLine.addPoint(width - delta, 0);
        edgeLine.addPoint(width - delta, delta);
        edgeLine.addPoint(width, delta);
        container.add((View)edgeLine);
        return false;
    }

    @Override
    @Nonnull
    public CompositeView createEdgeView(Edge edge, DiagramViewOptions options, Graphics g) {
        CompositeView view = new CompositeView();
        Pen pen = DefaultDiagramViewBuilder.getBorderPen(edge, options.getDefaultPen());
        if (edge.getPath() == null) {
            Diagram.getDiagram(edge).getType().getSemanticController().recalculateEdgePath(edge);
        }
        SimplePath path = edge.getSimplePath();
        ArrowView arrow = new ArrowView(pen, null, path, 0, 1);
        arrow.setModel((Object)edge);
        arrow.setActive(true);
        view.add((View)arrow);
        view.setModel((Object)edge);
        view.setActive(false);
        return view;
    }

    public boolean createCompartmentCoreView(CompositeView container, Compartment compartment, DiagramViewOptions options, Graphics g) {
        BoxView shapeView = null;
        Dimension shapeSize = compartment.getShapeSize();
        RectangularShape shape = null;
        switch (compartment.getShapeType()) {
            case 1: {
                float arc = (float)(Math.min(shapeSize.width, shapeSize.height) * 20) / 100.0f;
                shape = new RoundRectangle2D.Float(0.0f, 0.0f, shapeSize.width, shapeSize.height, arc, arc);
                break;
            }
            case 2: {
                shape = new Ellipse2D.Float(0.0f, 0.0f, shapeSize.width, shapeSize.height);
                break;
            }
            default: {
                shape = new Rectangle(0, 0, shapeSize.width, shapeSize.height);
            }
        }
        shapeView = new BoxView(DefaultDiagramViewBuilder.getBorderPen(compartment, new Pen(1.0f, Color.black)), DefaultDiagramViewBuilder.getBrush(compartment, new Brush((Paint)Color.white)), shape);
        shapeView.setLocation(compartment.getLocation());
        container.add((View)shapeView);
        container.setModel((Object)compartment);
        shapeView.setModel((Object)compartment);
        shapeView.setActive(true);
        return true;
    }

    @Override
    public boolean calculateInOut(Edge edge, Point in, Point out) {
        return this.calculateInOut(edge, in, out, 1, 3);
    }

    protected boolean calculateInOut(Edge edge, Point in, Point out, int offsetStart, int offsetEnd) {
        Rectangle inputBounds = this.getNodeBounds(edge.getInput());
        Rectangle outputBounds = this.getNodeBounds(edge.getOutput());
        if (inputBounds.x >= outputBounds.x && inputBounds.x <= outputBounds.x + outputBounds.width && inputBounds.y >= outputBounds.y && inputBounds.y <= outputBounds.y + outputBounds.height || outputBounds.x >= inputBounds.x && outputBounds.x <= inputBounds.x + inputBounds.width && outputBounds.y >= inputBounds.y && outputBounds.y <= inputBounds.y + inputBounds.height) {
            in.x = inputBounds.x + inputBounds.width / 2;
            in.y = inputBounds.y + inputBounds.height / 2;
            out.x = outputBounds.x + outputBounds.width / 2;
            out.y = outputBounds.y + outputBounds.height / 2;
            return false;
        }
        Path path = edge.getPath();
        if (path == null || path.npoints <= 2) {
            DefaultDiagramViewBuilder.calcAttachmentPoints(inputBounds, outputBounds, in, out, offsetStart, offsetEnd);
        } else {
            DefaultDiagramViewBuilder.calcAttachmentPoints(inputBounds, new Rectangle(path.xpoints[1], path.ypoints[1], 1, 1), in, new Point(), 1, 1);
            DefaultDiagramViewBuilder.calcAttachmentPoints(new Rectangle(path.xpoints[path.npoints - 2], path.ypoints[path.npoints - 2], 1, 1), outputBounds, new Point(), out, 1, 3);
        }
        return true;
    }

    @Override
    public Rectangle getNodeBounds(Node node) {
        CompositeView view;
        Diagram diagram = Diagram.getDiagram(node);
        DiagramViewOptions viewOptions = diagram.getViewOptions();
        Graphics2D graphics = ApplicationUtils.getGraphics();
        Dimension shapeSize = null;
        if (node instanceof Compartment) {
            view = new CompositeView();
            this.createCompartmentCoreView(view, (Compartment)node, viewOptions, graphics);
        } else {
            view = this.createNodeView(node, viewOptions, graphics);
        }
        shapeSize = view.getBounds().getSize();
        return new Rectangle(node.getLocation(), shapeSize);
    }

    private static int proportion(int L, int l) {
        return (int)Math.round((double)(L - l) * Math.log(L) * (double)l / (double)L / 30.0);
    }

    private static int center(int start1, int end1, int start2, int end2) {
        if (start1 < end2 && start2 < end1) {
            return (Math.max(start1, start2) + Math.min(end1, end2)) / 2;
        }
        return Integer.MIN_VALUE;
    }

    protected static void calcAttachmentPoints(Rectangle r1, Rectangle r2, Point p1, Point p2, int offsetStart, int offsetEnd) {
        int x = r2.x;
        r2.x = r1.x;
        if (r1.intersects(r2)) {
            r2.x = x;
            if (r1.x < r2.x) {
                p1.x = r1.x + r1.width + offsetStart;
                p2.x = r2.x - offsetEnd;
            } else {
                p2.x = r2.x + r2.width + offsetEnd;
                p1.x = r1.x - offsetStart;
            }
            int center = DefaultDiagramViewBuilder.center(r1.y, r1.y + r1.height, r2.y, r2.y + r2.height);
            if (center != Integer.MIN_VALUE) {
                p1.y = center;
                p2.y = center;
            } else {
                p1.y = r1.y + r1.height / 2;
                p2.y = r2.y + r2.height / 2;
                if (r1.y < r2.y) {
                    int L = Math.max(r1.y + r1.height, r2.y + r2.height) - r1.y;
                    p1.y += DefaultDiagramViewBuilder.proportion(L, r1.height);
                    p2.y -= DefaultDiagramViewBuilder.proportion(L, r2.height);
                } else {
                    int L = Math.max(r1.y + r1.height, r2.y + r2.height) - r2.y;
                    p1.y -= DefaultDiagramViewBuilder.proportion(L, r1.height);
                    p2.y += DefaultDiagramViewBuilder.proportion(L, r2.height);
                }
            }
        } else {
            r2.x = x;
            if (r1.y < r2.y) {
                p1.y = r1.y + r1.height + offsetStart;
                p2.y = r2.y - offsetEnd;
            } else {
                p2.y = r2.y + r2.height + offsetEnd;
                p1.y = r1.y - offsetStart;
            }
            int center = DefaultDiagramViewBuilder.center(r1.x, r1.x + r1.width, r2.x, r2.x + r2.width);
            if (center != Integer.MIN_VALUE) {
                p1.x = center;
                p2.x = center;
            } else {
                p1.x = r1.x + r1.width / 2;
                p2.x = r2.x + r2.width / 2;
                if (r1.x < r2.x) {
                    int L = Math.max(r1.x + r1.width, r2.x + r2.width) - r1.x;
                    p1.x += DefaultDiagramViewBuilder.proportion(L, r1.width);
                    p2.x -= DefaultDiagramViewBuilder.proportion(L, r2.width);
                } else {
                    int L = Math.max(r1.x + r1.width, r2.x + r2.width) - r2.x;
                    p1.x -= DefaultDiagramViewBuilder.proportion(L, r1.width);
                    p2.x += DefaultDiagramViewBuilder.proportion(L, r2.width);
                }
            }
        }
    }

    @Override
    public void setBaseViewBuilder(DiagramViewBuilder baseViewBuilder) {
        this.baseViewBuilder = baseViewBuilder;
    }

    @Override
    public void setBaseViewOptions(DiagramViewOptions baseViewOptions) {
        this.baseViewOptions = baseViewOptions;
    }

    @Override
    public void setTypeMapping(Map<Object, String> typeMapping) {
        this.typeMapping = typeMapping;
    }

    public static boolean hasTitle(Node node) {
        return node.getTitle() != null && !node.getTitle().isEmpty();
    }

    @Override
    public PortFinder getPortFinder(Node node) {
        return null;
    }

    @Override
    public ShapeChanger getShapeChanger(Node node) {
        return null;
    }

    public static boolean hasDefaultStyle(DiagramElement de) {
        return de.getPredefinedStyle().equals("Default");
    }

    public static ColorFont getTitleFont(DiagramElement de, ColorFont defaultFont) {
        return DefaultDiagramViewBuilder.hasDefaultStyle(de) ? defaultFont : de.getCustomStyle().getFont();
    }

    public static Pen getBorderPen(DiagramElement de, Pen defaultPen) {
        return DefaultDiagramViewBuilder.isHighlighted(de) ? DefaultDiagramViewBuilder.getHighlightPen(de) : (DefaultDiagramViewBuilder.hasDefaultStyle(de) ? defaultPen : de.getCustomStyle().getPen());
    }

    public static Brush getBrush(DiagramElement de, Brush defaultBrush) {
        return DefaultDiagramViewBuilder.hasDefaultStyle(de) ? new Brush(defaultBrush.getPaint()) : de.getCustomStyle().getBrush();
    }

    private static boolean isHighlighted(DiagramElement de) {
        return de.getAttributes().hasProperty("highlight") && Boolean.parseBoolean(de.getAttributes().getValueAsString("highlight"));
    }

    private static Pen getHighlightPen(DiagramElement de) {
        Diagram diagram = Diagram.getDiagram(de);
        return diagram.getViewOptions().getHighlightPen();
    }

    public View createPinView() {
        int[] xPoints = new int[]{0, 2, 1, 2, 6, 3, 2, 0};
        int[] yPoints = new int[]{6, 4, 3, 0, 4, 5, 4, 6};
        PolygonView polygonView = new PolygonView(new Pen(), new Brush((Paint)Color.BLACK), xPoints, yPoints);
        return polygonView;
    }

    @Override
    public Point getNearestNodePoint(Point p, Node node) {
        Rectangle r = this.getNodeBounds(node);
        double w = r.getWidth();
        double h = r.getHeight();
        int x = r.x;
        int y = r.y;
        Point[] np = new Point[4];
        if (p.y < y) {
            np[0] = new Point(x, y);
            np[2] = new Point((int)((double)x + w), y);
        } else if ((double)p.y > (double)y + h) {
            np[0] = new Point(x, (int)((double)y + h));
            np[2] = new Point((int)((double)x + w), (int)((double)y + h));
        } else {
            np[0] = new Point(x, p.y);
            np[2] = new Point((int)((double)x + w), p.y);
        }
        if (p.x < x) {
            np[1] = new Point(x, y);
            np[3] = new Point(x, (int)((double)y + h));
        } else if ((double)p.x > (double)x + w) {
            np[1] = new Point((int)((double)x + w), y);
            np[3] = new Point((int)((double)x + w), (int)((double)y + h));
        } else {
            np[1] = new Point(p.x, y);
            np[3] = new Point(p.x, (int)((double)y + h));
        }
        Point nearest = p;
        double dist = Double.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            double di = (np[i].x - p.x) * (np[i].x - p.x) + (np[i].y - p.y) * (np[i].y - p.y);
            if (!(dist > di)) continue;
            dist = di;
            nearest = np[i];
        }
        return nearest;
    }

    @Override
    public boolean forbidCustomImage(Node node) {
        return !(node.getRole() instanceof VariableRole);
    }
}

