/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.EquivalentNodeGroup;
import biouml.model.Node;
import biouml.model.Role;
import biouml.standard.type.Base;
import com.developmentontheedge.beans.DPSProperties;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.ClassIcon;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataCollectionEvent;
import ru.biosoft.access.core.DataCollectionInfo;
import ru.biosoft.access.core.DataCollectionListener;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementDescriptor;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.DataElementPutException;
import ru.biosoft.access.core.VectorDataCollection;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.exception.LoggedClassCastException;
import ru.biosoft.exception.LoggedException;
import ru.biosoft.util.TextUtil;

@ClassIcon(value="resources/compartment.gif")
@PropertyName(value="Compartment")
@PropertyDescription(value="Compartment is a container to group nodes and edges between them. For example it may correpsond to cell or organism compartment.")
public class Compartment
extends Node
implements DataCollection<DiagramElement> {
    protected static final Logger log = Logger.getLogger(Compartment.class.getName());
    protected int shapeType;
    private DataElementPath completeName = null;
    protected Map<Base, List<DiagramElement>> kernelMap = new HashMap<Base, List<DiagramElement>>();
    public static final int SHAPE_RECTANGLE = 0;
    public static final int SHAPE_ROUND_RECTANGLE = 1;
    public static final int SHAPE_ELLIPSE = 2;
    protected VectorDataCollection<DiagramElement> collection;

    public Compartment(DataCollection<?> parent, String id, Base kernel) {
        super(parent, id, kernel);
        DPSProperties props = (DPSProperties)new DPSProperties(this.getAttributes()).clone();
        props.setProperty("name", id);
        this.collection = new VectorDataCollection(parent, (Properties)props);
        this.setShapeSize(new Dimension(150, 150));
    }

    public Compartment(DataCollection<?> parent, Base kernel) {
        this(parent, kernel.getName(), kernel);
    }

    public Node findNode(@Nonnull String id) {
        Object[] path = id.split("\\.");
        if (path.length == 1) {
            DiagramElement node = this.get(id);
            if (node instanceof Node) {
                return (Node)node;
            }
            Iterator<DiagramElement> iterator = this.iterator();
            while (iterator.hasNext()) {
                Node tmp;
                DiagramElement obj = iterator.next();
                if (obj instanceof EquivalentNodeGroup) {
                    if (!((obj = ((EquivalentNodeGroup)obj).get(id)) instanceof Node)) continue;
                    node = obj;
                    break;
                }
                if (!(obj instanceof Compartment) || (tmp = ((Compartment)obj).findNode(id)) == null) continue;
                node = tmp;
                break;
            }
            return (Node)node;
        }
        try {
            DiagramElement comp = (DiagramElement)((Object)StreamEx.of((Object[])path).foldLeft((Object)this, (c, name) -> ((Compartment)c.cast(Compartment.class)).get((String)name)));
            return comp == null ? null : (Node)comp.cast(Node.class);
        }
        catch (NullPointerException | LoggedClassCastException e) {
            return null;
        }
    }

    public DiagramElement findDiagramElement(String id) {
        if (id.indexOf(46) == -1) {
            DiagramElement diagramElement = this.get(id);
            if (diagramElement == null) {
                Iterator<DiagramElement> iterator = this.iterator();
                while (iterator.hasNext()) {
                    DiagramElement tmp;
                    DiagramElement obj = iterator.next();
                    if (obj instanceof EquivalentNodeGroup) {
                        if ((obj = ((EquivalentNodeGroup)obj).get(id)) == null) continue;
                        diagramElement = obj;
                        break;
                    }
                    if (!(obj instanceof Compartment) || (tmp = ((Compartment)obj).findDiagramElement(id)) == null) continue;
                    diagramElement = tmp;
                    break;
                }
            }
            return diagramElement;
        }
        return this.getDiagramElement(id);
    }

    public DiagramElement getDiagramElement(String completeNameInDiagram) {
        DiagramElement element;
        if (completeNameInDiagram.isEmpty()) {
            return this;
        }
        String[] path = TextUtil.split((String)completeNameInDiagram, (char)'.');
        Compartment comp = this;
        for (int i = 0; i < path.length - 1 && comp.contains(path[i]) && (element = comp.get(path[i])) instanceof Compartment; ++i) {
            comp = (Compartment)comp.get(path[i]);
        }
        return comp.get(path[path.length - 1]);
    }

    public Object findObject(String id) throws Exception {
        DiagramElement de = this.get(id);
        if (de == null) {
            Iterator<DiagramElement> iterator = this.iterator();
            while (iterator.hasNext()) {
                DiagramElement obj = iterator.next();
                if (obj instanceof EquivalentNodeGroup) {
                    if ((obj = ((EquivalentNodeGroup)obj).get(id)) == null) continue;
                    de = obj;
                    break;
                }
                if (obj instanceof Compartment) {
                    Object tmp = ((Compartment)obj).findObject(id);
                    if (tmp == null) continue;
                    return tmp;
                }
                Role role = obj.getRole();
                if (!(role instanceof DataElement) || !((DataElement)role).getName().equals(id)) continue;
                return role;
            }
        }
        return de;
    }

    public boolean containsKernel(Base kernel) {
        return this.kernelMap.containsKey(kernel);
    }

    public StreamEx<Node> getKernelNodes(Base kernel) {
        List<DiagramElement> list = this.kernelMap.get(kernel);
        if (list == null) {
            return StreamEx.empty();
        }
        return StreamEx.of(list).select(Node.class);
    }

    @PropertyName(value="Shape type")
    public int getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(int shapeType) {
        int oldValue = this.shapeType;
        this.shapeType = shapeType;
        this.firePropertyChange("shapeType", oldValue, shapeType);
    }

    public DataCollectionInfo getInfo() {
        return this.collection.getInfo();
    }

    public int getSize() {
        return this.collection.getSize();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Nonnull
    public Class<? extends DiagramElement> getDataElementType() {
        return Compartment.class;
    }

    public boolean isMutable() {
        return this.collection.isMutable();
    }

    public boolean contains(String name) {
        return this.collection.contains(name);
    }

    public boolean contains(DataElement de) {
        return this.contains(de.getName());
    }

    @Nonnull
    public Iterator<DiagramElement> iterator() {
        return this.collection.iterator();
    }

    @Nonnull
    public List<String> getNameList() {
        return this.collection.getNameList();
    }

    public DiagramElement get(String name) {
        return (DiagramElement)this.collection.get(name);
    }

    public DataElementDescriptor getDescriptor(String name) {
        return this.collection.getDescriptor(name);
    }

    public DiagramElement put(DiagramElement obj) throws DataElementPutException {
        if (obj.getName() == null || obj.getName().isEmpty()) {
            throw new DataElementPutException((Throwable)new Exception("Element has empty name"), this.getCompletePath().getChildPath(new String[]{""}));
        }
        if (this.collection.get(obj.getName()) == obj) {
            return obj;
        }
        this.putKernel(obj, obj.getKernel());
        if (obj instanceof Edge) {
            Edge edge = (Edge)obj;
            edge.nodes().forEach(n -> n.addEdge(edge));
        }
        try {
            DiagramElement de = (DiagramElement)this.collection.put((DataElement)obj);
            Diagram d = Diagram.getDiagram(this);
            if (d != null) {
                if (obj instanceof Compartment) {
                    d.register(obj.recursiveStream().map(n -> n.getName()).toSet());
                } else {
                    d.register(obj.getName());
                }
            }
            return de;
        }
        catch (DataElementPutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataElementPutException((Throwable)e, this.getCompletePath().getChildPath(new String[]{obj.getName()}));
        }
    }

    private void putKernel(DiagramElement obj, Base kernel) {
        if (kernel != null) {
            List<DiagramElement> values = this.kernelMap.get(kernel);
            if (values == null) {
                this.kernelMap.put(kernel, Collections.singletonList(obj));
            } else {
                if (!(values instanceof ArrayList)) {
                    values = new ArrayList<DiagramElement>(values);
                    this.kernelMap.put(kernel, values);
                }
                values.add(obj);
            }
        }
    }

    public void remove(String name) throws Exception {
        Diagram d;
        if (name == null) {
            return;
        }
        DiagramElement de = (DiagramElement)this.collection.get(name);
        if (de instanceof Edge) {
            Edge edge = (Edge)de;
            this.removeKernel(de, edge.getKernel());
            edge.nodes().forEach(n -> n.removeEdge(edge));
        }
        if (de instanceof Node) {
            this.removeKernel(de, ((Node)de).getKernel());
        }
        if ((d = Diagram.getDiagram(this)) != null) {
            if (de instanceof Compartment) {
                d.deregister(de.recursiveStream().map(el -> el.getName()).toSet());
            } else {
                d.deregister(name);
            }
        }
        this.collection.remove(name);
    }

    private void removeKernel(DiagramElement obj, Base kernel) {
        if (kernel != null) {
            List<DiagramElement> values = this.kernelMap.get(kernel);
            if (values == null) {
                log.warning("KernelMap error");
            } else if (values.size() == 1 && values.contains((Object)obj)) {
                this.kernelMap.remove(kernel);
            } else {
                values.remove((Object)obj);
            }
        }
    }

    public void addDataCollectionListener(DataCollectionListener l) {
        this.collection.addDataCollectionListener(l);
    }

    public void removeDataCollectionListener(DataCollectionListener l) {
        this.collection.removeDataCollectionListener(l);
    }

    @Nonnull
    public DataElementPath getCompletePath() {
        if (this.completeName == null) {
            DataCollection origin = this.getOrigin();
            this.completeName = (origin == null ? DataElementPath.EMPTY_PATH : origin.getCompletePath()).getChildPath(new String[]{this.getName()});
        }
        return this.completeName;
    }

    public void setOrigin(DataCollection origin) {
        super.setOrigin(origin);
        this.completeName = null;
    }

    public void close() throws Exception {
        this.collection.close();
    }

    public void release(String dataElementName) {
    }

    public DataElement getFromCache(String dataElementName) {
        return null;
    }

    public void setNotificationEnabled(boolean notificationEnabled) {
        super.setNotificationEnabled(notificationEnabled);
        this.collection.setNotificationEnabled(notificationEnabled);
    }

    public void setPropagationEnabled(boolean propagationEnabled) {
        super.setPropagationEnabled(propagationEnabled);
        this.collection.setPropagationEnabled(propagationEnabled);
    }

    public void propagateElementWillChange(DataCollection<?> source, DataCollectionEvent primaryEvent) {
        this.collection.propagateElementWillChange(source, primaryEvent);
    }

    public void propagateElementChanged(DataCollection<?> source, DataCollectionEvent primaryEvent) {
        this.collection.propagateElementChanged(source, primaryEvent);
    }

    @Override
    @Nonnull
    public Compartment clone(Compartment newParent, String newName, Base newKernel) throws IllegalArgumentException {
        if (newParent == this) {
            throw new IllegalArgumentException("Can not clone compartment into itself, compartment=" + (Object)((Object)newParent));
        }
        Compartment compartment = new Compartment(newParent, newName, newKernel);
        compartment.setNotificationEnabled(false);
        this.doClone(compartment);
        compartment.setNotificationEnabled(this.isNotificationEnabled());
        return compartment;
    }

    @Override
    @Nonnull
    public Compartment clone(Compartment newParent, String newName) throws IllegalArgumentException {
        return this.clone(newParent, newName, this.getKernel());
    }

    protected void doClone(Compartment compartment) {
        try {
            compartment.setShapeType(this.getShapeType());
            compartment.setShapeSize(this.getShapeSize());
            compartment.setVisible(this.isVisible());
            this.stream(Node.class).map(node -> node.clone(compartment, node.getName())).forEach(compartment::put);
            this.stream(Edge.class).map(edge -> edge.clone(compartment, edge.getName())).forEach(compartment::put);
            super.doClone(compartment);
        }
        catch (Exception exc) {
            log.log(Level.SEVERE, "Cloning compartment error", exc);
        }
    }

    public static DiagramElement findNode(Compartment compartment, String name) {
        return ((StreamEx)compartment.recursiveStream().select(Compartment.class).map(c -> c.get(name)).nonNull()).findFirst().orElse(null);
    }

    public Node[] getNodes() {
        return (Node[])this.stream(Node.class).toArray(Node[]::new);
    }

    @Nonnull
    public List<Node> getNodesWithKernel(Base kernel) {
        return (List)((StreamEx)this.stream(Node.class).filter(n -> {
            Base k = n.getKernel();
            return k != null && k.getCompletePath().equals((Object)kernel.getCompletePath());
        })).collect(Collectors.toList());
    }

    public boolean isShapeTypeHidden() {
        return !(this.getKernel() instanceof biouml.standard.type.Compartment);
    }

    public String[] getAvailableShapes() {
        return new String[]{"rectangle", "round rectangle", "ellipse"};
    }

    public boolean isAcceptable(Class<? extends DataElement> clazz) {
        return DiagramElement.class.isAssignableFrom(clazz);
    }

    public boolean isValid() {
        return this.collection.isValid();
    }

    public void visitEdges(Consumer<Edge> visitor) {
        Iterator<DiagramElement> iterator = this.iterator();
        while (iterator.hasNext()) {
            DiagramElement de = iterator.next();
            if (de instanceof Compartment) {
                ((Compartment)de).visitEdges(visitor);
                continue;
            }
            if (!(de instanceof Edge)) continue;
            visitor.accept((Edge)de);
        }
    }

    public void reinitialize() throws LoggedException {
        this.collection.reinitialize();
    }

    public void clear() {
        for (String name : this.collection.names().collect(Collectors.toList())) {
            try {
                this.remove(name);
            }
            catch (Exception e) {
                throw ExceptionRegistry.translateException((Throwable)e);
            }
        }
    }

    public StreamEx<DiagramElement> stream() {
        if (this.isEmpty()) {
            return StreamEx.empty();
        }
        return StreamEx.of((Stream)this.names()).map(name -> {
            try {
                return this.get((String)name);
            }
            catch (Exception e) {
                throw ExceptionRegistry.translateException((Throwable)e);
            }
        });
    }

    public <TT extends DiagramElement> StreamEx<TT> stream(Class<TT> elementClass) {
        return this.stream().select(elementClass);
    }
}

