/*
 * Decompiled with CFR 0.152.
 */
package biouml.model;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramFilter;
import biouml.model.EquivalentNodeGroup;
import biouml.model.Node;
import com.developmentontheedge.beans.Option;
import java.util.Iterator;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;

public abstract class AbstractFilter
extends Option
implements DiagramFilter {
    private boolean enabled = false;
    protected boolean loading = false;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        this.enabled = enabled;
        this.firePropertyChange("enabled", oldValue, enabled);
    }

    @Override
    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Object getProperties() {
        return null;
    }

    @Override
    public void apply(Compartment diagram) {
        if (!this.isEnabled()) {
            return;
        }
        Iterator<DiagramElement> iterator = diagram.iterator();
        while (iterator.hasNext()) {
            DiagramElement de = iterator.next();
            if (de instanceof Compartment && !(de instanceof EquivalentNodeGroup)) {
                this.apply((Compartment)de);
                continue;
            }
            if (!(de instanceof Node)) continue;
            this.processNode((Node)de);
        }
    }

    @Override
    public void restoreView(Compartment diagram) {
        diagram.recursiveStream().forEach(this::restoreView);
    }

    protected abstract void processNode(Node var1);

    protected void restoreView(DiagramElement de) {
        CompositeView view = (CompositeView)de.getView();
        de.getView().setVisible(true);
        View highlighter = view.elementAt(0);
        if (highlighter.getModel() instanceof DiagramFilter) {
            view.remove(highlighter);
        }
    }

    @Override
    public void setDiagram(Diagram diagram) {
    }

    @Override
    public DiagramFilter clone() {
        try {
            return (DiagramFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

