/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.print;

import com.developmentontheedge.print.FooterFormat;
import com.developmentontheedge.print.JPrintableComponent;
import com.developmentontheedge.print.PreviewDialog;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class PrintManager {
    protected static final Logger log = Logger.getLogger(PrintManager.class.getName());
    private PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage(new FooterFormat());
    private static PrintManager instance = null;

    private PrintManager() {
    }

    public static PrintManager getPrintManager() {
        if (instance == null) {
            instance = new PrintManager();
        }
        return instance;
    }

    public boolean print(JComponent comp) {
        PrinterJob job = PrinterJob.getPrinterJob();
        JPrintableComponent pageable = new JPrintableComponent(comp, this.pageFormat);
        job.setPageable(pageable);
        try {
            if (job.printDialog()) {
                job.print();
                return true;
            }
        }
        catch (PrinterException e) {
            log.log(Level.SEVERE, "Printing error", e);
        }
        return false;
    }

    public void preview(JComponent comp) {
        PreviewDialog previewDialog = new PreviewDialog(comp);
        previewDialog.doModal();
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }
}

