/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.print;

import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.print.JPrintableComponent;
import com.developmentontheedge.print.PagePreview;
import com.developmentontheedge.print.PrintManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class PreviewDialog
extends JDialog {
    private JComponent componentToPreview = null;
    private JComponent toolbar = null;
    private JComponent previewPanel = null;

    public PreviewDialog(JComponent comp) {
        super(Application.getApplicationFrame(), "Print Preview", true);
        this.componentToPreview = comp;
        this.initContent();
    }

    public void doModal() {
        this.pack();
        ApplicationUtils.moveToCenter(this);
        this.setVisible(true);
        this.dispose();
    }

    protected void initContent() {
        this.toolbar = this.createToolbar();
        this.previewPanel = this.createPreviewPanel();
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.toolbar, "North");
        content.add((Component)this.previewPanel, "Center");
        this.setContentPane(content);
    }

    protected JComponent createToolbar() {
        JPanel toolbar = new JPanel(new FlowLayout(0));
        JButton next = new JButton("Next");
        JButton prev = new JButton("Previous");
        JButton print = new JButton("Print...");
        JButton setup = new JButton("Setup...");
        JButton close = new JButton("Close");
        next.setEnabled(false);
        prev.setEnabled(false);
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean succes = PrintManager.getPrintManager().print(PreviewDialog.this.componentToPreview);
                if (succes) {
                    PreviewDialog.this.setVisible(false);
                }
            }
        });
        setup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Action printSetupAction = null;
                try {
                    printSetupAction = Application.getActionManager().getAction("Print setup");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (printSetupAction != null) {
                    printSetupAction.actionPerformed(evt);
                    PreviewDialog.this.initContent();
                    PreviewDialog.this.pack();
                    ApplicationUtils.moveToCenter(PreviewDialog.this);
                }
            }
        });
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.setVisible(false);
            }
        });
        toolbar.add(print);
        toolbar.add(setup);
        toolbar.add(close);
        return toolbar;
    }

    protected JComponent createPreviewPanel() {
        PageFormat pageFormat = PrintManager.getPrintManager().getPageFormat();
        JPrintableComponent pageable = new JPrintableComponent(this.componentToPreview, pageFormat);
        JPanel previewPanel = new JPanel();
        GridLayout layout = new GridLayout(pageable.getNumberOfPages(), 0);
        layout.setHgap(10);
        layout.setVgap(10);
        previewPanel.setLayout(layout);
        previewPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (int i = 0; i < pageable.getNumberOfPages(); ++i) {
            PageFormat format = pageable.getPageFormat(i);
            PagePreview page = new PagePreview(pageable, format, i);
            previewPanel.add(page);
        }
        JScrollPane scrollPane = new JScrollPane(previewPanel);
        int width = (int)pageFormat.getWidth() + 23;
        if (pageable.getNumberOfPages() > 1) {
            Integer scrWidth = (Integer)UIManager.get("ScrollBar.width");
            width += scrWidth.intValue();
        }
        int height = (int)pageFormat.getHeight() + 23;
        scrollPane.setPreferredSize(new Dimension(width, height));
        return scrollPane;
    }
}

