/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.print;

import com.developmentontheedge.print.FooterFormat;
import com.developmentontheedge.print.JPrintableComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class PagePreview
extends JPanel {
    protected static final Logger log = Logger.getLogger(PagePreview.class.getName());
    private JPrintableComponent component = null;
    private PageFormat format = null;
    private int index = 0;

    public PagePreview(JPrintableComponent component, PageFormat format, int index) {
        this.component = component;
        this.format = format;
        this.index = index;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)this.format.getWidth(), (int)this.format.getHeight());
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        int width = (int)this.format.getWidth();
        int height = (int)this.format.getHeight();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.black);
        g2.drawRect(0, 0, width - 1, height - 1);
        int iX = (int)this.format.getImageableX();
        int iY = (int)this.format.getImageableY();
        int iWidth = (int)this.format.getImageableWidth();
        int iHeight = (int)this.format.getImageableHeight();
        g2.setColor(Color.gray);
        g2.drawLine(iX - 1, 0, iX - 1, height);
        g2.drawLine(iX + iWidth + 1, 0, iX + iWidth + 1, height);
        g2.drawLine(0, iY - 1, width, iY - 1);
        g2.drawLine(0, iY + iHeight + 1, width, iY + iHeight + 1);
        if (this.format instanceof FooterFormat) {
            iHeight = (int)((FooterFormat)this.format).getImageableHeightAtFooter();
            g2.drawLine(0, iY + iHeight + 1, width, iY + iHeight + 1);
        }
        try {
            this.component.preview(g, this.format, this.index);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

