/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.print;

import com.developmentontheedge.print.FooterFormat;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class LargePageable
implements Pageable {
    private int mNumPagesX;
    private int mNumPagesY;
    private int mNumPages;
    private Printable mPainter;
    private PageFormat mFormat;

    public LargePageable(float width, float height, Printable painter, PageFormat format) {
        this.setPrintable(painter);
        this.setPageFormat(format);
        this.setSize(width, height);
    }

    protected LargePageable() {
    }

    protected void setPrintable(Printable painter) {
        this.mPainter = painter;
    }

    protected void setPageFormat(PageFormat pageFormat) {
        this.mFormat = pageFormat;
    }

    protected void setSize(float width, float height) {
        this.mNumPagesX = (int)(((double)width + this.mFormat.getImageableWidth() - 1.0) / this.mFormat.getImageableWidth());
        this.mNumPagesY = this.mFormat instanceof FooterFormat ? (int)(((double)height + ((FooterFormat)this.mFormat).getImageableHeightAtFooter() - 1.0) / ((FooterFormat)this.mFormat).getImageableHeightAtFooter()) : (int)(((double)height + this.mFormat.getImageableHeight() - 1.0) / this.mFormat.getImageableHeight());
        this.mNumPages = this.mNumPagesX * this.mNumPagesY;
    }

    @Override
    public int getNumberOfPages() {
        return this.mNumPages;
    }

    protected PageFormat getPageFormat() {
        return this.mFormat;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        double originX = (double)(pageIndex % this.mNumPagesX) * this.mFormat.getImageableWidth();
        double originY = (double)(pageIndex / this.mNumPagesX) * this.mFormat.getImageableHeight();
        if (this.mFormat instanceof FooterFormat) {
            originY = (double)(pageIndex / this.mNumPagesX) * ((FooterFormat)this.mFormat).getImageableHeightAtFooter();
        }
        Point2D.Double origin = new Point2D.Double(originX, originY);
        return new TranslatedPrintable(this.mPainter, origin);
    }

    public final class TranslatedPrintable
    implements Printable {
        private Printable mPainter;
        private Point2D mOrigin;

        public TranslatedPrintable(Printable painter, Point2D origin) {
            this.mPainter = painter;
            this.mOrigin = origin;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            Graphics2D g2 = (Graphics2D)graphics.create();
            int iX = (int)pageFormat.getImageableX();
            int iY = (int)pageFormat.getImageableY();
            int iWidth = (int)pageFormat.getImageableWidth();
            int iHeight = (int)pageFormat.getImageableHeight();
            if (pageFormat instanceof FooterFormat) {
                iHeight = (int)((FooterFormat)pageFormat).getImageableHeightAtFooter();
            }
            Rectangle rect1 = g2.getClipBounds();
            Rectangle rect2 = new Rectangle(iX, iY, iWidth, iHeight);
            Rectangle rect = new Rectangle();
            Rectangle.intersect(rect1, rect2, rect);
            g2.setClip(rect.x, rect.y, rect.width, rect.height);
            g2.translate(-this.mOrigin.getX(), -this.mOrigin.getY());
            this.mPainter.print(g2, pageFormat, 1);
            if (pageFormat instanceof FooterFormat) {
                FooterFormat formatPainter = (FooterFormat)pageFormat;
                int y = pageIndex / LargePageable.this.mNumPagesX + 1;
                int x = pageIndex - LargePageable.this.mNumPagesX * (y - 1) + 1;
                String textToPrint = "Page " + (pageIndex + 1) + " of " + LargePageable.this.mNumPages + " (" + x + "," + y + ")";
                formatPainter.print(graphics, pageFormat, textToPrint);
            }
            g2.dispose();
            return 0;
        }
    }
}

