/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.print.PageFormat;

public class FooterFormat
extends PageFormat {
    private static final Font mFooterFont = new Font("Serif", 2, 14);
    private static final float mFooterHeight = 21.6f;

    public double getImageableHeightAtFooter() {
        double imageableHeight = this.getImageableHeight() - (double)21.6f;
        if (imageableHeight < 0.0) {
            imageableHeight = 0.0;
        }
        return imageableHeight;
    }

    public int print(Graphics g, PageFormat format, String textToPrint) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setPaint(Color.black);
        g2d.setFont(mFooterFont);
        LineMetrics metrics = mFooterFont.getLineMetrics(textToPrint, g2d.getFontRenderContext());
        float y = (float)(super.getImageableY() + super.getImageableHeight() - (double)metrics.getDescent() - (double)metrics.getLeading());
        g2d.drawString(textToPrint, (int)super.getImageableX(), (int)y);
        g2d.dispose();
        return 0;
    }
}

