/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.log;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class WriterHandler
extends Handler {
    private Writer writer;

    public WriterHandler(Writer writer) {
        this.writer = writer;
        this.setFormatter(new SimpleFormatter());
    }

    public WriterHandler(Writer writer, Formatter formatter) {
        this.writer = writer;
        this.setFormatter(formatter);
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            try {
                this.writer.write(this.getFormatter().format(record));
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

