/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.log;

import com.developmentontheedge.log.LogTextPanel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class TextPaneAppender
extends Handler {
    StringWriter sw;
    LogTextPanel logTextPanel;
    LogPublishingThread logPublisher;
    String name;
    PrintWriter pw;
    static final String COLOR_OPTION_FATAL = "Color.Fatal";
    static final String COLOR_OPTION_ERROR = "Color.Error";
    static final String COLOR_OPTION_WARN = "Color.Warn";
    static final String COLOR_OPTION_INFO = "Color.Info";
    static final String COLOR_OPTION_DEBUG = "Color.Debug";
    static final String COLOR_OPTION_BACKGROUND = "Color.Background";
    static final String FONT_NAME_OPTION = "Font.Name";
    static final String FONT_SIZE_OPTION = "Font.Size";
    static final String EVENT_BUFFER_SIZE_OPTION = "EventBuffer.Size";
    private String[] categoryNames;

    public TextPaneAppender(Formatter formatter, String name) {
        this.setFormatter(formatter);
        this.name = name;
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
        this.setLogTextPanel(new LogTextPanel());
        this.logPublisher = new LogPublishingThread(name, this.logTextPanel, Level.FINE, 500L);
    }

    @Override
    public void close() throws SecurityException {
        if (this.categoryNames != null) {
            this.removeFromCategories(this.categoryNames);
        }
        this.categoryNames = null;
        this.logPublisher.close();
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        String text = this.getFormatter().format(record);
        if (record.getThrown() != null) {
            record.getThrown().printStackTrace(this.pw);
            for (int i = 0; i < this.sw.getBuffer().length() && i < 200; ++i) {
                if (this.sw.getBuffer().charAt(i) != '\t') continue;
                this.sw.getBuffer().replace(i, i + 1, "        ");
            }
            text = text + this.sw.toString();
            this.sw.getBuffer().delete(0, this.sw.getBuffer().length());
        } else if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.logPublisher.publishEvent(record.getLevel(), text);
    }

    public LogTextPanel getLogTextPanel() {
        return this.logTextPanel;
    }

    public String[] getOptionStrings() {
        return new String[]{COLOR_OPTION_FATAL, COLOR_OPTION_ERROR, COLOR_OPTION_WARN, COLOR_OPTION_INFO, COLOR_OPTION_DEBUG, COLOR_OPTION_BACKGROUND, FONT_NAME_OPTION, FONT_SIZE_OPTION};
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void setLogTextPanel(LogTextPanel logTextPanel) {
        this.logTextPanel = logTextPanel;
    }

    public void addToCategories(String[] categoryNames) {
        this.categoryNames = categoryNames;
        for (int i = 0; i < categoryNames.length; ++i) {
            Logger cat = Logger.getLogger(categoryNames[i]);
            cat.addHandler(this);
        }
    }

    public void removeFromCategories(String[] categoryNames) {
        for (int i = 0; i < categoryNames.length; ++i) {
            Logger cat = Logger.getLogger(categoryNames[i]);
            cat.removeHandler(this);
        }
    }

    static class EventBufferElement {
        public String text;
        public Level prio;
        public int numLines;

        EventBufferElement(Level prio, String text) {
            this.prio = prio;
            this.text = text;
            this.numLines = 1;
            int pos = text.indexOf(10, 0);
            int len = text.length() - 1;
            while (pos > 0 && pos < len) {
                ++this.numLines;
                pos = text.indexOf(10, pos + 1);
            }
        }
    }

    static class LogPublishingThread
    extends Thread {
        LogTextPanel logTextPanel;
        List<EventBufferElement> evts;
        Level triggerPrio;
        long pubInterval;
        volatile boolean finish = false;

        public LogPublishingThread(String name, LogTextPanel logTextPanel, Level triggerPrio, long pubInterval) {
            super("Logging thread: " + name);
            this.logTextPanel = logTextPanel;
            this.evts = new ArrayList<EventBufferElement>(1000);
            this.triggerPrio = triggerPrio;
            this.pubInterval = pubInterval;
            this.start();
        }

        public void close() {
            this.finish = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                List<EventBufferElement> list = this.evts;
                synchronized (list) {
                    try {
                        this.evts.wait(this.pubInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.finish) {
                        break;
                    }
                    this.logTextPanel.newEvents(this.evts.toArray(new EventBufferElement[this.evts.size()]));
                    this.evts.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publishEvent(Level prio, String text) {
            List<EventBufferElement> list = this.evts;
            synchronized (list) {
                this.evts.add(new EventBufferElement(prio, text));
                if (this.triggerPrio != null && prio.intValue() >= this.triggerPrio.intValue()) {
                    this.evts.notify();
                }
            }
        }
    }
}

