/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application.dialog;

import com.developmentontheedge.application.ApplicationUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class OkCancelDialog
extends JDialog {
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    protected boolean result = false;
    protected JPanel mainPanel;
    protected JPanel buttonPanel;
    protected JButton okButton;
    protected JButton cancelButton;

    public OkCancelDialog(JFrame frame, String title) {
        this(frame, title, null, true);
    }

    public OkCancelDialog(JFrame frame, String title, boolean modal) {
        this(frame, title, null, modal);
    }

    public OkCancelDialog(JDialog dialog, String title) {
        this(dialog, title, null);
    }

    public OkCancelDialog(JFrame frame, String title, Component userPane, String cancelText, String okText) {
        this(frame, title, userPane);
        if (okText != null) {
            this.okButton.setText(okText);
            this.okButton.setDefaultCapable(true);
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.setPreferredSize(null);
        } else {
            this.okButton.setVisible(false);
        }
        if (cancelText != null) {
            this.cancelButton.setText(cancelText);
        } else {
            this.cancelButton.setVisible(false);
        }
    }

    public OkCancelDialog(JFrame frame, String title, Component userPane) {
        this(frame, title, userPane, true);
    }

    public OkCancelDialog(JDialog dialog, String title, Component userPane) {
        super(dialog, title, true);
        this.init(userPane);
    }

    public OkCancelDialog(JFrame frame, String title, Component userPane, boolean modal) {
        super(frame, title, modal);
        this.init(userPane);
    }

    private void init(Component userPane) {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        contentPane.add((Component)this.mainPanel, "Center");
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("Ok");
        this.okButton.setDefaultCapable(true);
        this.cancelButton = new JButton("Cancel");
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)this.buttonPanel, "South");
        if (userPane != null) {
            this.setContent(userPane);
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    OkCancelDialog.this.cancelPressed();
                }
            }
        });
        this.cancelButton.addActionListener(e -> this.cancelPressed());
        this.okButton.addActionListener(e -> this.okPressed());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (OkCancelDialog.this.cancelButton.isEnabled()) {
                    OkCancelDialog.this.cancelPressed();
                }
            }
        });
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setContent(Component comp) {
        this.mainPanel.add(comp, "Center");
    }

    public boolean doModal() {
        this.pack();
        ApplicationUtils.moveToCenter(this);
        this.show();
        this.dispose();
        return this.result;
    }

    protected void okPressed() {
        this.result = true;
        this.dispose();
    }

    protected void cancelPressed() {
        this.result = false;
        this.dispose();
    }

    protected void exited() {
        this.result = false;
        this.dispose();
    }
}

