/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application.dialog;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileChooserRegistry {
    public static final String OTHER_FILES = "Other files entry";
    public static final String SEQUENCE_FILES = "Sequence files entry";
    public static final String MATRIX_FILES = "Matrix files entry";
    public static final String PROFILE_FILES = "Profile files entry";
    public static final int SAVE_MODE = 0;
    public static final int OPEN_MODE = 1;
    private static Logger cat = Logger.getLogger(FileChooserRegistry.class.getName());
    private static HashMap<String, RegistryEntry> registryMap = null;
    private static JFileChooser chooser;

    public static void init() {
        registryMap = new HashMap();
        RegistryEntry entry = new RegistryEntry(null, null);
        registryMap.put(OTHER_FILES, entry);
        entry = new RegistryEntry(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getAbsolutePath().endsWith(".mat") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Matrices files (*.mat)";
            }
        }, null);
        registryMap.put(MATRIX_FILES, entry);
        entry = new RegistryEntry(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getAbsolutePath().endsWith(".seq") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Sequences files (*.seq)";
            }
        }, null);
        registryMap.put(SEQUENCE_FILES, entry);
        entry = new RegistryEntry(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getAbsolutePath().endsWith(".prf") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Profile files (*.prf)";
            }
        }, null);
        registryMap.put(PROFILE_FILES, entry);
    }

    public static File getSelectedFile() {
        return chooser == null ? null : chooser.getSelectedFile();
    }

    public static boolean showOpenDialog(Component parent, int mode, String dialogType, int saveOpenMode) {
        boolean good;
        if (registryMap == null) {
            FileChooserRegistry.init();
        }
        chooser = new JFileChooser();
        RegistryEntry entry = registryMap.get(dialogType);
        if (entry != null) {
            if (entry.getFilter() != null) {
                chooser.setFileFilter(entry.getFilter());
            }
            if (entry.getHomeDir() != null) {
                chooser.setCurrentDirectory(entry.getHomeDir());
            }
        } else {
            cat.log(Level.SEVERE, "File chooser registry entry not found:" + dialogType);
        }
        if (mode == 1) {
            chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), "choose folder"));
            chooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("directoryChanged")) {
                        chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), "choose folder"));
                    }
                }
            });
        }
        chooser.setFileSelectionMode(mode);
        boolean bl = good = (saveOpenMode == 1 ? chooser.showOpenDialog(parent) : chooser.showSaveDialog(parent)) == 0;
        if (good) {
            entry.setHomeDir(chooser.getCurrentDirectory());
        }
        return good;
    }

    private static class RegistryEntry {
        private FileFilter filter;
        private File homeDir;

        public RegistryEntry(FileFilter filter, File homeDir) {
            this.filter = filter;
            this.homeDir = homeDir;
        }

        public FileFilter getFilter() {
            return this.filter;
        }

        public File getHomeDir() {
            return this.homeDir;
        }

        public void setHomeDir(File homeDir) {
            this.homeDir = homeDir;
        }
    }
}

