/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application.dialog;

import com.developmentontheedge.application.dialog.FileChooserRegistry;
import com.developmentontheedge.application.dialog.TextButtonField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Vector;

public class BrowseTextField
extends TextButtonField {
    protected File selectedFile = null;
    private Vector<ActionListener> listeners;

    public BrowseTextField(Component parent, String dialogType) {
        this(parent, 0, dialogType, 1);
    }

    public BrowseTextField(Component parent, String dialogType, int saveOpenMode) {
        this(parent, 0, dialogType, saveOpenMode);
    }

    public BrowseTextField(Component parent, final int mode, final String dialogType, final int saveOpenMode) {
        super("...");
        this.button.setPreferredSize(new Dimension(20, 20));
        this.textField.setPreferredSize(new Dimension(150, 20));
        final Component prnt = parent;
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FileChooserRegistry.showOpenDialog(prnt, mode, dialogType, saveOpenMode)) {
                    BrowseTextField.this.selectedFile = FileChooserRegistry.getSelectedFile();
                    File file = new File(BrowseTextField.this.selectedFile.getAbsolutePath());
                    BrowseTextField.this.textField.setText(file.getPath());
                    if (BrowseTextField.this.listeners != null) {
                        for (ActionListener listener : BrowseTextField.this.listeners) {
                            listener.actionPerformed(new ActionEvent(this, 0, "light my fire"));
                        }
                    }
                }
            }
        });
    }

    public File getFile() throws Exception {
        String name = this.getFileName();
        File file = new File(name);
        return file;
    }

    public void setFileName(String name) {
        this.textField.setText(name);
    }

    public String getFileName() throws Exception {
        String name = this.textField.getText();
        return name;
    }

    public void addListener(Object listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (listener != null) {
            if (listener instanceof KeyListener) {
                this.textField.addKeyListener((KeyListener)listener);
            } else if (listener instanceof ActionListener) {
                this.listeners.add((ActionListener)listener);
            }
        }
    }
}

