/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application.action;

import com.developmentontheedge.application.action.ActionInitializer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class ApplicationAction
extends AbstractAction {
    public static final String PARAMETER = "Parameter";
    private Vector<ActionListener> actionListeners = null;

    public ApplicationAction(Class<? extends ResourceBundle> resourceClass, String key) {
        new ActionInitializer(resourceClass).initAction(this, key);
    }

    public ApplicationAction(String name, String cmd) {
        this.putValue("Name", name);
        this.putValue("ActionCommandKey", cmd);
    }

    public ApplicationAction(String name, String shortDesc, String longDesc, int mnemonic, String imageFile, String cmd, ActionListener listener) {
        this(name, shortDesc, longDesc, mnemonic, imageFile, listener);
        this.putValue("ActionCommandKey", cmd);
    }

    public ApplicationAction(String name, String shortDesc, String longDesc, int mnemonic, String imageFile, ActionListener listener) {
        URL url;
        this.putValue("Name", name);
        this.putValue("ShortDescription", shortDesc);
        this.putValue("LongDescription", longDesc);
        this.putValue("MnemonicKey", mnemonic);
        if (imageFile != null && (url = this.getClass().getResource("resources/" + imageFile)) != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
        if (listener != null) {
            this.addActionListener(listener);
        }
    }

    public ApplicationAction(String name, String shortDesc, String longDesc, int mnemonic, String imageFile) {
        this(name, shortDesc, longDesc, mnemonic, imageFile, null);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.fireActionPerformed(evt);
    }

    public void removeActionListeners(Class<? extends ActionListener> clazz) {
        for (int i = this.actionListeners.size() - 1; i >= 0; --i) {
            ActionListener l = this.actionListeners.get(i);
            if (clazz != l.getClass()) continue;
            this.actionListeners.remove(l);
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        this.actionListeners.add(l);
    }

    protected void fireActionPerformed(ActionEvent evt) {
        ActionEvent event = new ActionEvent(this, evt.getID(), evt.getActionCommand());
        if (this.actionListeners != null) {
            for (int i = this.actionListeners.size() - 1; i >= 0; --i) {
                ActionListener l = this.actionListeners.get(i);
                if (l == null) continue;
                l.actionPerformed(event);
            }
        }
    }

    public static class ActionPrint
    extends ApplicationAction {
        public ActionPrint(ActionListener l) {
            super("Print...", "Print current document or selection", "print", 80, "print.gif", l);
        }
    }

    public static class ActionPrintPreview
    extends ApplicationAction {
        public ActionPrintPreview(ActionListener l) {
            super("Print Preview...", "Previews how this document will print", "Print Preview", 86, "printPreview.gif", l);
        }
    }

    public static class ActionPrintSetup
    extends ApplicationAction {
        public ActionPrintSetup(ActionListener l) {
            super("Print Setup...", "Change the printer and printing options", "Print Setup", 84, "printSetup.gif", l);
        }
    }

    public static class ActionAboutDialog
    extends ApplicationAction {
        public ActionAboutDialog(ActionListener l) {
            super("About...", "About", "About application", 65, null, l);
        }
    }

    public static class ActionHelp
    extends ApplicationAction {
        public ActionHelp(ActionListener l) {
            super("Help", "Help", "Help", 70, "help.gif", l);
        }
    }

    public static class ActionExit
    extends ApplicationAction {
        public ActionExit(ActionListener l) {
            super("Exit", "Exit from application", "exit", 27, "exit.gif", l);
        }
    }
}

