/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application.action;

import com.developmentontheedge.application.action.ActionInitializer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Action;

public class ActionManager {
    private final Hashtable<String, Action> actions = new Hashtable();

    public Action getAction(String actionName) {
        return this.actions.get(actionName);
    }

    public void addAction(String actionName, Action act) {
        this.actions.put(actionName, act);
        act.putValue("ActionCommandKey", actionName);
    }

    public Hashtable<String, Action> getActions() {
        return this.actions;
    }

    public void initActions(Class<?> ... resourceClasses) {
        ActionInitializer initializer = new ActionInitializer(resourceClasses);
        Enumeration<String> keys = this.actions.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Action action = this.actions.get(key);
            initializer.initAction(action, key);
        }
    }

    public void enableActions(boolean value, String ... actionNames) {
        for (String actionName : actionNames) {
            Action action = this.getAction(actionName);
            if (action == null) continue;
            action.setEnabled(value);
        }
    }
}

