/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application.action;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class ActionInitializer {
    private static final Logger log = Logger.getLogger(ActionInitializer.class.getName());
    private final ResourceBundle[] resources;

    public ActionInitializer(Class<?> ... classes) {
        this.resources = (ResourceBundle[])Stream.of(classes).map(ActionInitializer::createResourceBundle).filter(Objects::nonNull).toArray(ResourceBundle[]::new);
    }

    public ActionInitializer(ResourceBundle r) {
        this.resources = new ResourceBundle[]{r};
    }

    public void initAction(Action action) {
        this.initAction(action, (String)action.getValue("Name"));
    }

    public void initAction(Action action, String key) {
        Object obj;
        URL url;
        this.initActionValue(action, "Name", key + "Name");
        this.initActionValue(action, "ShortDescription", key + "ShortDescription");
        this.initActionValue(action, "LongDescription", key + "LongDescription");
        this.initActionValue(action, "ActionCommandKey", key + "ActionCommandKey");
        Object mnemonic = this.getResourceObject(key + "MnemonicKey");
        if (mnemonic != null) {
            try {
                action.putValue("MnemonicKey", Integer.parseInt(mnemonic.toString()));
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Could not parse MNEMONIC_KEY");
            }
        }
        if ((url = this.getResourceURL(key + "SmallIcon")) != null) {
            action.putValue("SmallIcon", new ImageIcon(url));
        }
        if ((obj = this.getResourceObject(key + "AcceleratorKey")) instanceof KeyStroke) {
            action.putValue("AcceleratorKey", obj);
        }
    }

    private void initActionValue(Action action, String actionKey, String resourceKey) {
        String value = this.getResourceString(resourceKey);
        if (value != null) {
            action.putValue(actionKey, value);
        }
    }

    private static ResourceBundle createResourceBundle(String resourceBundlename, Class<?> l) {
        try {
            return ResourceBundle.getBundle(resourceBundlename, Locale.getDefault(), l.getClassLoader());
        }
        catch (MissingResourceException mre) {
            log.log(Level.SEVERE, "ActionInitializer properties not found", mre);
            return null;
        }
    }

    private static ResourceBundle createResourceBundle(Class<?> bundleClass) {
        try {
            return ResourceBundle.getBundle(bundleClass.getName(), Locale.getDefault(), bundleClass.getClassLoader());
        }
        catch (MissingResourceException mre) {
            log.log(Level.SEVERE, "ActionInitializer properties not found", mre);
            return null;
        }
    }

    private Object getResourceObject(String nm) {
        Object obj = null;
        for (ResourceBundle bundle : this.resources) {
            try {
                obj = bundle.getObject(nm);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (obj == null) {
            log.info("Action value absents, key=" + nm);
        }
        return obj;
    }

    private String getResourceString(String nm) {
        for (ResourceBundle bundle : this.resources) {
            try {
                return bundle.getString(nm);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        log.info("Action value absents, key=" + nm);
        return null;
    }

    private URL getResourceURL(String nm) {
        for (ResourceBundle bundle : this.resources) {
            try {
                String str = bundle.getString(nm);
                URL url = bundle.getClass().getResource(str);
                if (url == null) {
                    url = bundle.getClass().getResource("resources/" + str);
                }
                if (url == null) {
                    log.info("Action resource absents, key=" + nm + ", resource=" + str + ", bundle=" + bundle.getClass().getName());
                }
                return url;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        log.info("Action value absents, key=" + nm);
        return null;
    }
}

