/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application;

import com.developmentontheedge.application.PanelInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class PanelManager
extends JPanel
implements PropertyChangeListener {
    protected Map<String, PanelInfo> infos = new HashMap<String, PanelInfo>();
    private int defaultDividerSize = 5;
    protected Map<JSplitPane, Integer> sizesDividerLocation = new HashMap<JSplitPane, Integer>();

    public PanelManager() {
        this.setLayout(new BorderLayout());
    }

    public boolean isEmpty() {
        return this.infos.isEmpty();
    }

    public boolean contains(String name) {
        return this.infos.containsKey(name);
    }

    public JComponent getPanel(String name) {
        PanelInfo pi = this.getPanelInfo(name);
        return pi == null ? null : pi.getPanel();
    }

    public PanelInfo getPanelInfo(String name) {
        return this.infos.get(name);
    }

    public String[] getPanelNames() {
        return this.infos.keySet().toArray(new String[this.infos.size()]);
    }

    public void addPanel(PanelInfo info, String groupWith, int location) {
        this.addPanel(info, groupWith, location, 100);
    }

    public void addPanel(PanelInfo info, String groupWith, int location, int divPos) {
        JSplitPane splitPane = this.doAddPanel(info, groupWith, location);
        if (splitPane != null) {
            splitPane.setDividerLocation(divPos);
        }
    }

    public void addPanel(PanelInfo info, String groupWith, int location, double relativeDivPos) {
        JSplitPane splitPane = this.doAddPanel(info, groupWith, location);
        if (splitPane != null) {
            if (relativeDivPos < 0.05 || relativeDivPos > 0.95 && relativeDivPos < 5.0) {
                relativeDivPos = 0.5;
            }
            if (relativeDivPos < 5.0) {
                splitPane.setDividerLocation(relativeDivPos);
            } else {
                splitPane.setDividerLocation((int)relativeDivPos);
            }
        }
    }

    protected JSplitPane doAddPanel(PanelInfo info, String groupWith, int location) {
        JComponent panel = info.getPanel();
        panel.setVisible(info.isEnabled());
        JSplitPane splitPane = null;
        if (this.infos.isEmpty()) {
            this.add((Component)panel, "Center");
        } else {
            if (!this.infos.containsKey(groupWith)) {
                throw new RuntimeException("ApplicationFrame.addPanel(): can't group with non-existing panel");
            }
            splitPane = this.group(this.infos.get(groupWith), info, location);
        }
        this.infos.put(info.getName(), info);
        return splitPane;
    }

    public void removePanel(String name) {
        this.doRemovePanel(name);
        this.infos.remove(name);
    }

    protected void doRemovePanel(String name) {
        PanelInfo pi = this.infos.get(name);
        if (pi == null) {
            return;
        }
        JComponent comp = pi.getPanel();
        Container parent = comp.getParent();
        if (parent instanceof JSplitPane) {
            JSplitPane parentSP = (JSplitPane)parent;
            Component comp1 = null;
            comp1 = parentSP.getTopComponent() == comp ? parentSP.getBottomComponent() : parentSP.getTopComponent();
            Container superParent = parentSP.getParent();
            if (superParent instanceof JSplitPane) {
                JSplitPane superParentSP = (JSplitPane)superParent;
                if (superParentSP.getTopComponent() == parent) {
                    superParentSP.setTopComponent(comp1);
                } else {
                    superParentSP.setBottomComponent(comp1);
                }
            } else if (superParent == this) {
                superParent.remove(parent);
                superParent.add(comp1, "Center");
            }
        } else {
            parent.remove(comp);
        }
    }

    public void removeAllPanels() {
        for (String key : this.infos.keySet()) {
            this.doRemovePanel(key);
        }
        this.infos.clear();
    }

    protected JSplitPane group(PanelInfo pi1, PanelInfo pi2, int location) {
        JComponent comp1 = pi1.getPanel();
        JComponent comp2 = pi2.getPanel();
        Dimension sz2 = pi2.getPanel().getSize();
        JSplitPane splitPane = null;
        Container parent = comp1.getParent();
        switch (location) {
            case 1: {
                splitPane = new JSplitPane(1, comp2, comp1);
                comp2.setPreferredSize(new Dimension(sz2.width - location, sz2.height));
                break;
            }
            case 2: {
                splitPane = new JSplitPane(1, comp1, comp2);
                comp2.setPreferredSize(new Dimension(sz2.width - location, sz2.height));
                break;
            }
            case 3: {
                splitPane = new JSplitPane(0, comp2, comp1);
                comp2.setPreferredSize(new Dimension(sz2.width, sz2.height - location));
                break;
            }
            default: {
                splitPane = new JSplitPane(0, comp1, comp2);
                comp2.setPreferredSize(new Dimension(sz2.width, sz2.height - location));
            }
        }
        splitPane.setDividerSize(this.defaultDividerSize);
        if (!pi1.isEnabled() || !pi2.isEnabled()) {
            splitPane.setDividerSize(0);
        }
        if (parent instanceof JSplitPane) {
            JSplitPane parentSP = (JSplitPane)parent;
            if (parentSP.getLeftComponent() == null) {
                parentSP.setLeftComponent(splitPane);
            } else {
                parentSP.setRightComponent(splitPane);
            }
            parentSP.setDividerSize(pi1.isEnabled() || pi2.isEnabled() ? this.defaultDividerSize : 0);
        } else {
            parent.remove(comp1);
            parent.add((Component)splitPane, "Center");
        }
        splitPane.addPropertyChangeListener(this);
        return splitPane;
    }

    public void togglePanel(String key) {
        PanelInfo pi = this.getPanelInfo(key);
        if (pi != null) {
            pi.setEnabled(!pi.isEnabled());
            JComponent comp = pi.getPanel();
            comp.setVisible(pi.isEnabled());
            JComponent parent = (JComponent)comp.getParent();
            if (parent instanceof JSplitPane) {
                this.update((JSplitPane)parent);
            }
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dividerLocation")) {
            JSplitPane sp = (JSplitPane)evt.getSource();
            Component top = sp.getTopComponent();
            Component bottom = sp.getBottomComponent();
            if (top != null && top.isVisible() && bottom != null && bottom.isVisible()) {
                Integer integer = (Integer)evt.getNewValue();
                this.sizesDividerLocation.put(sp, integer);
            }
        }
    }

    private void update(JSplitPane sp) {
        Component comp1 = sp.getBottomComponent();
        Component comp2 = sp.getTopComponent();
        if (comp1.isVisible() && comp2.isVisible()) {
            sp.setVisible(true);
            sp.setDividerSize(this.defaultDividerSize);
            Integer size = this.sizesDividerLocation.get(sp);
            if (size != null) {
                sp.setDividerLocation(size);
            }
        } else if (!comp1.isVisible() && !comp2.isVisible()) {
            sp.setVisible(false);
        } else if (!comp1.isVisible() || !comp2.isVisible()) {
            if (sp.getDividerLocation() != 1) {
                this.sizesDividerLocation.put(sp, sp.getDividerLocation());
            }
            sp.setVisible(true);
            sp.setDividerSize(0);
        }
        Container parent = sp.getParent();
        if (parent instanceof JSplitPane) {
            this.update((JSplitPane)parent);
        }
    }
}

