/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application;

import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JWindow;
import ru.biosoft.jobcontrol.JobControl;

public class ApplicationUtils {
    static Logger cat = Logger.getLogger(ApplicationUtils.class.getName());
    private static Graphics2D graphics;

    public static Graphics2D getGraphics() {
        if (graphics == null) {
            graphics = Application.getApplicationFrame() == null ? new BufferedImage(1, 1, 1).createGraphics() : (Graphics2D)Application.getApplicationFrame().getGraphics();
        }
        return graphics;
    }

    public static void errorBox(Throwable ex) {
        cat.log(Level.SEVERE, "", ex);
        ApplicationUtils.errorBox(ex.getMessage());
    }

    public static void errorBox(String msg) {
        ApplicationUtils.errorBox("Error", msg);
    }

    public static void errorBox(String title, String msg) {
        Application.getUIStrategy().showErrorBox(msg, title);
    }

    public static void messageBox(String title, String msg) {
        Application.getUIStrategy().showInfoBox(msg, title);
    }

    public static String prompt(JFrame frame, String title, String msg, String initialValue) {
        Object result = JOptionPane.showInputDialog(frame, msg, title, -1, null, null, initialValue);
        return result == null ? null : result.toString();
    }

    public static String prompt(String title, String msg, String initialValue) {
        return ApplicationUtils.prompt(Application.getActiveApplicationFrame(), title, msg, initialValue);
    }

    public static String prompt(String title, String msg) {
        return ApplicationUtils.prompt(Application.getActiveApplicationFrame(), title, msg, null);
    }

    public static void copyFile(String dst, String src) throws IOException {
        ApplicationUtils.copyFile(new File(dst), new File(src));
    }

    public static void copyFile(File dst, File src) throws IOException {
        ApplicationUtils.copyFile(dst, src, null);
    }

    public static BufferedReader utfReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
    }

    public static BufferedReader utfReader(String fileName) throws IOException {
        return ApplicationUtils.utfReader(new File(fileName));
    }

    public static BufferedReader asciiReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.ISO_8859_1));
    }

    public static BufferedReader asciiReader(String fileName) throws IOException {
        return ApplicationUtils.asciiReader(new File(fileName));
    }

    public static BufferedWriter utfWriter(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    public static BufferedWriter utfWriter(String fileName) throws IOException {
        return ApplicationUtils.utfWriter(new File(fileName));
    }

    public static BufferedWriter utfAppender(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8));
    }

    public static BufferedWriter utfAppender(String fileName) throws IOException {
        return ApplicationUtils.utfAppender(new File(fileName));
    }

    public static BufferedWriter asciiWriter(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.ISO_8859_1));
    }

    public static BufferedWriter asciiWriter(String fileName) throws IOException {
        return ApplicationUtils.asciiWriter(new File(fileName));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readAsString(File src, int maxChars) throws IOException {
        result = new char[maxChars];
        offset = 0;
        in = new FileInputStream(src);
        var5_5 = null;
        try {
            reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
            var7_8 = null;
            while (true) {
                read = reader.read(result, offset, maxChars - offset);
                if (read != -1) ** GOTO lbl-1000
                var9_11 = new String(result, 0, offset);
                if (reader == null) return var9_11;
                if (var7_8 != null) {
                }
                ** GOTO lbl37
                {
                    block31: {
                        block32: {
                            catch (Throwable var8_10) {
                                var7_8 = var8_10;
                                throw var8_10;
                            }
                            catch (Throwable var11_17) {
                                if (reader == null) throw var11_17;
                                if (var7_8 == null) {
                                    reader.close();
                                    throw var11_17;
                                }
                                try {
                                    reader.close();
                                    throw var11_17;
                                }
                                catch (Throwable var12_18) {
                                    var7_8.addSuppressed(var12_18);
                                    throw var11_17;
                                }
                            }
                            try {
                                reader.close();
                                return var9_11;
                            }
                            catch (Throwable var10_13) {
                                var7_8.addSuppressed(var10_13);
                                return var9_11;
                            }
lbl37:
                            // 1 sources

                            reader.close();
                            return var9_11;
lbl-1000:
                            // 1 sources

                            {
                                if ((offset += read) < maxChars) break block31;
                                var9_12 = new String(result);
                                if (reader == null) return var9_12;
                                if (var7_8 == null) break block32;
                            }
                            try {
                                reader.close();
                                return var9_12;
                            }
                            catch (Throwable var10_15) {
                                var7_8.addSuppressed(var10_15);
                                return var9_12;
                            }
                        }
                        reader.close();
                        return var9_12;
                    }
                    ** try [egrp 9[TRYBLOCK] [13 : 232->284)] { 
lbl-1000:
                    // 1 sources

                    {
                        continue;
                    }
                }
                break;
            }
        }
lbl55:
        // 2 sources

        catch (Throwable var6_7) {
            var5_5 = var6_7;
            throw var6_7;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable var10_14) {
                        var5_5.addSuppressed(var10_14);
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    public static String readAsString(File file) throws IOException {
        return ApplicationUtils.readAsString(new FileInputStream(file));
    }

    public static ByteArrayInputStream readAsStream(File file) throws IOException {
        return ApplicationUtils.readAsStream(new FileInputStream(file));
    }

    public static ByteArrayInputStream readAsStream(InputStream src) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ApplicationUtils.copyStream(baos, src);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static String readAsString(InputStream src) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ApplicationUtils.copyStream(baos, src);
        return baos.toString("UTF-8");
    }

    public static List<String> readAsList(File file) throws IOException {
        return ApplicationUtils.readAsList(new FileInputStream(file));
    }

    public static List<String> readAsList(InputStream src) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(src, StandardCharsets.UTF_8));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    public static void writeString(OutputStream dst, String str) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        ApplicationUtils.copyStream(dst, is);
    }

    public static void writeString(File dst, String str) throws IOException {
        ApplicationUtils.writeString(new FileOutputStream(dst), str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(OutputStream dst, InputStream src) throws IOException {
        int BUFFER_SIZE = 65536;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int len;
            bis = src instanceof BufferedInputStream ? (BufferedInputStream)src : new BufferedInputStream(src);
            bos = dst instanceof BufferedOutputStream ? (BufferedOutputStream)dst : new BufferedOutputStream(dst);
            byte[] buffer = new byte[65536];
            while ((len = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.flush();
                bos.close();
            }
        }
    }

    public static void copyStreamNoClose(OutputStream os, InputStream is) throws IOException {
        int len;
        int BUFFER_SIZE = 65536;
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        byte[] buffer = new byte[65536];
        while ((len = bis.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.flush();
    }

    public static void linkOrCopyFile(File dst, File src, JobControl jc) throws IOException {
        try {
            dst.delete();
            Files.createLink(dst.toPath(), src.toPath());
            if (jc != null) {
                jc.setPreparedness(100);
            }
        }
        catch (Throwable e) {
            ApplicationUtils.copyFile(dst, src, jc);
        }
    }

    public static void copyFile(File dst, File src, JobControl jc) throws IOException {
        try (FileInputStream source = new FileInputStream(src);
             FileOutputStream destination = new FileOutputStream(dst);){
            FileChannel sourceFileChannel = source.getChannel();
            FileChannel destinationFileChannel = destination.getChannel();
            long size = sourceFileChannel.size();
            long chunk = 0xA00000L;
            for (long pos = 0L; pos < size; pos += chunk) {
                sourceFileChannel.transferTo(pos, Math.min(chunk, size - pos), destinationFileChannel);
                if (jc == null) continue;
                jc.setPreparedness((int)(pos * 100L / size));
                if (jc.getStatus() != 4) continue;
                return;
            }
        }
    }

    public static void copyFolder(File dst, File src) throws Exception {
        if (src.isDirectory()) {
            dst.mkdir();
            for (File srcItem : src.listFiles()) {
                ApplicationUtils.copyFolder(new File(dst, srcItem.getName()), srcItem);
            }
        } else {
            ApplicationUtils.copyFile(dst, src);
        }
    }

    public static void removeDir(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ApplicationUtils.removeDir(file);
                }
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
        if (!dir.delete()) {
            dir.deleteOnExit();
        }
    }

    public static List<File> getFiles(File dir, Set<String> excludedNames) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (excludedNames != null && excludedNames.contains(file.getName())) continue;
                list.add(file);
                if (!file.isDirectory()) continue;
                list.addAll(ApplicationUtils.getFiles(file, excludedNames));
            }
        }
        return list;
    }

    public static List<File> getFiles(File dir) {
        return ApplicationUtils.getFiles(dir, null);
    }

    public static void sortFiles(File[] files) {
        Arrays.sort(files, Comparator.comparing(File::getName));
    }

    public static String getRelativeFilePath(File parent, File file) {
        String relative = "";
        while (!file.equals(parent)) {
            relative = file.getName() + (relative.isEmpty() ? "" : File.separator) + relative;
            if ((file = file.getParentFile()) != null) continue;
            return null;
        }
        return relative;
    }

    public static void runTimeConsumingTask(Runnable task) {
        ApplicationFrame frame = Application.getApplicationFrame();
        if (frame == null) {
            return;
        }
        Cursor oldCursor = frame.getCursor();
        frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            task.run();
        }
        catch (Throwable t) {
            cat.log(Level.SEVERE, "runTimeConsumingTask: " + t, t);
        }
        frame.setCursor(oldCursor);
    }

    public static void runTimeConsumingTaskInSeparateThread(final Runnable task) {
        new Thread(){

            @Override
            public void run() {
                ApplicationUtils.runTimeConsumingTask(task);
            }
        }.start();
    }

    public static JWindow createSplashScreen(URL url) {
        SplashWindow splashScreen = new SplashWindow(url);
        splashScreen.show();
        return splashScreen;
    }

    public static void moveToCenter(Component f) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        f.setLocation(screenSize.width / 2 - f.getSize().width / 2, screenSize.height / 2 - f.getSize().height / 2);
    }

    public static String getLastToken(String str, String delimeters) {
        StringTokenizer strTok = new StringTokenizer(str, delimeters);
        String last = null;
        while (strTok.hasMoreTokens()) {
            last = strTok.nextToken();
        }
        return last;
    }

    public static String getCommonParent(String name1, String name2) {
        String delim = "/\\";
        StringTokenizer strTok1 = new StringTokenizer(name1, delim);
        StringTokenizer strTok2 = new StringTokenizer(name2, delim);
        StringBuffer buffer = new StringBuffer();
        while (strTok1.hasMoreTokens() && strTok2.hasMoreTokens()) {
            String token2;
            String token1 = strTok1.nextToken();
            if (!token1.equals(token2 = strTok2.nextToken())) continue;
            if (buffer.length() != 0) {
                buffer.append("/");
            }
            buffer.append(token1);
        }
        return buffer.toString();
    }

    public static JPanel unitPanel(Component comp1, Component comp2) {
        JPanel pane = new JPanel(new BorderLayout());
        pane.add(comp1, "Center");
        pane.add(comp2, "South");
        return pane;
    }

    public static JSplitPane unitPanel(Component comp1, Component comp2, int splitType) {
        JSplitPane pane = new JSplitPane(splitType, comp1, comp2);
        return pane;
    }

    public static boolean dialogAreYouSure(Component parent, String msg) {
        int res = JOptionPane.showConfirmDialog(parent, msg + "\nAre You sure ?", "Confirm", 0);
        return res == 0;
    }

    public static boolean dialogAreYouSure(String msg) {
        return ApplicationUtils.dialogAreYouSure(null, msg);
    }

    static class SplashWindow
    extends JWindow {
        SplashWindow(URL url) {
            this.hide();
            JLabel splashLabel = new JLabel(new ImageIcon(url));
            this.setBackground(Color.black);
            this.getContentPane().add(splashLabel);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }
}

