/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application;

import com.developmentontheedge.application.Application;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;

public class ApplicationToolBar
extends JToolBar {
    protected HashMap<Action, AbstractButton> buttons = new HashMap();
    MouseListener mouseListener = new LMouseListener();
    BevelBorder border;

    public ApplicationToolBar() {
        this.setFloatable(true);
    }

    public AbstractButton addAction(String act) {
        return this.addAction(Application.getActionManager().getAction(act));
    }

    public AbstractButton addAction(Action action) {
        JButton b = this.createActionComponent(action);
        this.buttons.put(action, b);
        this.configureButton(b, action);
        this.add(b);
        return b;
    }

    public void addAction(Action action, int group) {
        int pos = this.addGroup(group);
        AbstractButton button = this.addActionAt(action, pos);
        this.configureButton(button, action);
    }

    public AbstractButton addActionAt(Action action, int pos) {
        JButton b = this.createActionComponent(action);
        this.buttons.put(action, b);
        this.configureButton(b, action);
        this.add((Component)b, pos + 1);
        return b;
    }

    public void removeAction(Action action) {
        AbstractButton button = this.buttons.get(action);
        if (button != null) {
            this.remove(button);
            this.buttons.remove(action);
        }
    }

    public void addSeparator(int type) {
        this.add(new MSeparator(type));
    }

    public AbstractButton addToggleButtonAt(Action action, int group, boolean isSelected) {
        int pos = this.addGroup(group);
        ImageIcon imageIcon = (ImageIcon)action.getValue("SmallIcon");
        JToggleButton b = new JToggleButton(imageIcon, isSelected);
        this.buttons.put(action, b);
        this.add((Component)b, pos + 1);
        this.configureButton(b, action);
        return b;
    }

    private void configureButton(AbstractButton button, Action action) {
        button.setAlignmentY(0.5f);
        button.setAction(action);
        button.setActionCommand((String)action.getValue("ActionCommandKey"));
        button.setText("");
        Dimension btnSize = new Dimension(25, 25);
        button.setSize(btnSize);
        button.setPreferredSize(btnSize);
        button.setMinimumSize(btnSize);
        button.setMaximumSize(btnSize);
        button.addMouseListener(this.mouseListener);
        button.setBorderPainted(false);
        if (this.border == null) {
            this.border = new BevelBorder(0){

                @Override
                protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
                    Color oldColor = g.getColor();
                    int h = height;
                    int w = width;
                    g.translate(x, y);
                    g.setColor(this.getHighlightOuterColor(c));
                    g.drawLine(0, 0, 0, h - 1);
                    g.drawLine(1, 0, w - 1, 0);
                    g.setColor(this.getHighlightInnerColor(c));
                    g.drawLine(1, 1, 1, h - 2);
                    g.drawLine(2, 1, w - 2, 1);
                    g.setColor(this.getShadowOuterColor(c));
                    g.drawLine(1, h - 1, w - 1, h - 1);
                    g.drawLine(w - 1, 1, w - 1, h - 2);
                    g.setColor(this.getShadowInnerColor(c));
                    g.drawLine(2, h - 2, w - 2, h - 2);
                    g.drawLine(w - 2, 2, w - 2, h - 3);
                    g.translate(-x, -y);
                    g.setColor(oldColor);
                }
            };
        }
        button.setBorder(this.border);
    }

    public int addGroup(int group) {
        int pos = this.findSeparator(group);
        if (pos != -1) {
            return pos;
        }
        int g = group;
        while (g > 0 && (pos = this.findSeparator(--g)) == -1) {
        }
        this.add((Component)new MSeparator(group), ++pos);
        return pos + 1;
    }

    public void cleanGroup(int group) {
        int pos = this.findSeparator(group);
        if (pos == -1) {
            return;
        }
        int deleteCount = this.findNextSeparator(pos) - pos - 1;
        if (deleteCount > 0) {
            for (int i = 0; i < deleteCount; ++i) {
                this.remove(pos + 1);
            }
        }
    }

    protected int findSeparator(int group) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof MSeparator) || ((MSeparator)c).getGroup() != group) continue;
            return i;
        }
        return -1;
    }

    protected int findNextSeparator(int pos) {
        for (int i = pos + 1; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof MSeparator)) continue;
            return i;
        }
        return this.getComponentCount();
    }

    static class LMouseListener
    extends MouseAdapter {
        LMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (button.getAction().isEnabled()) {
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            button.setBorderPainted(false);
        }
    }

    class MSeparator
    extends JToolBar.Separator {
        private final int group;

        public MSeparator(int group) {
            this.group = group;
            this.setOrientation(1);
        }

        int getGroup() {
            return this.group;
        }
    }
}

