/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import ru.biosoft.jobcontrol.JobControlEvent;
import ru.biosoft.jobcontrol.JobControlListener;

public class ApplicationStatusBar
extends JPanel
implements ActionListener,
JobControlListener {
    private static final int PROGRESS_MAX = 100;
    private static final int PROGRESS_MIN = 0;
    private JLabel label;
    private Dimension preferredSize;
    private JProgressBar progressBar;
    private Timer timer = null;
    private int target = 0;

    public ApplicationStatusBar() {
        this.setLayout(new FlowLayout(0));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setPreferredSize(new Dimension(100, this.progressBar.getPreferredSize().height + 2));
        this.progressBar.setVisible(false);
        this.label = new JLabel();
        this.preferredSize = new Dimension(this.getWidth(this.label.getText()), 2 * this.getFontHeight());
        Font font = new Font("Arial", 0, 12);
        this.label.setFont(font);
        this.add(this.label);
        this.add(this.progressBar);
    }

    protected int getWidth(String s) {
        if (this.getFont() == null) {
            return 0;
        }
        return this.getFontMetrics(this.getFont()).stringWidth(s);
    }

    protected int getFontHeight() {
        if (this.getFont() == null) {
            return 0;
        }
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setMessage(String message) {
        this.label.setText(message);
        this.label.repaint();
    }

    public void startProgressBar(String msg) {
        this.setMessage(msg);
        this.setValue(0);
        this.startProgressBar();
    }

    public void startProgressBar() {
        this.progressBar.setValue(0);
        this.progressBar.setVisible(true);
        this.progressBar.repaint();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ApplicationStatusBar.this.actionPerformed(null);
            }
        }, 0L, 15L);
    }

    public void setValue(int n) {
        if (!this.progressBar.isVisible()) {
            this.startProgressBar();
        }
        this.target = n;
    }

    public void stopImmediately() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
        this.progressBar.setVisible(false);
    }

    public void stopImmediately(String msg) {
        this.stopImmediately();
        this.setMessage(msg);
    }

    public void stopProgressBar(String msg) {
        this.stopProgressBar();
        this.setMessage(msg);
    }

    public void stopProgressBar() {
        if (this.timer == null) {
            return;
        }
        this.target = 100;
        this.timer.cancel();
        this.timer = null;
        this.setMessage("");
        this.progressBar.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int value = this.progressBar.getValue();
        if (value >= this.target) {
            return;
        }
        if (value < 100) {
            this.progressBar.setValue(value + 1);
            this.progressBar.repaint();
        }
    }

    public void valueChanged(JobControlEvent event) {
        this.setValue(event.getPreparedness());
    }

    public void jobStarted(JobControlEvent event) {
        this.startProgressBar(event.getMessage());
    }

    public void jobTerminated(JobControlEvent event) {
        this.stopImmediately(event.getMessage());
    }

    public void jobPaused(JobControlEvent event) {
    }

    public void jobResumed(JobControlEvent event) {
    }

    public void resultsReady(JobControlEvent event) {
    }
}

