/*
 * Decompiled with CFR 0.152.
 */
package com.developmentontheedge.application;

import com.developmentontheedge.application.ApplicationFrame;
import com.developmentontheedge.application.SwingUIStrategy;
import com.developmentontheedge.application.UIStrategy;
import com.developmentontheedge.application.action.ActionManager;
import com.developmentontheedge.beans.Preferences;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class Application {
    private static IExtensionRegistry registry = Platform.getExtensionRegistry();
    private static UIStrategy uiStrategy = new SwingUIStrategy();
    private static Preferences preferences;
    private static ApplicationFrame applicationFrame;
    private static Map<String, ApplicationFrame> applicationFrameMap;
    private static ActionManager actionManager;
    private static Map<ApplicationFrame, ActionManager> actionManagersMap;
    private static Logger log;
    private static ListResourceBundle resBundle;

    public static Preferences getPreferences() {
        return preferences;
    }

    public static void setPreferences(Preferences preferences) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setupApplication"));
        }
        Application.preferences = preferences;
    }

    public static IExtensionRegistry getExtensionRegistry() {
        return registry;
    }

    public static void setExtensionRegistry(IExtensionRegistry registry) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setupApplication"));
        }
        Application.registry = registry;
    }

    public static void setUIStrategy(UIStrategy uiStrategy) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setupApplication"));
        }
        Application.uiStrategy = uiStrategy;
    }

    public static UIStrategy getUIStrategy() {
        return uiStrategy;
    }

    public static String getGlobalValue(String constantName) {
        return Application.getGlobalValue(constantName, constantName);
    }

    public static String getGlobalValue(String constantName, String defaultValue) {
        Object value;
        Preferences globalPreferences;
        Preferences preferences = Application.getPreferences();
        if (preferences != null && (globalPreferences = (Preferences)preferences.getValue("Global")) != null && (value = globalPreferences.getValue(constantName)) != null) {
            return value.toString();
        }
        return defaultValue;
    }

    public static ApplicationFrame getApplicationFrame() {
        return Application.getActiveApplicationFrame();
    }

    public static ApplicationFrame getMainApplicationFrame() {
        if (null == applicationFrame && !applicationFrameMap.isEmpty()) {
            return (ApplicationFrame)applicationFrameMap.values().toArray()[0];
        }
        return applicationFrame;
    }

    public static void registerApplicationFrame(ApplicationFrame frame) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setupApplication"));
        }
        applicationFrame = frame;
    }

    public static ApplicationFrame getApplicationFrame(String frameName) {
        if (null == frameName) {
            return Application.getApplicationFrame();
        }
        return applicationFrameMap.get(frameName);
    }

    public static void registerApplicationFrame(String name, ApplicationFrame frame) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setupApplication"));
        }
        applicationFrameMap.put(name, frame);
    }

    public static ApplicationFrame getActiveApplicationFrame() {
        for (ApplicationFrame frame : applicationFrameMap.values()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return Application.getMainApplicationFrame();
    }

    public static ActionManager getActionManager() {
        return Application.getActiveActionManager();
    }

    public static ActionManager getActiveActionManager() {
        return Application.getActionManager(Application.getActiveApplicationFrame());
    }

    public static ActionManager getMainActionManager() {
        if (null == actionManager && !actionManagersMap.isEmpty()) {
            return (ActionManager)actionManagersMap.values().toArray()[0];
        }
        return actionManager;
    }

    public static void registerActionManager(ActionManager actionManager) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setupApplication"));
        }
        Application.actionManager = actionManager;
    }

    public static ActionManager getActionManager(ApplicationFrame applicationFrame) {
        if (null == applicationFrame || Application.applicationFrame == applicationFrame) {
            return Application.getMainActionManager();
        }
        return actionManagersMap.get(applicationFrame);
    }

    public static void registerActionManager(ActionManager actionManager, ApplicationFrame applicationFrame) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setupApplication"));
        }
        actionManagersMap.put(applicationFrame, actionManager);
    }

    public static void registerCategory(Logger c) {
        log = c;
    }

    public static ListResourceBundle registerMessageBundle(String name) {
        resBundle = (ListResourceBundle)ResourceBundle.getBundle(name, Locale.getDefault());
        return resBundle;
    }

    public static Object getResource(String key) {
        try {
            return resBundle.getObject(key);
        }
        catch (Exception ex) {
            if (log != null) {
                log.log(Level.SEVERE, "", ex);
            }
            return key;
        }
    }

    public static String getString(String key) {
        try {
            return resBundle.getString(key);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
            return key;
        }
    }

    static {
        applicationFrame = null;
        applicationFrameMap = new HashMap<String, ApplicationFrame>();
        actionManager = null;
        actionManagersMap = new HashMap<ApplicationFrame, ActionManager>();
        log = Logger.getLogger(Application.class.getName());
    }
}

