/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.exception;

import ru.biosoft.exception.ExceptionDescriptor;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.exception.LoggedException;

public abstract class ParameterException
extends LoggedException {
    public static String KEY_PARAMETER_NAME = "parameter";
    public static String KEY_PARAMETER_NAME_LOWER_CASE = "lc_parameter";
    public static String KEY_PARAMETER_VALUE = "value";

    public ParameterException(Throwable t, ExceptionDescriptor descriptor, String parameter, Object value) {
        super(ExceptionRegistry.translateException(t), descriptor);
        this.properties.put(KEY_PARAMETER_NAME, parameter);
        if (parameter != null && parameter.length() >= 2 && Character.isUpperCase(parameter.charAt(0)) && Character.isLowerCase(parameter.charAt(1))) {
            this.properties.put(KEY_PARAMETER_NAME_LOWER_CASE, parameter.substring(0, 1).toLowerCase() + parameter.substring(1));
        } else {
            this.properties.put(KEY_PARAMETER_NAME_LOWER_CASE, parameter);
        }
        if (value != null) {
            this.properties.put(KEY_PARAMETER_VALUE, value);
        }
    }

    public ParameterException(Throwable t, ExceptionDescriptor descriptor, String parameter) {
        this(t, descriptor, parameter, null);
    }

    public ParameterException(ExceptionDescriptor descriptor, String parameter) {
        this(null, descriptor, parameter);
    }
}

