/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import ru.biosoft.exception.ExceptionDescriptor;

public abstract class LoggedException
extends RuntimeException {
    protected static final Logger defaultLogger = Logger.getLogger("error.log");
    private static AtomicInteger lastExceptionId = new AtomicInteger();
    private final int exceptionId = lastExceptionId.incrementAndGet();
    private final ExceptionDescriptor descriptor;
    protected final HashMap<String, Object> properties = new HashMap();
    private boolean logged = false;
    private static int lastLoggedStackTraceId;
    private static StackTraceElement[] lastStackTrace;
    private String message;

    protected LoggedException(ExceptionDescriptor descriptor) {
        this(null, descriptor);
    }

    protected LoggedException(Throwable t, ExceptionDescriptor descriptor) {
        super(t);
        this.descriptor = descriptor;
    }

    public String getId() {
        return "EX#" + this.exceptionId;
    }

    public ExceptionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    protected boolean isDisplayCause() {
        return this.getCause() != null && this.getCause() != this && this.getCause() instanceof LoggedException;
    }

    protected boolean isLogged() {
        return this.logged;
    }

    private String getLog() {
        if (this.descriptor.getLogLevel() == LoggingLevel.None) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(this).append('\n');
        String template = this.descriptor.getTemplate();
        for (String key : this.properties.keySet()) {
            if (template.contains('$' + key + '$')) continue;
            sb.append("\t" + key + " = " + this.properties.get(key) + "\n");
        }
        if (this.descriptor.getLogLevel() == LoggingLevel.Summary) {
            return sb.toString();
        }
        if (this.descriptor.getLogLevel() == LoggingLevel.Trace || this.descriptor.getLogLevel() == LoggingLevel.TraceIfNoCause && this.getCause() == null) {
            StringWriter sw = new StringWriter();
            LoggedException.logStackTrace(new PrintWriter(sw), this, this.exceptionId);
            sb.append(sw.toString());
        }
        return sb.toString();
    }

    public String log() {
        return this.log(defaultLogger);
    }

    public String log(Logger log) {
        if (this.logged || this.descriptor.getLogLevel() == LoggingLevel.None) {
            return this.getMessage();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.append(this.getLog());
        LoggedException ex = this;
        while (ex.getCause() != ex && ex.getCause() != null) {
            if (ex.getCause() instanceof LoggedException) {
                LoggedException cause = (LoggedException)ex.getCause();
                if (cause.descriptor.getLogLevel() != LoggingLevel.None) {
                    if (cause.logged) {
                        pw.append("Caused by: " + cause + " (already logged)");
                        break;
                    }
                    pw.append("Caused by: " + cause.getLog());
                }
                ex = cause;
                continue;
            }
            pw.append("Caused by: ");
            LoggedException.logStackTrace(pw, ex.getCause(), this.exceptionId);
            break;
        }
        pw.flush();
        log.severe(sw.toString());
        this.logged = true;
        return this.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logStackTrace(PrintWriter pw, Throwable ex, int exceptionId) {
        Object[] trace = ex.getStackTrace();
        Object[] objectArray = LoggedException.class;
        synchronized (LoggedException.class) {
            if (Arrays.equals(lastStackTrace, trace)) {
                if (!(ex instanceof LoggedException)) {
                    pw.println(ex.toString());
                }
                pw.append("\t(see EX#" + lastLoggedStackTraceId + " for stack trace)");
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            lastStackTrace = trace;
            lastLoggedStackTraceId = exceptionId;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (ex instanceof LoggedException) {
                for (Object element : trace) {
                    pw.append("\tat " + element + "\n");
                }
            } else {
                ex.printStackTrace(pw);
            }
            return;
        }
    }

    public static String calculateTemplate(String template, HashMap<String, Object> properties) {
        try {
            StringBuilder result = new StringBuilder();
            String[] fields = LoggedException.split(template, '$');
            for (int i = 0; i < fields.length; ++i) {
                if (i % 2 == 0) {
                    result.append(fields[i]);
                    continue;
                }
                Object value = properties.get(fields[i]);
                if (value == null) continue;
                result.append(value.toString());
            }
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] split(String string, char delimiter) {
        int n = 1;
        int i = 0;
        while ((i = string.indexOf(delimiter, i)) != -1) {
            ++n;
            ++i;
        }
        if (n == 1) {
            return new String[]{string};
        }
        String[] result = new String[n];
        n = 0;
        i = 0;
        int start = 0;
        while ((i = string.indexOf(delimiter, start)) != -1) {
            result[n++] = string.substring(start, i);
            start = i + 1;
        }
        result[n] = string.substring(start);
        return result;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            String messageTemplate = this.descriptor.getTemplate();
            this.message = LoggedException.calculateTemplate(messageTemplate, this.properties);
            if (this.isDisplayCause()) {
                this.message = this.message + "\nReason: " + this.getCause().getMessage();
            }
        }
        return this.message;
    }

    @Override
    public String toString() {
        return this.getId() + '/' + this.descriptor.getCode() + ": " + LoggedException.calculateTemplate(this.descriptor.getTemplate(), this.properties) + (this.properties.isEmpty() ? "" : "\n properties=" + this.properties.hashCode() + ".");
    }

    public static enum LoggingLevel {
        None,
        Summary,
        TraceIfNoCause,
        Trace;

    }
}

