/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.exception;

import ru.biosoft.exception.ExceptionDescriptor;
import ru.biosoft.exception.LoggedException;

public class LoggedClassNotFoundException
extends LoggedException {
    public static String KEY_CLASS = "class";
    public static String KEY_PLUGINS = "plugins";
    public static String KEY_AVAILABLE = "pluginAvailable";
    public static String KEY_REQUESTED = "pluginRequested";
    public static String KEY_ADDITIONAL = "additional";
    public static final ExceptionDescriptor ED_NO_CLASS = new ExceptionDescriptor("NoClass", LoggedException.LoggingLevel.TraceIfNoCause, "Internal error occured: Java class $class$ not found.$additional$");
    public static final ExceptionDescriptor ED_CLASS_LOAD_ERROR = new ExceptionDescriptor("ClassLoadError", LoggedException.LoggingLevel.TraceIfNoCause, "Internal error occured during loading of Java class $class$.");

    public LoggedClassNotFoundException(Throwable t, String plugins) {
        this(t);
        this.properties.put(KEY_PLUGINS, plugins);
    }

    public LoggedClassNotFoundException(Throwable t, String clazz, String plugins) {
        super(t, LoggedClassNotFoundException.defineDescriptor(t));
        this.properties.put(KEY_CLASS, clazz);
        if (plugins != null) {
            this.properties.put(KEY_PLUGINS, plugins);
        }
    }

    public LoggedClassNotFoundException(String clazz, String plugins) {
        super(ED_NO_CLASS);
        this.properties.put(KEY_CLASS, clazz);
        if (plugins != null) {
            this.properties.put(KEY_PLUGINS, plugins);
        }
    }

    public LoggedClassNotFoundException(Throwable t) {
        super(t, LoggedClassNotFoundException.defineDescriptor(t));
        if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
            String className = t.getMessage().substring(t.getMessage().lastIndexOf(32) + 1).replace('/', '.');
            this.properties.put(KEY_CLASS, className);
        }
    }

    private static ExceptionDescriptor defineDescriptor(Throwable t) {
        if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
            return ED_NO_CLASS;
        }
        return ED_CLASS_LOAD_ERROR;
    }
}

