/*
 * Decompiled with CFR 0.152.
 */
package ru.biosoft.exception;

import ru.biosoft.exception.ExceptionDescriptor;
import ru.biosoft.exception.LoggedException;

public class InternalException
extends LoggedException {
    public static final String KEY_MESSAGE = "message";
    public static final ExceptionDescriptor ED_INTERNAL = new ExceptionDescriptor("Internal", LoggedException.LoggingLevel.TraceIfNoCause, "Unexpected internal error occured: $message$.");

    private InternalException(Throwable t, ExceptionDescriptor ed, String message) {
        super(t, ed);
        if (message == null) {
            message = t != null ? t.getClass().getSimpleName().toString() + " - " + t.getMessage() : "Unreachable state occurred.";
        }
        this.properties.put(KEY_MESSAGE, message);
    }

    public InternalException(Throwable t) {
        this(t, ED_INTERNAL, null);
    }

    public InternalException(Throwable t, String message) {
        this(t, ED_INTERNAL, message);
    }

    public InternalException(String message) {
        this(null, ED_INTERNAL, message);
    }

    public InternalException() {
        this((Throwable)null, (String)null);
    }
}

